/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.ReflectionAccessFilter;
import com.google.gson.ReflectionAccessFilter$FilterResult;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.ReflectionAccessFilterHelper;
import com.google.gson.internal.TroubleshootingGuide;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$1;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$2;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$BoundField;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$FieldReflectionAdapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$FieldsData;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$RecordAdapter;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final Excluder excluder;
    private final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;
    private final List<ReflectionAccessFilter> reflectionFilters;

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingStrategy, Excluder excluder, JsonAdapterAnnotationTypeAdapterFactory jsonAdapterAnnotationTypeAdapterFactory, List<ReflectionAccessFilter> list) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy = fieldNamingStrategy;
        this.excluder = excluder;
        this.jsonAdapterFactory = jsonAdapterAnnotationTypeAdapterFactory;
        this.reflectionFilters = list;
    }

    private boolean includeField(Field field, boolean bl) {
        return !this.excluder.excludeField(field, bl);
    }

    private List<String> getFieldNames(Field field) {
        SerializedName serializedName = field.getAnnotation(SerializedName.class);
        if (serializedName == null) {
            String string = this.fieldNamingPolicy.translateName(field);
            return Collections.singletonList(string);
        }
        String string = serializedName.value();
        String[] stringArray = serializedName.alternate();
        if (stringArray.length == 0) {
            return Collections.singletonList(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + 1);
        arrayList.add(string);
        Collections.addAll(arrayList, stringArray);
        return arrayList;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        boolean bl;
        Class<T> clazz = typeToken.getRawType();
        if (!Object.class.isAssignableFrom(clazz)) {
            return null;
        }
        if (ReflectionHelper.isAnonymousOrNonStaticLocal(clazz)) {
            return new ReflectiveTypeAdapterFactory$1(this);
        }
        ReflectionAccessFilter$FilterResult reflectionAccessFilter$FilterResult = ReflectionAccessFilterHelper.getFilterResult(this.reflectionFilters, clazz);
        if (reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.BLOCK_ALL) {
            throw new JsonIOException("ReflectionAccessFilter does not permit using reflection for " + clazz + ". Register a TypeAdapter for this type or adjust the access filter.");
        }
        boolean bl2 = bl = reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.BLOCK_INACCESSIBLE;
        if (ReflectionHelper.isRecord(clazz)) {
            ReflectiveTypeAdapterFactory$RecordAdapter<T> reflectiveTypeAdapterFactory$RecordAdapter = new ReflectiveTypeAdapterFactory$RecordAdapter<T>(clazz, this.getBoundFields(gson, typeToken, clazz, bl, true), bl);
            return reflectiveTypeAdapterFactory$RecordAdapter;
        }
        ObjectConstructor<T> objectConstructor = this.constructorConstructor.get(typeToken);
        return new ReflectiveTypeAdapterFactory$FieldReflectionAdapter<T>(objectConstructor, this.getBoundFields(gson, typeToken, clazz, bl, false));
    }

    private static <M extends AccessibleObject> void checkAccessible(Object object, M m) {
        if (!ReflectionAccessFilterHelper.canAccess(m, Modifier.isStatic(((Member)((Object)m)).getModifiers()) ? null : object)) {
            String string = ReflectionHelper.getAccessibleObjectDescription(m, true);
            throw new JsonIOException(string + " is not accessible and ReflectionAccessFilter does not permit making it accessible. Register a TypeAdapter for the declaring type, adjust the access filter or increase the visibility of the element and its declaring type.");
        }
    }

    private ReflectiveTypeAdapterFactory$BoundField createBoundField(Gson gson, Field field, Method method, String string, TypeToken<?> typeToken, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = Primitives.isPrimitive(typeToken.getRawType());
        int n = field.getModifiers();
        boolean bl5 = Modifier.isStatic(n) && Modifier.isFinal(n);
        JsonAdapter jsonAdapter = field.getAnnotation(JsonAdapter.class);
        TypeAdapterRuntimeTypeWrapper typeAdapterRuntimeTypeWrapper = null;
        if (jsonAdapter != null) {
            typeAdapterRuntimeTypeWrapper = this.jsonAdapterFactory.getTypeAdapter(this.constructorConstructor, gson, typeToken, jsonAdapter, false);
        }
        boolean bl6 = bl3 = typeAdapterRuntimeTypeWrapper != null;
        if (typeAdapterRuntimeTypeWrapper == null) {
            typeAdapterRuntimeTypeWrapper = gson.getAdapter(typeToken);
        }
        TypeAdapterRuntimeTypeWrapper typeAdapterRuntimeTypeWrapper2 = typeAdapterRuntimeTypeWrapper;
        TypeAdapterRuntimeTypeWrapper typeAdapterRuntimeTypeWrapper3 = bl ? (bl3 ? typeAdapterRuntimeTypeWrapper2 : new TypeAdapterRuntimeTypeWrapper(gson, typeAdapterRuntimeTypeWrapper2, typeToken.getType())) : typeAdapterRuntimeTypeWrapper2;
        return new ReflectiveTypeAdapterFactory$2(this, string, field, bl2, method, typeAdapterRuntimeTypeWrapper3, typeAdapterRuntimeTypeWrapper2, bl4, bl5);
    }

    private static IllegalArgumentException createDuplicateFieldException(Class<?> clazz, String string, Field field, Field field2) {
        throw new IllegalArgumentException("Class " + clazz.getName() + " declares multiple JSON fields named '" + string + "'; conflict is caused by fields " + ReflectionHelper.fieldToString(field) + " and " + ReflectionHelper.fieldToString(field2) + "\nSee " + TroubleshootingGuide.createUrl("duplicate-fields"));
    }

    private ReflectiveTypeAdapterFactory$FieldsData getBoundFields(Gson gson, TypeToken<?> typeToken, Class<?> clazz, boolean bl, boolean bl2) {
        if (clazz.isInterface()) {
            return ReflectiveTypeAdapterFactory$FieldsData.EMPTY;
        }
        LinkedHashMap<String, ReflectiveTypeAdapterFactory$BoundField> linkedHashMap = new LinkedHashMap<String, ReflectiveTypeAdapterFactory$BoundField>();
        LinkedHashMap<String, ReflectiveTypeAdapterFactory$BoundField> linkedHashMap2 = new LinkedHashMap<String, ReflectiveTypeAdapterFactory$BoundField>();
        Class<?> clazz2 = clazz;
        while (clazz != Object.class) {
            Field[] fieldArray = clazz.getDeclaredFields();
            if (clazz != clazz2 && fieldArray.length > 0) {
                ReflectionAccessFilter$FilterResult reflectionAccessFilter$FilterResult = ReflectionAccessFilterHelper.getFilterResult(this.reflectionFilters, clazz);
                if (reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.BLOCK_ALL) {
                    throw new JsonIOException("ReflectionAccessFilter does not permit using reflection for " + clazz + " (supertype of " + clazz2 + "). Register a TypeAdapter for this type or adjust the access filter.");
                }
                bl = reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.BLOCK_INACCESSIBLE;
            }
            for (Field field : fieldArray) {
                Object object;
                Object object2;
                boolean bl3 = this.includeField(field, true);
                boolean bl4 = this.includeField(field, false);
                if (!bl3 && !bl4) continue;
                Method method = null;
                if (bl2) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        bl4 = false;
                    } else {
                        method = ReflectionHelper.getAccessor(clazz, field);
                        if (!bl) {
                            ReflectionHelper.makeAccessible(method);
                        }
                        if (method.getAnnotation(SerializedName.class) != null && field.getAnnotation(SerializedName.class) == null) {
                            object2 = ReflectionHelper.getAccessibleObjectDescription(method, false);
                            throw new JsonIOException("@SerializedName on " + (String)object2 + " is not supported");
                        }
                    }
                }
                if (!bl && method == null) {
                    ReflectionHelper.makeAccessible(field);
                }
                object2 = $Gson$Types.resolve(typeToken.getType(), clazz, field.getGenericType());
                List<String> list = this.getFieldNames(field);
                String string = list.get(0);
                ReflectiveTypeAdapterFactory$BoundField reflectiveTypeAdapterFactory$BoundField = this.createBoundField(gson, field, method, string, TypeToken.get((Type)object2), bl3, bl);
                if (bl4) {
                    object = list.iterator();
                    while (object.hasNext()) {
                        String string2 = object.next();
                        ReflectiveTypeAdapterFactory$BoundField reflectiveTypeAdapterFactory$BoundField2 = linkedHashMap.put(string2, reflectiveTypeAdapterFactory$BoundField);
                        if (reflectiveTypeAdapterFactory$BoundField2 == null) continue;
                        throw ReflectiveTypeAdapterFactory.createDuplicateFieldException(clazz2, string2, reflectiveTypeAdapterFactory$BoundField2.field, field);
                    }
                }
                if (!bl3 || (object = linkedHashMap2.put(string, reflectiveTypeAdapterFactory$BoundField)) == null) continue;
                throw ReflectiveTypeAdapterFactory.createDuplicateFieldException(clazz2, string, ((ReflectiveTypeAdapterFactory$BoundField)object).field, field);
            }
            typeToken = TypeToken.get($Gson$Types.resolve(typeToken.getType(), clazz, clazz.getGenericSuperclass()));
            clazz = typeToken.getRawType();
        }
        return new ReflectiveTypeAdapterFactory$FieldsData(linkedHashMap, new ArrayList<ReflectiveTypeAdapterFactory$BoundField>(linkedHashMap2.values()));
    }

    static /* synthetic */ void access$000(Object object, AccessibleObject accessibleObject) {
        ReflectiveTypeAdapterFactory.checkAccessible(object, accessibleObject);
    }
}

