/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.request.websockets;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import pro.gravit.launcher.ameNSCrafTnZbs;
import pro.gravit.utils.helper.LogHelper;

public abstract class ClientJSONPoint
implements WebSocket.Listener {
    private static boolean isCertificatePinning;
    private static final AtomicInteger counter;
    private final URI uri;
    public boolean isClosed;
    private final WebSocket.Builder webSocketBuilder;
    protected HttpClient httpClient;
    protected WebSocket webSocket;
    protected boolean ssl = false;
    protected int port;
    private final Object syncObject = new Object();
    private final Object sendSyncObject = new Object();
    private volatile StringBuilder builder = new StringBuilder();

    public ClientJSONPoint(String string) {
        this(URI.create(string));
    }

    public ClientJSONPoint(URI uRI) {
        this.uri = uRI;
        String string = uRI.getScheme();
        if (!"ws".equals(string) && !"wss".equals(string)) {
            throw new IllegalArgumentException("Unsupported protocol: " + string);
        }
        if ("wss".equals(string)) {
            this.ssl = true;
        }
        this.port = uRI.getPort() == -1 ? ("ws".equals(string) ? 80 : 443) : uRI.getPort();
        try {
            HttpClient.Builder builder = HttpClient.newBuilder();
            if (isCertificatePinning) {
                builder = builder.sslContext(ameNSCrafTnZbs.AMenSCraFTKYvO());
            }
            this.httpClient = builder.build();
            this.webSocketBuilder = this.httpClient.newWebSocketBuilder().connectTimeout(Duration.ofSeconds(30L));
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void connect() {
        this.webSocket = this.webSocketBuilder.buildAsync(this.uri, this).get();
    }

    public void openAsync(Runnable runnable, Consumer<Throwable> consumer) {
        ((CompletableFuture)this.webSocketBuilder.buildAsync(this.uri, this).thenAccept(webSocket -> {
            this.webSocket = webSocket;
            runnable.run();
        })).exceptionally(throwable -> {
            consumer.accept((Throwable)throwable);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence charSequence, boolean bl) {
        Object object = this.syncObject;
        synchronized (object) {
            this.builder.append(charSequence);
            if (bl) {
                String string = this.builder.toString();
                this.builder = new StringBuilder();
                LogHelper.dev("Received %s", string);
                this.onMessage(string);
            }
        }
        return WebSocket.Listener.super.onText(webSocket, charSequence, bl);
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int n, String string) {
        this.onDisconnect(n, string);
        return WebSocket.Listener.super.onClose(webSocket, n, string);
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        this.onOpen();
        WebSocket.Listener.super.onOpen(webSocket);
    }

    @Override
    public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer byteBuffer, boolean bl) {
        return WebSocket.Listener.super.onBinary(webSocket, byteBuffer, bl);
    }

    @Override
    public void onError(WebSocket webSocket, Throwable throwable) {
        LogHelper.error(throwable);
        WebSocket.Listener.super.onError(webSocket, throwable);
    }

    public void send(String string) {
        LogHelper.dev("Send %s", string);
        this.webSocket.sendText(string, true);
    }

    abstract void onMessage(String var1);

    abstract void onDisconnect(int var1, String var2);

    abstract void onOpen();

    public void close() {
        this.webSocket.abort();
    }

    static {
        counter = new AtomicInteger();
        isCertificatePinning = false;
    }
}

