/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli;

import eu.midnightdust.lib.config.MidnightConfig;
import io.github.apace100.apoli.integration.PostPowerLoadCallback;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.util.NamespaceAlias;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.mixin.fabric.common.accessor.PowerTypeRegistryAccessor;
import net.merchantpug.apugli.network.ApugliPackets;
import net.merchantpug.apugli.network.s2c.UpdateUrlTexturesPacket;
import net.merchantpug.apugli.power.CustomProjectilePower;
import net.merchantpug.apugli.power.TextureOrUrlPower;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.merchantpug.apugli.util.ApugliConfig;
import net.merchantpug.apugli.util.TextureUtil;

public class ApugliFabric
implements ModInitializer {
    public void onInitialize() {
        FabricLoader.getInstance().getModContainer("apugli").ifPresent(modContainer -> {
            String version = modContainer.getMetadata().getVersion().getFriendlyString();
            if (version.contains("+")) {
                version = version.split("\\+")[0];
            }
            if (version.contains("-")) {
                version = version.split("-")[0];
            }
            Apugli.VERSION = version;
        });
        Apugli.init();
        ApugliPackets.registerC2S();
        ApugliFabric.registerEvents();
        NamespaceAlias.addAlias((String)"ope", (String)"apugli");
        MidnightConfig.init((String)"apugli", ApugliConfig.class);
    }

    public static void registerEvents() {
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register((server, serverResourceManager) -> TextureUtil.getCache().clear());
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> ApugliPackets.sendS2C(new UpdateUrlTexturesPacket(TextureUtil.getCache()), player));
        PostPowerLoadCallback.EVENT.register((powerId, factoryId, isSubPower, json, powerType) -> {
            TextureOrUrlPower texturePower;
            if (!FabricLoader.getInstance().isModLoaded("pehkui") && factoryId.equals((Object)Apugli.asResource("modify_scale"))) {
                Apugli.LOG.warn("Power '" + powerId + "' could not be loaded as it uses the `" + factoryId + "' power type, which requires the Pehkui mod to be present. (skipping).");
                PowerTypeRegistryAccessor.apugli$invokeRemove(powerId);
                return;
            }
            Power power = powerType.create(null);
            if (power instanceof TextureOrUrlPower && (texturePower = (TextureOrUrlPower)power).getTextureUrl() != null) {
                TextureUtil.cachePower(powerId, texturePower);
            } else if (power instanceof CustomProjectilePower.Instance) {
                CustomProjectilePower.Instance projectilePower = (CustomProjectilePower.Instance)power;
                if (ApugliPowers.CUSTOM_PROJECTILE.get().getDataFromPower(projectilePower).isPresent("texture_url")) {
                    ApugliPowers.CUSTOM_PROJECTILE.get().cacheTextureUrl(powerId, projectilePower);
                }
            }
        });
    }
}

