/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.action.factory.bientity;

import io.github.apace100.apoli.util.Space;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.util.RaycastUtil;
import net.minecraft.class_1297;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class RaycastBetweenAction
implements IActionFactory<class_3545<class_1297, class_1297>> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("block_action", Services.ACTION.blockDataType(), null).add("block_condition", Services.CONDITION.blockDataType(), null).add("particle", SerializableDataTypes.PARTICLE_EFFECT_OR_TYPE).add("spacing", SerializableDataTypes.DOUBLE, (Object)0.5);
    }

    @Override
    public void execute(SerializableData.Instance data, class_3545<class_1297, class_1297> pair) {
        double distance = ((class_1297)pair.method_15442()).method_5739((class_1297)pair.method_15441());
        class_243 direction = this.createDirectionVector(((class_1297)pair.method_15442()).method_19538(), ((class_1297)pair.method_15441()).method_19538());
        class_3965 blockHitResult = RaycastUtil.raycastBlock((class_1297)pair.method_15442(), distance, direction, Space.WORLD);
        class_239.class_240 blockHitResultType = blockHitResult.method_17783();
        if (data.isPresent("block_action") && blockHitResultType == class_239.class_240.field_1332) {
            this.createParticlesAtHitPos(data, (class_1297)pair.method_15442(), (class_239)blockHitResult);
            this.onHitBlock(data, (class_1297)pair.method_15442(), blockHitResult);
        } else {
            this.createParticlesAtHitPos(data, (class_1297)pair.method_15442(), (class_239)new class_3966((class_1297)pair.method_15441()));
        }
    }

    protected class_243 createDirectionVector(class_243 pos1, class_243 pos2) {
        return new class_243(pos2.method_10216() - pos1.method_10216(), pos2.method_10214() - pos1.method_10214(), pos2.method_10215() - pos1.method_10215()).method_1029();
    }

    protected void createParticlesAtHitPos(SerializableData.Instance data, class_1297 entity, class_239 hitResult) {
        if (!data.isPresent("particle") || entity.method_37908().method_8608()) {
            return;
        }
        class_2394 particleEffect = (class_2394)data.get("particle");
        double distanceTo = hitResult.method_24801(entity);
        for (double d = data.getDouble("spacing"); d < distanceTo; d += data.getDouble("spacing")) {
            double lerpValue = class_3532.method_15350((double)(d / distanceTo), (double)0.0, (double)1.0);
            ((class_3218)entity.method_37908()).method_14199(particleEffect, class_3532.method_16436((double)lerpValue, (double)entity.method_33571().method_10216(), (double)hitResult.method_17784().method_10216()), class_3532.method_16436((double)lerpValue, (double)entity.method_33571().method_10214(), (double)hitResult.method_17784().method_10214()), class_3532.method_16436((double)lerpValue, (double)entity.method_33571().method_10215(), (double)hitResult.method_17784().method_10215()), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void onHitBlock(SerializableData.Instance data, class_1297 entity, class_3965 result) {
        if (!data.isPresent("block_action") || !Services.CONDITION.checkBlock(data, "block_condition", entity.method_37908(), result.method_17777())) {
            return;
        }
        Services.ACTION.executeBlock(data, "block_action", entity.method_37908(), result.method_17777(), result.method_17780());
    }
}

