/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.action.factory.entity;

import com.google.common.hash.Hashing;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.nio.charset.StandardCharsets;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.merchantpug.apugli.entity.CustomProjectile;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class CustomProjectileAction
implements IActionFactory<class_1297> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("entity_id", SerializableDataTypes.IDENTIFIER).add("texture_location", SerializableDataTypes.IDENTIFIER, null).add("texture_url", SerializableDataTypes.STRING, null).add("count", SerializableDataTypes.INT, (Object)1).add("speed", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.5f)).add("divergence", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("sound", SerializableDataTypes.SOUND_EVENT, null).add("tag", SerializableDataTypes.NBT, null).add("entity_action_before_firing", Services.ACTION.entityDataType(), null).add("bientity_action_after_firing", Services.ACTION.biEntityDataType(), null).add("block_action_on_hit", Services.ACTION.blockDataType(), null).add("bientity_action_on_miss", Services.ACTION.biEntityDataType(), null).add("bientity_action_on_hit", Services.ACTION.biEntityDataType(), null).add("owner_target_bientity_action_on_hit", Services.ACTION.biEntityDataType(), null).add("block_action_cancels_miss_action", SerializableDataTypes.BOOLEAN, (Object)false).add("block_condition", Services.CONDITION.blockDataType(), null).add("bientity_condition", Services.CONDITION.biEntityDataType(), null).add("owner_bientity_condition", Services.CONDITION.biEntityDataType(), null).add("tick_bientity_action", Services.ACTION.biEntityDataType(), null);
    }

    @Override
    public void execute(SerializableData.Instance data, class_1297 entity) {
        if (data.isPresent("sound")) {
            entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), (class_3414)data.get("sound"), class_3419.field_15254, 0.5f, 0.4f / (((class_1309)entity).method_6051().method_43057() * 0.4f + 0.8f));
        }
        for (int i = 0; i < data.getInt("count"); ++i) {
            class_1297 result = this.createProjectile(data, (class_1309)entity);
            if (result == null) continue;
            entity.method_37908().method_8649(result);
            Services.ACTION.executeBiEntity(data, "bientity_action_after_firing", entity, result);
        }
    }

    @Nullable
    protected class_1297 createProjectile(SerializableData.Instance data, class_1309 actor) {
        Services.ACTION.executeEntity(data, "entity_action_before_firing", (class_1297)actor);
        float yaw = actor.method_36454();
        float pitch = actor.method_36455();
        class_243 rotationVec = actor.method_5720();
        class_243 spawnPos = actor.method_19538().method_1031(0.0, (double)actor.method_5751(), 0.0).method_1019(rotationVec);
        CustomProjectile projectile = new CustomProjectile(spawnPos.method_10216(), spawnPos.method_10214(), spawnPos.method_10215(), actor, actor.method_37908());
        projectile.setEntityId(data.getId("entity_id"));
        projectile.method_7432((class_1297)actor);
        projectile.method_24919((class_1297)actor, pitch, yaw, 0.0f, data.getFloat("speed"), data.getFloat("divergence") * 0.075f);
        projectile.setImpactBlockAction(data, "block_action_on_hit");
        projectile.setBlockActionCancelsMissAction(data.getBoolean("block_action_cancels_miss_action"));
        projectile.setMissBiEntityAction(data, "bientity_action_on_miss");
        projectile.setImpactBiEntityAction(data, "bientity_action_on_hit");
        projectile.setOwnerImpactBiEntityAction(data, "owner_target_bientity_action_on_hit");
        projectile.setTextureLocation(data.getId("texture_location"));
        projectile.setBlockCondition(data, "block_condition");
        projectile.setOwnerBiEntityCondition(data, "owner_bientity_condition");
        projectile.setBiEntityCondition(data, "bientity_condition");
        projectile.setTickBiEntityAction(data, "tick_bientity_action");
        if (data.isPresent("texture_url")) {
            projectile.setUrlLocation(CustomProjectileAction.getTextureUrl(data.getString("texture_url")));
        }
        if (data.get("tag") != null) {
            class_2487 mergedTag = projectile.method_5647(new class_2487());
            mergedTag.method_10543((class_2487)data.get("tag"));
            projectile.method_5651(mergedTag);
        }
        return projectile;
    }

    public static class_2960 getTextureUrl(String textureUrl) {
        int sha256Hash = Hashing.sha256().hashString((CharSequence)textureUrl, StandardCharsets.UTF_8).asInt();
        return new class_2960("apugli", "customprojectileaction/" + sha256Hash);
    }
}

