/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.action.factory.entity;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.merchantpug.apugli.access.ExplosionAccess;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.merchantpug.apugli.network.s2c.SyncExplosionPacket;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.registry.ApugliTags;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_5321;
import net.minecraft.class_5362;
import net.minecraft.class_6328;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

@ParametersAreNonnullByDefault
@class_6328
public class ExplodeAction
implements IActionFactory<class_1297> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("power", SerializableDataTypes.FLOAT).add("destruction_type", ApoliDataTypes.BACKWARDS_COMPATIBLE_DESTRUCTION_TYPE, (Object)class_1927.class_4179.field_18687).add("damage_self", SerializableDataTypes.BOOLEAN, (Object)true).add("indestructible", Services.CONDITION.blockDataType(), null).add("destructible", Services.CONDITION.blockDataType(), null).add("create_fire", SerializableDataTypes.BOOLEAN, (Object)false).add("damage_modifier", Services.PLATFORM.getModifierDataType(), null).add("damage_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("knockback_modifier", Services.PLATFORM.getModifierDataType(), null).add("knockback_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("volume_modifier", Services.PLATFORM.getModifierDataType(), null).add("volume_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("pitch_modifier", Services.PLATFORM.getModifierDataType(), null).add("pitch_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("damage_bientity_condition", Services.CONDITION.biEntityDataType(), null).add("use_charged", SerializableDataTypes.BOOLEAN, (Object)false).add("charged_modifier", Services.PLATFORM.getModifierDataType(), null).add("charged_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("spawn_effect_cloud", SerializableDataTypes.BOOLEAN, (Object)false);
    }

    @Override
    public void execute(SerializableData.Instance data, class_1297 entity) {
        if (entity.method_37908().field_9236) {
            return;
        }
        float power = data.getFloat("power");
        if (data.getBoolean("use_charged")) {
            power = this.applyChargedModifiers(data, entity, power);
        }
        this.summonExplosion(data, entity, power);
        this.spawnEffectCloud(data, entity);
    }

    protected float applyChargedModifiers(SerializableData.Instance data, class_1297 entity, float power) {
        if (!(entity instanceof class_1309)) {
            return power;
        }
        class_1309 living = (class_1309)entity;
        ArrayList<Object> chargedModifiers = new ArrayList<Object>();
        if (data.isPresent("charged_modifier")) {
            chargedModifiers.add(data.get("charged_modifier"));
        }
        if (data.isPresent("charged_modifiers")) {
            chargedModifiers.addAll((Collection)data.get("charged_modifiers"));
        }
        if (chargedModifiers.isEmpty()) {
            return power;
        }
        if (((class_1309)entity).method_6026().stream().anyMatch(statusEffectInstance -> class_7923.field_41174.method_29113((Object)statusEffectInstance.method_5579()).isPresent() && class_7923.field_41174.method_40264((class_5321)class_7923.field_41174.method_29113((Object)statusEffectInstance.method_5579()).get()).isPresent() && ((class_6880.class_6883)class_7923.field_41174.method_40264((class_5321)class_7923.field_41174.method_29113((Object)statusEffectInstance.method_5579()).get()).get()).method_40220(ApugliTags.CHARGED_EFFECTS))) {
            return (float)Services.PLATFORM.applyModifiers((class_1297)living, chargedModifiers, (double)data.getFloat("power"));
        }
        return power;
    }

    protected void summonExplosion(SerializableData.Instance data, class_1297 entity, float power) {
        boolean damageSelf = data.getBoolean("damage_self");
        boolean createFire = data.getBoolean("create_fire");
        class_1927.class_4179 destructionType = (class_1927.class_4179)data.get("destruction_type");
        class_5362 calculator = null;
        boolean indestructible = false;
        String blockConditionFieldKey = null;
        if (data.isPresent("destructible")) {
            calculator = this.createBlockConditionedExplosionDamageCalculator(data, "indestructible", entity.method_37908(), false);
            blockConditionFieldKey = "destructible";
        } else if (data.isPresent("indestructible")) {
            calculator = this.createBlockConditionedExplosionDamageCalculator(data, "destructible", entity.method_37908(), true);
            indestructible = true;
            blockConditionFieldKey = "indestructible";
        }
        if (calculator != null) {
            class_1927 explosion = new class_1927(entity.method_37908(), damageSelf ? null : entity, null, calculator, entity.method_23317(), entity.method_23318(), entity.method_23321(), power, createFire, destructionType);
            ((ExplosionAccess)explosion).apugli$setExplosionDamageModifiers(this.getModifiers(data, "damage_modifier", "damage_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionKnockbackModifiers(this.getModifiers(data, "knockback_modifier", "knockback_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionVolumeModifiers(this.getModifiers(data, "volume_modifier", "volume_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionPitchModifiers(this.getModifiers(data, "pitch_modifier", "pitch_modifiers"));
            ((ExplosionAccess)explosion).apugli$setBiEntityPredicate(data.get("damage_bientity_condition"));
            explosion.method_8348();
            explosion.method_8350(false);
            Services.PLATFORM.sendS2CTrackingAndSelf(new SyncExplosionPacket<Object, Object>(entity.method_5628(), entity.method_23317(), entity.method_23318(), entity.method_23321(), this.getModifiers(data, "damage_modifier", "damage_modifiers"), this.getModifiers(data, "knockback_modifier", "knockback_modifiers"), this.getModifiers(data, "volume_modifier", "volume_modifiers"), this.getModifiers(data, "pitch_modifier", "pitch_modifiers"), data.get("damage_bientity_condition"), true, data.get(blockConditionFieldKey), indestructible, power), entity);
        } else {
            class_1927 explosion = new class_1927(entity.method_37908(), entity, null, null, entity.method_23317(), entity.method_23318(), entity.method_23321(), power, createFire, destructionType);
            ((ExplosionAccess)explosion).apugli$setExplosionDamageModifiers(this.getModifiers(data, "damage_modifier", "damage_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionKnockbackModifiers(this.getModifiers(data, "knockback_modifier", "knockback_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionVolumeModifiers(this.getModifiers(data, "volume_modifier", "volume_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionPitchModifiers(this.getModifiers(data, "pitch_modifier", "pitch_modifiers"));
            ((ExplosionAccess)explosion).apugli$setBiEntityPredicate(data.get("damage_bientity_condition"));
            explosion.method_8348();
            explosion.method_8350(false);
            Services.PLATFORM.sendS2CTrackingAndSelf(new SyncExplosionPacket<Object, Object>(entity.method_5628(), entity.method_23317(), entity.method_23318(), entity.method_23321(), this.getModifiers(data, "damage_modifier", "damage_modifiers"), this.getModifiers(data, "knockback_modifier", "knockback_modifiers"), this.getModifiers(data, "volume_modifier", "volume_modifiers"), this.getModifiers(data, "pitch_modifier", "pitch_modifiers"), data.get("damage_bientity_condition"), false, null, false, power), entity);
        }
    }

    private <M> List<M> getModifiers(SerializableData.Instance data, String modifierKey, String modifiersKey) {
        ArrayList modifiers = new ArrayList();
        data.ifPresent(modifiersKey, modifiers::addAll);
        data.ifPresent(modifierKey, modifiers::add);
        return modifiers;
    }

    private class_5362 createBlockConditionedExplosionDamageCalculator(final SerializableData.Instance data, final String fieldName, final class_1937 levelIn, final boolean indestructible) {
        return new class_5362(){

            public Optional<Float> method_29555(class_1927 explosion, class_1922 level, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
                Optional ovr;
                Optional def = super.method_29555(explosion, level, pos, blockState, fluidState);
                Optional<Object> optional = ovr = Services.CONDITION.checkBlock(data, fieldName, levelIn, pos) == indestructible ? Optional.of(Float.valueOf(class_2246.field_10382.method_9520())) : Optional.empty();
                return ovr.isPresent() ? (def.isPresent() ? (((Float)def.get()).floatValue() > ((Float)ovr.get()).floatValue() ? def : ovr) : ovr) : def;
            }
        };
    }

    protected void spawnEffectCloud(SerializableData.Instance data, class_1297 entity) {
        if (!(entity instanceof class_1309)) {
            return;
        }
        Collection collection = ((class_1309)entity).method_6026();
        if (!collection.isEmpty() && data.getBoolean("spawn_effect_cloud")) {
            class_1295 areaEffectCloudEntity = new class_1295(entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321());
            areaEffectCloudEntity.method_5603(2.5f);
            areaEffectCloudEntity.method_5609(-0.5f);
            areaEffectCloudEntity.method_5595(10);
            areaEffectCloudEntity.method_5604(areaEffectCloudEntity.method_5605() / 2);
            areaEffectCloudEntity.method_5596(-areaEffectCloudEntity.method_5599() / (float)areaEffectCloudEntity.method_5605());
            for (class_1293 statusEffectInstance : collection) {
                areaEffectCloudEntity.method_5610(new class_1293(statusEffectInstance));
            }
            entity.method_37908().method_8649((class_1297)areaEffectCloudEntity);
        }
    }
}

