/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.action.factory.entity;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.Space;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.merchantpug.apugli.access.ExplosionAccess;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.merchantpug.apugli.network.s2c.SyncExplosionPacket;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.util.RaycastUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5362;

public class ExplosionRaycastAction
implements IActionFactory<class_1297> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("distance", SerializableDataTypes.DOUBLE, null).add("particle", SerializableDataTypes.PARTICLE_EFFECT_OR_TYPE, null).add("spacing", SerializableDataTypes.DOUBLE, (Object)0.5).add("direction", SerializableDataTypes.VECTOR, null).add("space", ApoliDataTypes.SPACE, (Object)Space.WORLD).add("block_action", Services.ACTION.blockDataType(), null).add("bientity_action", Services.ACTION.biEntityDataType(), null).add("action_on_hit", Services.ACTION.entityDataType(), null).add("power", SerializableDataTypes.FLOAT).add("destruction_type", ApoliDataTypes.BACKWARDS_COMPATIBLE_DESTRUCTION_TYPE, (Object)class_1927.class_4179.field_40878).add("damage_self", SerializableDataTypes.BOOLEAN, (Object)false).add("indestructible", Services.CONDITION.blockDataType(), null).add("destructible", Services.CONDITION.blockDataType(), null).add("create_fire", SerializableDataTypes.BOOLEAN, (Object)false).add("damage_modifier", Services.PLATFORM.getModifierDataType(), null).add("damage_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("knockback_modifier", Services.PLATFORM.getModifierDataType(), null).add("knockback_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("volume_modifier", Services.PLATFORM.getModifierDataType(), null).add("volume_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("pitch_modifier", Services.PLATFORM.getModifierDataType(), null).add("pitch_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("targetable_bientity_condition", Services.CONDITION.biEntityDataType(), null).add("explosion_damage_bientity_condition", Services.CONDITION.biEntityDataType(), null).add("use_charged", SerializableDataTypes.BOOLEAN, (Object)false).add("charged_condition", Services.CONDITION.entityDataType(), null).add("charged_modifier", Services.PLATFORM.getModifierDataType(), null).add("charged_modifiers", Services.PLATFORM.getModifiersDataType(), null);
    }

    @Override
    public void execute(SerializableData.Instance data, class_1297 entity) {
        class_239.class_240 entityHitResultType;
        if (entity.method_37908().field_9236) {
            return;
        }
        double blockDistance = data.isPresent("distance") ? data.getDouble("distance") : Services.PLATFORM.getReachDistance(entity);
        class_3965 blockHitResult = RaycastUtil.raycastBlock(entity, blockDistance, (class_243)data.get("direction"), (Space)data.get("space"));
        class_239.class_240 blockHitResultType = blockHitResult.method_17783();
        double entityDistance = data.isPresent("distance") ? data.getDouble("distance") : Services.PLATFORM.getAttackRange(entity);
        class_3966 entityHitResult = RaycastUtil.raycastEntity(blockHitResult, entity, entityDistance, (class_243)data.get("direction"), (Space)data.get("space"), Services.CONDITION.biEntityPredicate(data, "targetable_bientity_condition"));
        class_239.class_240 class_2402 = entityHitResultType = entityHitResult != null ? entityHitResult.method_17783() : class_239.class_240.field_1333;
        if (entityHitResultType == class_239.class_240.field_1331) {
            this.createParticlesAtHitPos(data, entity, (class_239)entityHitResult);
            this.onHitEntity(data, entity, entityHitResult);
        } else if (blockHitResultType == class_239.class_240.field_1332) {
            this.createParticlesAtHitPos(data, entity, (class_239)blockHitResult);
            this.onHitBlock(data, entity, blockHitResult);
        }
    }

    protected void createParticlesAtHitPos(SerializableData.Instance data, class_1297 entity, class_239 hitResult) {
        if (!data.isPresent("particle") || entity.method_37908().method_8608()) {
            return;
        }
        class_2394 particleEffect = (class_2394)data.get("particle");
        double distanceTo = hitResult.method_24801(entity);
        for (double d = data.getDouble("spacing"); d < distanceTo; d += data.getDouble("spacing")) {
            double lerpValue = class_3532.method_15350((double)(d / distanceTo), (double)0.0, (double)1.0);
            ((class_3218)entity.method_37908()).method_14199(particleEffect, class_3532.method_16436((double)lerpValue, (double)entity.method_23317(), (double)hitResult.method_17784().method_10216()), class_3532.method_16436((double)lerpValue, (double)entity.method_23318(), (double)hitResult.method_17784().method_10214()), class_3532.method_16436((double)lerpValue, (double)entity.method_23321(), (double)hitResult.method_17784().method_10215()), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void onHitBlock(SerializableData.Instance data, class_1297 entity, class_3965 result) {
        if (!data.isPresent("block_action") && !data.isPresent("action_on_hit")) {
            return;
        }
        Services.ACTION.executeBlock(data, "block_action", entity.method_37908(), result.method_17777(), result.method_17780());
        this.summonExplosion(data, entity, (class_239)result);
        this.executeSelfAction(data, entity);
    }

    protected void onHitEntity(SerializableData.Instance data, class_1297 actor, class_3966 result) {
        if (!data.isPresent("bientity_action") && !data.isPresent("action_on_hit")) {
            return;
        }
        class_1297 target = result.method_17782();
        Services.ACTION.executeBiEntity(data, "bientity_action", actor, target);
        this.summonExplosion(data, actor, (class_239)result);
        this.executeSelfAction(data, actor);
    }

    protected void executeSelfAction(SerializableData.Instance data, class_1297 entity) {
        if (!data.isPresent("action_on_hit") || !entity.method_5805()) {
            return;
        }
        Services.ACTION.executeEntity(data, "action_on_hit", entity);
    }

    protected float applyChargedModifiers(SerializableData.Instance data, class_1297 entity, float power) {
        List chargedModifiers = this.getModifiers(data, "charged_modifier", "charged_modifiers");
        if (!chargedModifiers.isEmpty() && Services.CONDITION.checkEntity(data, "charged_condition", entity)) {
            return (float)Services.PLATFORM.applyModifiers(entity, chargedModifiers, (double)data.getFloat("power"));
        }
        return power;
    }

    protected void summonExplosion(SerializableData.Instance data, class_1297 entity, class_239 result) {
        float power = data.getFloat("power");
        if (data.getBoolean("use_charged")) {
            power = this.applyChargedModifiers(data, entity, power);
        }
        boolean damageSelf = data.getBoolean("damage_self");
        boolean createFire = data.getBoolean("create_fire");
        class_1927.class_4179 destructionType = (class_1927.class_4179)data.get("destruction_type");
        class_5362 calculator = null;
        boolean indestructible = false;
        String blockConditionFieldKey = null;
        if (data.isPresent("destructible")) {
            calculator = this.createBlockConditionedExplosionDamageCalculator(data, "indestructible", entity.method_37908(), false);
            blockConditionFieldKey = "destructible";
        } else if (data.isPresent("indestructible")) {
            calculator = this.createBlockConditionedExplosionDamageCalculator(data, "destructible", entity.method_37908(), true);
            indestructible = true;
            blockConditionFieldKey = "indestructible";
        }
        if (calculator != null) {
            class_1927 explosion = new class_1927(entity.method_37908(), damageSelf ? null : entity, null, calculator, result.method_17784().method_10216(), result.method_17784().method_10214(), result.method_17784().method_10215(), power, createFire, destructionType);
            ((ExplosionAccess)explosion).apugli$setExplosionDamageModifiers(this.getModifiers(data, "damage_modifier", "damage_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionKnockbackModifiers(this.getModifiers(data, "knockback_modifier", "knockback_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionVolumeModifiers(this.getModifiers(data, "volume_modifier", "volume_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionPitchModifiers(this.getModifiers(data, "pitch_modifier", "pitch_modifiers"));
            ((ExplosionAccess)explosion).apugli$setBiEntityPredicate(data.get("explosion_damage_bientity_condition"));
            explosion.method_8348();
            explosion.method_8350(false);
            Services.PLATFORM.sendS2CTrackingAndSelf(new SyncExplosionPacket<Object, Object>(entity.method_5628(), result.method_17784().method_10216(), result.method_17784().method_10214(), result.method_17784().method_10215(), this.getModifiers(data, "damage_modifier", "damage_modifiers"), this.getModifiers(data, "knockback_modifier", "knockback_modifiers"), this.getModifiers(data, "volume_modifier", "volume_modifiers"), this.getModifiers(data, "pitch_modifier", "pitch_modifiers"), data.get("explosion_damage_bientity_condition"), true, data.get(blockConditionFieldKey), indestructible, power), entity);
        } else {
            class_1927 explosion = new class_1927(entity.method_37908(), damageSelf ? null : entity, null, null, result.method_17784().method_10216(), result.method_17784().method_10214(), result.method_17784().method_10215(), power, createFire, destructionType);
            ((ExplosionAccess)explosion).apugli$setExplosionDamageModifiers(this.getModifiers(data, "damage_modifier", "damage_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionKnockbackModifiers(this.getModifiers(data, "knockback_modifier", "knockback_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionVolumeModifiers(this.getModifiers(data, "volume_modifier", "volume_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionPitchModifiers(this.getModifiers(data, "pitch_modifier", "pitch_modifiers"));
            ((ExplosionAccess)explosion).apugli$setBiEntityPredicate(data.get("explosion_damage_bientity_condition"));
            explosion.method_8348();
            explosion.method_8350(false);
            Services.PLATFORM.sendS2CTrackingAndSelf(new SyncExplosionPacket<Object, Object>(entity.method_5628(), result.method_17784().method_10216(), result.method_17784().method_10214(), result.method_17784().method_10215(), this.getModifiers(data, "damage_modifier", "damage_modifiers"), this.getModifiers(data, "knockback_modifier", "knockback_modifiers"), this.getModifiers(data, "volume_modifier", "volume_modifiers"), this.getModifiers(data, "pitch_modifier", "pitch_modifiers"), data.get("explosion_damage_bientity_condition"), false, null, false, power), entity);
        }
    }

    private <M> List<M> getModifiers(SerializableData.Instance data, String modifierKey, String modifiersKey) {
        ArrayList modifiers = new ArrayList();
        data.ifPresent(modifiersKey, modifiers::addAll);
        data.ifPresent(modifierKey, modifiers::add);
        return modifiers;
    }

    private class_5362 createBlockConditionedExplosionDamageCalculator(final SerializableData.Instance data, final String fieldName, final class_1937 levelIn, final boolean indestructible) {
        return new class_5362(){

            public Optional<Float> method_29555(class_1927 explosion, class_1922 level, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
                Optional ovr;
                Optional def = super.method_29555(explosion, level, pos, blockState, fluidState);
                Optional<Object> optional = ovr = Services.CONDITION.checkBlock(data, fieldName, levelIn, pos) == indestructible ? Optional.of(Float.valueOf(class_2246.field_10382.method_9520())) : Optional.empty();
                return ovr.isPresent() ? (def.isPresent() ? (((Float)def.get()).floatValue() > ((Float)ovr.get()).floatValue() ? def : ovr) : ovr) : def;
            }
        };
    }
}

