/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.action.factory.entity;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.Space;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.util.RaycastUtil;
import net.minecraft.class_1297;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class RaycastAction
implements IActionFactory<class_1297> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("distance", SerializableDataTypes.DOUBLE, null).add("direction", SerializableDataTypes.VECTOR, null).add("space", ApoliDataTypes.SPACE, (Object)Space.WORLD).add("pierce", SerializableDataTypes.BOOLEAN, (Object)false).add("particle", SerializableDataTypes.PARTICLE_EFFECT_OR_TYPE, null).add("spacing", SerializableDataTypes.DOUBLE, (Object)0.5).add("block_action", Services.ACTION.blockDataType(), null).add("block_condition", Services.CONDITION.blockDataType(), null).add("bientity_action", Services.ACTION.biEntityDataType(), null).add("bientity_condition", Services.CONDITION.biEntityDataType(), null).add("target_action", Services.ACTION.entityDataType(), null).add("target_condition", Services.CONDITION.entityDataType(), null).add("self_action", Services.ACTION.entityDataType(), null);
    }

    @Override
    public void execute(SerializableData.Instance data, class_1297 entity) {
        class_239.class_240 entityHitResultType;
        double blockDistance = data.isPresent("distance") ? data.getDouble("distance") : Services.PLATFORM.getReachDistance(entity);
        class_3965 blockHitResult = RaycastUtil.raycastBlock(entity, blockDistance, (class_243)data.get("direction"), (Space)data.get("space"));
        class_239.class_240 blockHitResultType = blockHitResult.method_17783();
        double entityDistance = data.isPresent("distance") ? data.getDouble("distance") : Services.PLATFORM.getAttackRange(entity);
        class_3966 entityHitResult = RaycastUtil.raycastEntity(blockHitResult, entity, entityDistance, (class_243)data.get("direction"), (Space)data.get("space"), null);
        class_239.class_240 class_2402 = entityHitResultType = entityHitResult != null ? entityHitResult.method_17783() : null;
        if (data.getBoolean("pierce")) {
            List<class_3966> list = RaycastUtil.raycastEntities(entity, traceEntity -> !traceEntity.method_7325() && traceEntity.method_5863(), entityDistance, (class_243)data.get("direction"), (Space)data.get("space"));
            this.handlePierce(data, entity, list);
            return;
        }
        if (entityHitResultType == class_239.class_240.field_1331) {
            this.createParticlesAtHitPos(data, entity, (class_239)entityHitResult);
            this.onHitEntity(data, entity, entityHitResult, false);
            return;
        }
        if (blockHitResultType == class_239.class_240.field_1332) {
            this.createParticlesAtHitPos(data, entity, (class_239)blockHitResult);
            this.onHitBlock(data, entity, blockHitResult);
        }
    }

    protected void createParticlesAtHitPos(SerializableData.Instance data, class_1297 entity, class_239 hitResult) {
        if (!data.isPresent("particle") || entity.method_37908().method_8608()) {
            return;
        }
        class_2394 particleEffect = (class_2394)data.get("particle");
        double distanceTo = hitResult.method_24801(entity);
        for (double d = data.getDouble("spacing"); d < distanceTo; d += data.getDouble("spacing")) {
            double lerpValue = class_3532.method_15350((double)(d / distanceTo), (double)0.0, (double)1.0);
            ((class_3218)entity.method_37908()).method_14199(particleEffect, class_3532.method_16436((double)lerpValue, (double)entity.method_23317(), (double)hitResult.method_17784().method_10216()), class_3532.method_16436((double)lerpValue, (double)entity.method_23318(), (double)hitResult.method_17784().method_10214()), class_3532.method_16436((double)lerpValue, (double)entity.method_23321(), (double)hitResult.method_17784().method_10215()), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void handlePierce(SerializableData.Instance data, class_1297 entity, List<class_3966> list) {
        if (list.isEmpty()) {
            return;
        }
        class_1297 previousEntity = entity;
        for (class_3966 result : list) {
            this.createParticlesAtHitPos(data, previousEntity, (class_239)result);
            previousEntity = result.method_17782();
            this.onHitEntity(data, entity, result, true);
        }
        this.executeSelfAction(data, entity);
    }

    protected void executeSelfAction(SerializableData.Instance data, class_1297 entity) {
        if (!data.isPresent("self_action") || !entity.method_5805()) {
            return;
        }
        Services.ACTION.executeEntity(data, "self_action", entity);
    }

    protected void onHitBlock(SerializableData.Instance data, class_1297 entity, class_3965 result) {
        if (!data.isPresent("block_action") || !Services.CONDITION.checkBlock(data, "block_condition", entity.method_37908(), result.method_17777())) {
            return;
        }
        Services.ACTION.executeBlock(data, "block_action", entity.method_37908(), result.method_17777(), result.method_17780());
        this.executeSelfAction(data, entity);
    }

    protected void onHitEntity(SerializableData.Instance data, class_1297 actor, class_3966 result, boolean calledThroughPierce) {
        boolean hasTargetAction = data.isPresent("target_action");
        boolean hasBiEntityAction = data.isPresent("bientity_action");
        if (Services.CONDITION.checkEntity(data, "target_condition", actor)) {
            return;
        }
        class_1297 target = result.method_17782();
        if (!Services.CONDITION.checkBiEntity(data, "bientity_condition", actor, target)) {
            return;
        }
        if (hasTargetAction) {
            Services.ACTION.executeEntity(data, "target_action", actor);
        }
        if (hasBiEntityAction) {
            Services.ACTION.executeBiEntity(data, "bientity_action", actor, target);
        }
        if (calledThroughPierce) {
            return;
        }
        this.executeSelfAction(data, actor);
    }
}

