/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.client;

import io.github.apace100.apoli.power.Active;
import java.util.HashMap;
import java.util.HashSet;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.merchantpug.apugli.client.renderer.CustomProjectileRenderer;
import net.merchantpug.apugli.client.util.TextureUtilClient;
import net.merchantpug.apugli.component.ApugliEntityComponents;
import net.merchantpug.apugli.component.KeyPressComponent;
import net.merchantpug.apugli.condition.factory.entity.CachedBlockInRadiusCondition;
import net.merchantpug.apugli.mixin.fabric.client.accessor.ApoliClientAccessor;
import net.merchantpug.apugli.network.ApugliPackets;
import net.merchantpug.apugli.network.c2s.UpdateKeysPressedPacket;
import net.merchantpug.apugli.registry.ApugliEntityTypes;
import net.merchantpug.apugli.util.ApugliClassDataClient;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_6344;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class ApugliClientFabric
implements ClientModInitializer {
    private static HashMap<String, Boolean> lastKeyBindingStates = new HashMap();

    public void onInitializeClient() {
        ApugliPackets.registerS2C();
        ApugliClassDataClient.registerAll();
        ClientTickEvents.START_CLIENT_TICK.register(ApugliClientFabric::handleActiveKeys);
        EntityRendererRegistry.register(ApugliEntityTypes.CUSTOM_AREA_EFFECT_CLOUD.get(), class_6344::new);
        EntityRendererRegistry.register(ApugliEntityTypes.CUSTOM_PROJECTILE.get(), CustomProjectileRenderer::new);
        ClientLoginConnectionEvents.DISCONNECT.register((handler, client) -> {
            TextureUtilClient.clear();
            CachedBlockInRadiusCondition.clearCache();
        });
    }

    public static void handleActiveKeys(class_310 minecraft) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        HashSet<Active.Key> addedKeys = new HashSet<Active.Key>();
        HashSet<Active.Key> removedKeys = new HashSet<Active.Key>();
        HashMap currentKeyBindingStates = new HashMap();
        KeyPressComponent component = (KeyPressComponent)ApugliEntityComponents.KEY_PRESS_COMPONENT.get((Object)player);
        if (!component.getKeysToCheck().isEmpty()) {
            if (!ApoliClientAccessor.getInitializedKeyBindingMap()) {
                ApoliClientAccessor.setInitializedKeyBindingMap(true);
                class_310 client = class_310.method_1551();
                for (int i = 0; i < client.field_1690.field_1839.length; ++i) {
                    ApoliClientAccessor.apugli$getIdToKeybindingMap().put(client.field_1690.field_1839[i].method_1431(), client.field_1690.field_1839[i]);
                }
            }
            component.getKeysToCheck().forEach(key -> {
                class_304 keyBinding = ApoliClientAccessor.apugli$getIdToKeybindingMap().get(key.key);
                if (keyBinding != null) {
                    if (!currentKeyBindingStates.containsKey(key.key)) {
                        currentKeyBindingStates.put(key.key, keyBinding.method_1434());
                    }
                    if (currentKeyBindingStates.getOrDefault(key.key, false).booleanValue() && (key.continuous || !lastKeyBindingStates.getOrDefault(key.key, false).booleanValue())) {
                        component.addKey((Active.Key)key);
                        if (!lastKeyBindingStates.getOrDefault(key.key, false).booleanValue()) {
                            addedKeys.add((Active.Key)key);
                        }
                    } else if (!currentKeyBindingStates.getOrDefault(key.key, false).booleanValue() && lastKeyBindingStates.getOrDefault(key.key, false).booleanValue()) {
                        component.removeKey((Active.Key)key);
                        removedKeys.add((Active.Key)key);
                    }
                }
            });
            ApugliPackets.sendC2S(new UpdateKeysPressedPacket(addedKeys, removedKeys));
        }
        lastKeyBindingStates = currentKeyBindingStates;
    }
}

