/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.client.util;

import com.google.common.hash.Hashing;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.mixin.xplatform.client.accessor.TextureManagerAccessor;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.io.IOUtils;

public class TextureUtilClient {
    private static final Map<class_2960, String> URL_SET = new HashMap<class_2960, String>();
    private static final Map<class_2960, String> REGISTERED_TEXTURES = new HashMap<class_2960, String>();
    private static final Map<class_2960, Integer> TEXTURE_TO_SHA256 = new HashMap<class_2960, Integer>();
    private static long fileSizeLimit = Long.MIN_VALUE;
    private static final Map<class_2960, String> TEMP_URL_SET = new HashMap<class_2960, String>();
    private static final Map<class_2960, String> TEMP_REGISTERED_TEXTURES = new HashMap<class_2960, String>();
    private static final Map<class_2960, Integer> TEMP_TEXTURE_TO_SHA256 = new HashMap<class_2960, Integer>();

    public static Map<class_2960, String> getUrls() {
        return URL_SET;
    }

    public static Map<class_2960, String> getRegisteredTextures() {
        return REGISTERED_TEXTURES;
    }

    public static void clearMaps() {
        URL_SET.clear();
        REGISTERED_TEXTURES.clear();
        TEXTURE_TO_SHA256.clear();
    }

    public static void registerPowerTexture(class_2960 textureId, String url, boolean refresh) {
        byte[] bytes = TextureUtilClient.readTextureFromUrl(url);
        if (bytes == null) {
            return;
        }
        int sha256Hash = Hashing.sha256().hashBytes(bytes).asInt();
        if (!TEXTURE_TO_SHA256.containsKey(textureId) || !TEXTURE_TO_SHA256.get(textureId).equals(sha256Hash) || refresh) {
            class_1043 nativeImageBacked;
            class_1044 class_10442;
            class_1011 texture;
            try {
                texture = class_1011.method_4309((InputStream)new ByteArrayInputStream(bytes));
            }
            catch (IOException e) {
                Apugli.LOG.warn("Could not read texture '" + url + "' from input: ", (Throwable)e);
                return;
            }
            class_1060 manager = class_310.method_1551().method_1531();
            if (!refresh && ((TextureManagerAccessor)manager).apugli$getTextures().containsKey(textureId) && (class_10442 = ((TextureManagerAccessor)manager).apugli$getTextures().get(textureId)) instanceof class_1043) {
                class_1043 existingTexture = (class_1043)class_10442;
                existingTexture.method_4526(texture);
                existingTexture.method_4524();
                nativeImageBacked = existingTexture;
            } else {
                nativeImageBacked = new class_1043(texture);
            }
            class_310.method_1551().method_1531().method_4616(textureId, (class_1044)nativeImageBacked);
            TEMP_TEXTURE_TO_SHA256.put(textureId, sha256Hash);
            TEMP_REGISTERED_TEXTURES.put(textureId, url);
            TEMP_URL_SET.put(textureId, url);
        } else if (TEXTURE_TO_SHA256.get(textureId).equals(sha256Hash)) {
            TEMP_TEXTURE_TO_SHA256.put(textureId, sha256Hash);
            TEMP_REGISTERED_TEXTURES.put(textureId, url);
            TEMP_URL_SET.put(textureId, url);
        }
    }

    public static boolean doesTextureExist(class_2960 id) {
        return ((TextureManagerAccessor)class_310.method_1551().method_1531()).apugli$getTextures().containsKey(id);
    }

    public static void update() {
        TextureUtilClient.putTempValuesInMain();
        TextureUtilClient.clearNoLongerPresent();
        TextureUtilClient.clearTempMaps();
        fileSizeLimit = Long.MIN_VALUE;
    }

    private static void putTempValuesInMain() {
        URL_SET.putAll(TEMP_URL_SET);
        REGISTERED_TEXTURES.putAll(TEMP_REGISTERED_TEXTURES);
        TEXTURE_TO_SHA256.putAll(TEMP_TEXTURE_TO_SHA256);
    }

    public static void clearNoLongerPresent() {
        URL_SET.entrySet().removeIf(entry -> !TEMP_URL_SET.containsKey(entry.getKey()));
        REGISTERED_TEXTURES.entrySet().removeIf(entry -> !TEMP_REGISTERED_TEXTURES.containsKey(entry.getKey()));
        TEXTURE_TO_SHA256.entrySet().removeIf(entry -> !TEMP_TEXTURE_TO_SHA256.containsKey(entry.getKey()));
    }

    private static void clearTempMaps() {
        TEMP_URL_SET.clear();
        TEMP_REGISTERED_TEXTURES.clear();
        TEMP_TEXTURE_TO_SHA256.clear();
    }

    public static void clear() {
        for (class_2960 id : REGISTERED_TEXTURES.keySet()) {
            class_310.method_1551().method_1531().method_4615(id);
        }
        TextureUtilClient.clearMaps();
        fileSizeLimit = Long.MIN_VALUE;
    }

    @Nullable
    public static byte[] readTextureFromUrl(String url) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection(class_310.method_1551().method_1487());
            connection.addRequestProperty("Content-Type", "image/png");
            connection.setConnectTimeout(Services.CONFIG.getFileConnectionTimeout());
            connection.setDoInput(true);
            connection.setDoOutput(false);
            if (connection.getContentLengthLong() > TextureUtilClient.getFileSizeLimit()) {
                Apugli.LOG.warn("Tried to get texture from URL but it was too large. Increase the Apugli config's file size limit value if necessary.");
                return null;
            }
            InputStream inputStream = connection.getInputStream();
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (Exception e) {
            Apugli.LOG.warn("Could not get texture from URL: ", (Throwable)e);
            return null;
        }
    }

    public static long getFileSizeLimit() {
        if (fileSizeLimit != Long.MIN_VALUE) {
            return fileSizeLimit;
        }
        fileSizeLimit = 0x40000000L;
        try {
            String limit = Services.CONFIG.getFileSizeLimit().toUpperCase(Locale.ROOT);
            if (limit.endsWith("MB") && Pattern.matches("[0-9]+", limit.split("MB")[0])) {
                fileSizeLimit = Long.parseLong(Services.CONFIG.getFileSizeLimit().split("MB")[0]) * 1024L * 1024L;
            } else if (limit.endsWith("KB") && Pattern.matches("[0-9]+", limit.split("KB")[0])) {
                fileSizeLimit = Long.parseLong(Services.CONFIG.getFileSizeLimit().split("KB")[0]) * 1024L;
            } else if (limit.endsWith("B") && Pattern.matches("[0-9]+", limit.split("B")[0])) {
                fileSizeLimit = Long.parseLong(Services.CONFIG.getFileSizeLimit().split("B")[0]);
            } else {
                Apugli.LOG.warn("Could not parse File Size Limit in Apugli config, setting to 1MB.");
            }
        }
        catch (NumberFormatException ex) {
            Apugli.LOG.warn("Could not parse File Size Limit in Apugli config, setting to 1MB.", (Throwable)ex);
        }
        return fileSizeLimit;
    }
}

