/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.component;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.merchantpug.apugli.component.HitsOnTargetComponent;
import net.merchantpug.apugli.network.ApugliPackets;
import net.merchantpug.apugli.network.s2c.SyncHitsOnTargetLessenedPacket;
import net.merchantpug.apugli.util.ApugliConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class HitsOnTargetComponentImpl
implements HitsOnTargetComponent,
AutoSyncedComponent {
    private Map<Integer, class_3545<Integer, Integer>> previousHits = new HashMap<Integer, class_3545<Integer, Integer>>();
    private Map<Integer, class_3545<Integer, Integer>> hits = new HashMap<Integer, class_3545<Integer, Integer>>();
    private final class_1309 provider;

    public HitsOnTargetComponentImpl(class_1309 provider) {
        this.provider = provider;
    }

    public boolean shouldSyncWith(class_3222 player) {
        return player == this.provider || PlayerLookup.tracking((class_1297)this.provider).contains(player);
    }

    public void readFromNbt(class_2487 tag) {
    }

    public void writeToNbt(class_2487 tag) {
    }

    public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
        buf.writeInt(this.hits.size());
        this.hits.forEach((entityId, value) -> {
            buf.writeInt(entityId.intValue());
            buf.writeInt(((Integer)value.method_15442()).intValue());
            buf.writeInt(((Integer)value.method_15441()).intValue());
        });
    }

    public void applySyncPacket(class_2540 buf) {
        int hitsSize = buf.readInt();
        HashMap<Integer, class_3545<Integer, Integer>> hits = new HashMap<Integer, class_3545<Integer, Integer>>();
        for (int i = 0; i < hitsSize; ++i) {
            int otherEntityId = buf.readInt();
            int amount = buf.readInt();
            int ticksLeft = buf.readInt();
            hits.put(otherEntityId, (class_3545<Integer, Integer>)new class_3545((Object)amount, (Object)ticksLeft));
        }
        this.hits = hits;
    }

    @Override
    public Map<Integer, class_3545<Integer, Integer>> getHits() {
        return this.hits;
    }

    @Override
    public Map<Integer, class_3545<Integer, Integer>> getPreviousHits() {
        return this.previousHits;
    }

    @Override
    public void setHits(int entityId, int hitValue, int timer) {
        this.hits.put(entityId, (class_3545<Integer, Integer>)new class_3545((Object)hitValue, (Object)timer));
    }

    @Override
    public void removeHits(int entityId) {
        this.hits.remove(entityId);
    }

    public void serverTick() {
        Iterator<Map.Entry<Integer, class_3545<Integer, Integer>>> it = this.hits.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, class_3545<Integer, Integer>> entry = it.next();
            class_1297 entity = this.provider.method_37908().method_8469(entry.getKey().intValue());
            int hitAmount = (Integer)entry.getValue().method_15442();
            int currentTime = (Integer)entry.getValue().method_15441();
            if (entity == null || !entity.method_5805() || currentTime > ApugliConfig.resetTimerTicks) {
                class_1309 class_13092;
                it.remove();
                if (it.hasNext() || !((class_13092 = this.provider) instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)class_13092;
                ApugliPackets.sendS2CTrackingAndSelf(new SyncHitsOnTargetLessenedPacket(this.provider.method_5628(), this.previousHits, this.hits), serverPlayer);
                continue;
            }
            entry.setValue((class_3545<Integer, Integer>)new class_3545((Object)hitAmount, (Object)(currentTime + 1)));
        }
        this.previousHits = this.hits;
    }
}

