/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.component;

import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.Power;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.merchantpug.apugli.component.KeyPressComponent;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class KeyPressComponentImpl
implements KeyPressComponent,
CommonTickingComponent {
    private int previousPowerSize = 0;
    private final Set<Active.Key> keysToCheck = new HashSet<Active.Key>();
    private Set<Active.Key> previouslyUsedKeys = new HashSet<Active.Key>();
    private final Set<Active.Key> currentlyUsedKeys = new HashSet<Active.Key>();
    private final class_1657 provider;

    public KeyPressComponentImpl(class_1657 provider) {
        this.provider = provider;
    }

    public void readFromNbt(class_2487 tag) {
    }

    public void writeToNbt(class_2487 tag) {
    }

    @Override
    public Set<Active.Key> getCurrentlyUsedKeys() {
        return this.currentlyUsedKeys;
    }

    @Override
    public Set<Active.Key> getPreviouslyUsedKeys() {
        return this.previouslyUsedKeys;
    }

    @Override
    public void setPreviouslyUsedKeys() {
        this.previouslyUsedKeys = this.currentlyUsedKeys.stream().filter(key -> key.continuous).collect(Collectors.toSet());
    }

    @Override
    public Set<Active.Key> getKeysToCheck() {
        return this.keysToCheck;
    }

    @Override
    public void addKeyToCheck(Active.Key key) {
        this.keysToCheck.add(key);
    }

    @Override
    public void addKey(Active.Key key) {
        this.currentlyUsedKeys.add(key);
    }

    @Override
    public void removeKey(Active.Key key) {
        this.currentlyUsedKeys.remove(key);
    }

    public void tick() {
        int powerSize = ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.provider)).getPowers(Power.class, true).size();
        if (this.previousPowerSize != powerSize) {
            this.keysToCheck.clear();
            this.previouslyUsedKeys.clear();
            this.currentlyUsedKeys.clear();
        }
        this.previousPowerSize = powerSize;
    }

    public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
        buf.writeInt(this.currentlyUsedKeys.size());
        for (Active.Key key : this.currentlyUsedKeys) {
            ApoliDataTypes.KEY.send(buf, (Object)key);
        }
        buf.writeInt(this.previouslyUsedKeys.size());
        for (Active.Key key : this.previouslyUsedKeys) {
            ApoliDataTypes.KEY.send(buf, (Object)key);
        }
    }

    public void applySyncPacket(class_2540 buf) {
        int keysToAddSize = buf.readInt();
        for (int i = 0; i < keysToAddSize; ++i) {
            this.currentlyUsedKeys.add((Active.Key)ApoliDataTypes.KEY.receive(buf));
        }
        int previousKeysToAddSize = buf.readInt();
        for (int i = 0; i < previousKeysToAddSize; ++i) {
            this.previouslyUsedKeys.add((Active.Key)ApoliDataTypes.KEY.receive(buf));
        }
    }
}

