/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.condition.factory.entity;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.apoli.util.Shape;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.merchantpug.apugli.condition.factory.IConditionFactory;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3545;

public class CachedBlockInRadiusCondition
implements IConditionFactory<class_1297> {
    private static final Map<class_2338, Map<SerializableData.Instance, Boolean>> CHECKED_BLOCK_POS_CACHE = new ConcurrentHashMap<class_2338, Map<SerializableData.Instance, Boolean>>();
    private static final Map<class_2338, Map<SerializableData.Instance, class_3545<Collection<class_2338>, Boolean>>> FINAL_VALUE_CACHE = new ConcurrentHashMap<class_2338, Map<SerializableData.Instance, class_3545<Collection<class_2338>, Boolean>>>();
    private static final Map<SerializableData.Instance, Map<class_1297, Integer>> ENTITIES = new HashMap<SerializableData.Instance, Map<class_1297, Integer>>();

    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("block_condition", Services.CONDITION.blockDataType(), null).add("radius", SerializableDataTypes.INT).add("shape", SerializableDataType.enumValue(Shape.class), (Object)Shape.CUBE).add("compare_to", SerializableDataTypes.INT, (Object)1).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL);
    }

    @Override
    public boolean check(SerializableData.Instance data, class_1297 entity) {
        int invalidationDistance = data.getInt("radius") * data.getInt("radius") * 2;
        ENTITIES.computeIfAbsent(data, instance -> new ConcurrentHashMap());
        if (!ENTITIES.get(data).containsKey(entity)) {
            ENTITIES.get(data).put(entity, 0);
        }
        for (class_2338 class_23382 : CHECKED_BLOCK_POS_CACHE.keySet()) {
            if (!ENTITIES.get(data).keySet().stream().allMatch(e -> e.method_5707(pos.method_46558()) >= (double)invalidationDistance)) continue;
            CachedBlockInRadiusCondition.invalidate(class_23382, data);
        }
        for (Map.Entry entry : ENTITIES.get(data).entrySet()) {
            if ((Integer)entry.getValue() > ENTITIES.get(data).size()) {
                ENTITIES.get(data).remove(entry.getKey());
                continue;
            }
            entry.setValue((Integer)entry.getValue() + 1);
            if (entry.getKey() != entity) continue;
            entry.setValue(0);
        }
        return CachedBlockInRadiusCondition.getReturnValue(entity.method_37908(), entity.method_24515(), data);
    }

    public static void invalidate(class_2338 pos, SerializableData.Instance data) {
        if (CHECKED_BLOCK_POS_CACHE.containsKey(pos) && CHECKED_BLOCK_POS_CACHE.get(pos) != null) {
            CHECKED_BLOCK_POS_CACHE.get(pos).remove(data);
            if (CHECKED_BLOCK_POS_CACHE.get(pos).isEmpty()) {
                CHECKED_BLOCK_POS_CACHE.remove(pos);
            }
        }
        for (Map.Entry<class_2338, Map<SerializableData.Instance, class_3545<Collection<class_2338>, Boolean>>> entry : FINAL_VALUE_CACHE.entrySet()) {
            if (!entry.getValue().containsKey(data) || !((Collection)entry.getValue().get(data).method_15442()).contains(pos)) continue;
            FINAL_VALUE_CACHE.get(entry.getKey()).remove(data);
            if (!FINAL_VALUE_CACHE.get(entry.getKey()).isEmpty()) break;
            FINAL_VALUE_CACHE.remove(entry.getKey());
            break;
        }
    }

    public static void invalidate(class_2338 pos) {
        CHECKED_BLOCK_POS_CACHE.remove(pos);
        for (Map.Entry<class_2338, Map<SerializableData.Instance, class_3545<Collection<class_2338>, Boolean>>> entry : FINAL_VALUE_CACHE.entrySet()) {
            for (SerializableData.Instance data : entry.getValue().keySet()) {
                if (!((Collection)entry.getValue().get(data).method_15442()).contains(pos)) continue;
                FINAL_VALUE_CACHE.remove(entry.getKey());
            }
        }
    }

    public static void clearCache() {
        CHECKED_BLOCK_POS_CACHE.clear();
        FINAL_VALUE_CACHE.clear();
        ENTITIES.clear();
    }

    public static boolean getReturnValue(class_1937 level, class_2338 center, SerializableData.Instance data) {
        if (FINAL_VALUE_CACHE.containsKey(center) && FINAL_VALUE_CACHE.get(center).containsKey(data)) {
            return (Boolean)FINAL_VALUE_CACHE.get(center).get(data).method_15441();
        }
        Comparison comparison = (Comparison)data.get("comparison");
        int compareTo = data.getInt("compare_to");
        Shape shape = (Shape)data.get("shape");
        int radius = data.getInt("radius");
        HashSet<class_2338> collection = new HashSet<class_2338>();
        int count = 0;
        int stopAt = -1;
        switch (comparison) {
            case EQUAL: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: {
                stopAt = compareTo + 1;
                break;
            }
            case LESS_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                stopAt = compareTo;
            }
        }
        block4: for (int r = 0; r <= radius; ++r) {
            if (r == 0) {
                if ((count = CachedBlockInRadiusCondition.incrementCountIfPosCheck(count, center, level, data, collection)) != stopAt) continue;
                break;
            }
            for (int j = 0; j < 3; ++j) {
                class_2382 tangent2;
                class_2382 tangent1;
                class_2382 direction;
                class_2382 class_23822 = j == 0 ? new class_2382(0, 1, 0) : (direction = j == 1 ? new class_2382(1, 0, 0) : new class_2382(0, 0, 1));
                if (j == 0) {
                    tangent1 = new class_2382(1, 0, 0);
                    tangent2 = new class_2382(0, 0, 1);
                } else {
                    tangent1 = direction.method_10259(new class_2382(0, 1, 0));
                    tangent2 = new class_2382(0, 1, 0);
                }
                int offset = j == 0 ? 0 : 1;
                for (int l1 = -r + offset; l1 <= r; ++l1) {
                    for (int l2 = -r + offset; l2 <= r - offset; ++l2) {
                        class_2338 negativeOffsetPos;
                        class_2338 offsetPos;
                        class_2382 p = direction.method_35862(r);
                        p = p.method_35853(tangent1.method_35862(l1));
                        p = p.method_35853(tangent2.method_35862(l2));
                        if (!(shape != Shape.CUBE && shape != Shape.CHEBYSHEV && (shape != Shape.SPHERE && shape != Shape.EUCLIDEAN || p.method_10263() * p.method_10263() + p.method_10264() * p.method_10264() + p.method_10260() * p.method_10260() > radius * radius) && Math.abs(p.method_10263()) + Math.abs(p.method_10264()) + Math.abs(p.method_10260()) > radius || (count = CachedBlockInRadiusCondition.incrementCountIfPosCheck(count, offsetPos = center.method_10081(p), level, data, collection)) != stopAt && (count = CachedBlockInRadiusCondition.incrementCountIfPosCheck(count, negativeOffsetPos = center.method_10081(p.method_35862(-1)), level, data, collection)) != stopAt)) break;
                    }
                    if (count == stopAt) break;
                }
                if (count == stopAt) continue block4;
            }
        }
        Map cache = FINAL_VALUE_CACHE.computeIfAbsent(center, pos -> new ConcurrentHashMap());
        int finalCount = count;
        class_3545 cacheValue = cache.computeIfAbsent(data, d -> new class_3545((Object)collection, (Object)comparison.compare((double)finalCount, (double)compareTo)));
        return (Boolean)cacheValue.method_15441();
    }

    private static int incrementCountIfPosCheck(int currentCount, class_2338 pos, class_1937 level, SerializableData.Instance data, Collection<class_2338> collection) {
        Map cache = CHECKED_BLOCK_POS_CACHE.computeIfAbsent(pos, p -> new ConcurrentHashMap());
        boolean bl = cache.computeIfAbsent(data, d -> Services.CONDITION.checkBlock((SerializableData.Instance)d, "block_condition", level, pos));
        collection.add(pos);
        if (bl) {
            ++currentCount;
        }
        return currentCount;
    }
}

