/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.entity;

import io.github.apace100.calio.data.SerializableData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.merchantpug.apugli.mixin.xplatform.common.accessor.AreaEffectCloudEntityAccessor;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.registry.ApugliEntityTypes;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class CustomAreaEffectCloud
extends class_1295 {
    private static final class_2940<String> DATA_ENTITY_ID = class_2945.method_12791(CustomAreaEffectCloud.class, (class_2941)class_2943.field_13326);
    private final List<class_2960> powersToApply = new ArrayList<class_2960>();
    private Object ownerCloudBiEntityAction;
    private Object ownerTargetBiEntityAction;
    private Object cloudTargetBiEntityAction;
    private Object biEntityCondition;
    private Object ownerTargetBiEntityCondition;
    private double heightIncrease = 0.0;
    private final Map<class_1309, Integer> victims = new HashMap<class_1309, Integer>();

    public CustomAreaEffectCloud(class_1299<CustomAreaEffectCloud> entityType, class_1937 world) {
        super(entityType, world);
        this.field_5960 = true;
    }

    public CustomAreaEffectCloud(class_1937 world, double x, double y, double z) {
        this(ApugliEntityTypes.CUSTOM_AREA_EFFECT_CLOUD.get(), world);
        this.method_5814(x, y, z);
    }

    public void method_5650(class_1297.class_5529 reason) {
        for (Map.Entry<class_1309, Integer> next : this.victims.entrySet()) {
            for (class_2960 power : this.powersToApply) {
                Services.POWER.revokePower(power, this.getEntityId(), next.getKey());
            }
        }
        super.method_5650(reason);
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(DATA_ENTITY_ID, (Object)"");
    }

    public void setHeightIncrease(double value) {
        this.heightIncrease = value;
    }

    public void setOwnerCloudBiEntityAction(SerializableData.Instance data, String fieldName) {
        this.ownerCloudBiEntityAction = data.get(fieldName);
    }

    public void setOwnerTargetBiEntityAction(SerializableData.Instance data, String fieldName) {
        this.ownerTargetBiEntityAction = data.get(fieldName);
    }

    public void setCloudTargetBiEntityAction(SerializableData.Instance data, String fieldName) {
        this.cloudTargetBiEntityAction = data.get(fieldName);
    }

    public void setBiEntityCondition(SerializableData.Instance data, String fieldName) {
        this.biEntityCondition = data.get(fieldName);
    }

    public void setOwnerTargetBiEntityCondition(SerializableData.Instance data, String fieldName) {
        this.ownerTargetBiEntityCondition = data.get(fieldName);
    }

    public <P> void addPowerToApply(P value) {
        class_2960 location = Services.POWER.getPowerFromParameter(value);
        if (location == null) {
            return;
        }
        this.powersToApply.add(location);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (!((String)this.method_5841().method_12789(DATA_ENTITY_ID)).equals("")) {
            compound.method_10582("EntityId", (String)this.method_5841().method_12789(DATA_ENTITY_ID));
        }
        compound.method_10549("HeightIncrease", this.heightIncrease);
        Services.CONDITION.writeBiEntityConditionToNbt(compound, "BiEntityCondition", this.biEntityCondition);
        Services.ACTION.writeBiEntityActionToNbt(compound, "OwnerCloudBiEntityAction", this.ownerCloudBiEntityAction);
        Services.ACTION.writeBiEntityActionToNbt(compound, "OwnerTargetBiEntityAction", this.ownerTargetBiEntityAction);
        Services.ACTION.writeBiEntityActionToNbt(compound, "CloudTargetBiEntityAction", this.cloudTargetBiEntityAction);
        class_2499 powerTag = new class_2499();
        for (class_2960 power : this.powersToApply) {
            powerTag.add((Object)class_2519.method_23256((String)power.toString()));
        }
        if (!powerTag.isEmpty()) {
            compound.method_10566("PowersToApply", (class_2520)powerTag);
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10573("EntityId", 8)) {
            this.method_5841().method_12778(DATA_ENTITY_ID, (Object)compound.method_10558("EntityId"));
        }
        this.heightIncrease = compound.method_10574("HeightIncrease");
        this.biEntityCondition = Services.CONDITION.readBiEntityConditionFromNbt(compound, "BiEntityCondition");
        this.ownerCloudBiEntityAction = Services.ACTION.readBiEntityActionFromNbt(compound, "OwnerCloudBiEntityAction");
        this.ownerTargetBiEntityAction = Services.ACTION.readBiEntityActionFromNbt(compound, "OwnerTargetBiEntityAction");
        this.cloudTargetBiEntityAction = Services.ACTION.readBiEntityActionFromNbt(compound, "CloudTargetBiEntityAction");
        if (compound.method_10573("PowersToApply", 9)) {
            class_2499 powerTag = compound.method_10554("PowersToApply", 8);
            for (class_2520 tag : powerTag) {
                this.powersToApply.add(new class_2960(tag.method_10714()));
            }
        }
    }

    public class_2960 getEntityId() {
        return new class_2960((String)this.method_5841().method_12789(DATA_ENTITY_ID));
    }

    public void setEntityId(class_2960 location) {
        this.method_5841().method_12778(DATA_ENTITY_ID, (Object)location.toString());
    }

    private boolean isOwnerRemovedOrDiscarded() {
        AreaEffectCloudEntityAccessor accessor = (AreaEffectCloudEntityAccessor)((Object)this);
        if (accessor.apugli$getOwner() == null) {
            return false;
        }
        return accessor.apugli$getOwner().method_35049() == class_1297.class_5529.field_26998 || accessor.apugli$getOwner().method_35049() == class_1297.class_5529.field_26999;
    }

    public void method_5773() {
        super.method_5773();
        boolean bl = this.method_5611();
        float f = this.method_5599();
        if (this.method_37908().field_9236) {
            float g;
            int i;
            if (bl && this.field_5974.method_43056()) {
                return;
            }
            class_2394 particleOptions = this.method_5600();
            if (bl) {
                i = 2;
                g = 0.2f;
            } else {
                i = class_3532.method_15386((float)((float)Math.PI * f * f));
                g = f;
            }
            for (int j = 0; j < i; ++j) {
                double p;
                double o;
                double n;
                float h = this.field_5974.method_43057() * ((float)Math.PI * 2);
                float k = class_3532.method_15355((float)this.field_5974.method_43057()) * g;
                double d = this.method_23317() + (double)(class_3532.method_15362((float)h) * k);
                double e = this.method_23318();
                double l = this.method_23321() + (double)(class_3532.method_15374((float)h) * k);
                if (particleOptions.method_10295() != class_2398.field_11226) {
                    if (bl) {
                        n = 0.0;
                        o = 0.0;
                        p = 0.0;
                    } else {
                        n = (0.5 - this.field_5974.method_43058()) * 0.15;
                        o = 0.01f;
                        p = (0.5 - this.field_5974.method_43058()) * 0.15;
                    }
                } else {
                    int m = bl && this.field_5974.method_43056() ? 0xFFFFFF : this.method_5606();
                    n = (float)(m >> 16 & 0xFF) / 255.0f;
                    o = (float)(m >> 8 & 0xFF) / 255.0f;
                    p = (float)(m & 0xFF) / 255.0f;
                }
                this.method_37908().method_8494(particleOptions, d, e, l, n, o, p);
            }
        } else {
            boolean bl2;
            if (this.isOwnerRemovedOrDiscarded()) {
                this.method_31472();
                return;
            }
            if (this.field_6012 >= this.method_35047() + this.method_5605()) {
                this.method_31472();
                return;
            }
            boolean bl3 = bl2 = this.field_6012 < this.method_35047();
            if (bl != bl2) {
                this.method_5598(bl2);
            }
            if (bl2) {
                return;
            }
            if (this.method_35045() != 0.0f) {
                if ((f += this.method_35045()) < 0.5f) {
                    this.method_31472();
                    return;
                }
                this.method_5603(f);
            }
            if (this.field_6012 % 5 == 0) {
                List list2 = this.method_37908().method_18467(class_1309.class, this.method_5829().method_1012(0.0, this.heightIncrease, 0.0));
                Iterator<Map.Entry<class_1309, Integer>> victimIterator = this.victims.entrySet().iterator();
                while (victimIterator.hasNext()) {
                    Map.Entry<class_1309, Integer> next = victimIterator.next();
                    if (this.field_6012 < next.getValue() || list2.contains(next.getKey())) continue;
                    for (class_2960 power : this.powersToApply) {
                        Services.POWER.revokePower(power, this.getEntityId(), next.getKey());
                    }
                    victimIterator.remove();
                }
                if (!list2.isEmpty() && !this.method_31481()) {
                    Iterator var27 = list2.iterator();
                    while (true) {
                        double r;
                        double q;
                        double s;
                        if (!var27.hasNext()) {
                            return;
                        }
                        class_1309 livingEntity = (class_1309)var27.next();
                        if (!Services.CONDITION.checkBiEntity(this.biEntityCondition, (class_1297)this, (class_1297)livingEntity) || !Services.CONDITION.checkBiEntity(this.ownerTargetBiEntityCondition, (class_1297)this.method_5601(), (class_1297)livingEntity) || !((s = (q = livingEntity.method_23317() - this.method_23317()) * q + (r = livingEntity.method_23321() - this.method_23321()) * r) <= (double)(f * f))) continue;
                        this.victims.put(livingEntity, this.field_6012 + ((AreaEffectCloudEntityAccessor)((Object)this)).apugli$getReapplicationDelay());
                        for (class_2960 power : this.powersToApply) {
                            if (Services.POWER.hasPowerType(power, this.getEntityId(), livingEntity)) continue;
                            Services.POWER.grantPower(power, this.getEntityId(), livingEntity);
                        }
                        Services.ACTION.executeBiEntity(this.ownerCloudBiEntityAction, (class_1297)this.method_5601(), (class_1297)this);
                        Services.ACTION.executeBiEntity(this.ownerTargetBiEntityAction, (class_1297)this.method_5601(), (class_1297)livingEntity);
                        Services.ACTION.executeBiEntity(this.cloudTargetBiEntityAction, (class_1297)this, (class_1297)livingEntity);
                        if (this.method_35044() != 0.0f) {
                            if ((f += this.method_35044()) < 0.5f) {
                                this.method_31472();
                                return;
                            }
                            this.method_5603(f);
                        }
                        if (this.method_35046() == 0) continue;
                        this.method_5604(this.method_5605() + this.method_35046());
                        if (this.method_5605() <= 0) break;
                    }
                    this.method_31472();
                    return;
                }
            }
        }
    }
}

