/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.integration.pehkui;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.access.ScaleDataAccess;
import net.merchantpug.apugli.integration.pehkui.PehkuiUtil;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.TypedScaleModifier;

public class ApoliScaleModifier<P>
extends ScaleModifier {
    private static final float EPSILON = 1.0E-4f;
    protected final P power;
    protected class_1309 owner;
    protected final int powerPriority;
    protected final List<?> modifiers;
    protected final Map<class_2960, Float> cachedTargetScales = new HashMap<class_2960, Float>();
    protected final Map<class_2960, Float> cachedPreviousTargetScales = new HashMap<class_2960, Float>();
    protected final Map<class_2960, Float> checkScales = new HashMap<class_2960, Float>();
    protected final Set<class_2960> shouldUpdateModifiers = new HashSet<class_2960>();
    protected final Set<class_2960> shouldUpdatePreviousModifiers = new HashSet<class_2960>();
    protected final Set<class_2960> cachedScaleIds;
    private boolean addedScales = false;
    protected boolean shouldUpdate = false;
    protected boolean shouldUpdatePrevious = false;
    private boolean hasLoggedWarn = false;

    public ApoliScaleModifier(P power, class_1309 entity, List<?> modifiers, Set<class_2960> cachedScaleIds, int powerPriority) {
        super(Float.MIN_VALUE);
        this.power = power;
        this.owner = entity;
        this.modifiers = ImmutableList.copyOf(modifiers);
        this.cachedScaleIds = ImmutableSet.copyOf(cachedScaleIds);
        this.powerPriority = powerPriority;
    }

    public int compareTo(ScaleModifier o) {
        if (!(o instanceof ApoliScaleModifier)) {
            return Float.compare(o.getPriority(), this.getPriority());
        }
        ApoliScaleModifier ao = (ApoliScaleModifier)o;
        int c = Integer.compare(this.powerPriority, ao.powerPriority);
        int n = c = c != 0 ? c : Boolean.compare(this.doModifiersContainTypedOfAnother((class_1297)this.owner, ao), ao.doModifiersContainTypedOfAnother((class_1297)ao.owner, this));
        if (this.modifiers.isEmpty() || ao.modifiers.isEmpty()) {
            c = c != 0 ? c : Boolean.compare(this.modifiers.isEmpty(), ao.modifiers.isEmpty());
        }
        c = c != 0 ? c : Services.PLATFORM.compareModifiers(this.modifiers.stream().max(Services.PLATFORM::compareModifiers).get(), ao.modifiers.stream().max(Services.PLATFORM::compareModifiers).get());
        c = c != 0 ? c : this.getId().method_12833(ao.getId());
        return c;
    }

    public boolean doModifiersContainTypedOfAnother(class_1297 entity, ApoliScaleModifier<?> other) {
        return this.getCachedScaleIds().stream().map(PehkuiUtil::getScaleType).anyMatch(type -> type.getScaleData(entity).getBaseValueModifiers().stream().anyMatch(modifier -> {
            if (!(modifier instanceof TypedScaleModifier)) return false;
            TypedScaleModifier typedScaleModifier = (TypedScaleModifier)modifier;
            if (!other.getCachedScaleIds().contains(ScaleRegistries.getId((BiMap)ScaleRegistries.SCALE_TYPES, (Object)typedScaleModifier.getType()))) return false;
            return true;
        }));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ApoliScaleModifier)) {
            return false;
        }
        ApoliScaleModifier apoliScaleModifier = (ApoliScaleModifier)((Object)object);
        return this.getId().equals((Object)apoliScaleModifier.getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public Set<class_2960> getCachedScaleIds() {
        return this.cachedScaleIds;
    }

    protected class_2960 getResourceLocationFromScaleData(ScaleData data) {
        return ScaleRegistries.getId((BiMap)ScaleRegistries.SCALE_TYPES, (Object)data.getScaleType());
    }

    public class_2487 serialize(class_2487 tag) {
        class_2499 listTag;
        class_2487 entryTag;
        if (!this.cachedTargetScales.isEmpty()) {
            class_2499 cachedTargetScalesTag = new class_2499();
            for (Map.Entry<class_2960, Float> entry : this.cachedTargetScales.entrySet()) {
                entryTag = new class_2487();
                entryTag.method_10582("Type", entry.getKey().toString());
                entryTag.method_10548("Value", entry.getValue().floatValue());
                cachedTargetScalesTag.add((Object)entryTag);
            }
            tag.method_10566("TargetScales", (class_2520)cachedTargetScalesTag);
        }
        if (!this.cachedPreviousTargetScales.isEmpty()) {
            class_2499 cachedPreviousTargetScalesTag = new class_2499();
            for (Map.Entry<class_2960, Float> entry : this.cachedPreviousTargetScales.entrySet()) {
                entryTag = new class_2487();
                entryTag.method_10582("Type", entry.getKey().toString());
                entryTag.method_10548("Value", entry.getValue().floatValue());
                cachedPreviousTargetScalesTag.add((Object)entryTag);
            }
            tag.method_10566("PreviousTargetScales", (class_2520)cachedPreviousTargetScalesTag);
        }
        if (!this.checkScales.isEmpty()) {
            class_2499 checkScalesTag = new class_2499();
            for (Map.Entry<class_2960, Float> entry : this.checkScales.entrySet()) {
                entryTag = new class_2487();
                entryTag.method_10582("Type", entry.getKey().toString());
                entryTag.method_10548("Value", entry.getValue().floatValue());
                checkScalesTag.add((Object)entryTag);
            }
            tag.method_10566("CheckScales", (class_2520)checkScalesTag);
        }
        if (!this.shouldUpdateModifiers.isEmpty()) {
            listTag = new class_2499();
            for (class_2960 class_29602 : this.shouldUpdateModifiers) {
                listTag.add((Object)class_2519.method_23256((String)class_29602.toString()));
            }
            tag.method_10566("ShouldUpdateModifiers", (class_2520)listTag);
        }
        if (!this.shouldUpdatePreviousModifiers.isEmpty()) {
            listTag = new class_2499();
            for (class_2960 class_29603 : this.shouldUpdatePreviousModifiers) {
                listTag.add((Object)class_2519.method_23256((String)class_29603.toString()));
            }
            tag.method_10566("ShouldUpdatePreviousModifiers", (class_2520)listTag);
        }
        if (this.shouldUpdate) {
            tag.method_10556("ShouldUpdate", true);
        }
        if (this.shouldUpdatePrevious) {
            tag.method_10556("ShouldUpdatePrevious", true);
        }
        return tag;
    }

    public void deserialize(class_2487 tag, class_1309 entity) {
        this.addScales(entity);
        this.deserialize(tag, true);
        this.updateAllScales(entity);
    }

    public void deserialize(class_2487 tag, boolean initialize) {
        class_2499 listTag;
        class_2487 entryTag;
        int i;
        class_2499 cachedMaxScaleTag;
        this.cachedTargetScales.clear();
        if (tag.method_10573("TargetScales", 9)) {
            cachedMaxScaleTag = tag.method_10554("TargetScales", 10);
            for (i = 0; i < cachedMaxScaleTag.size(); ++i) {
                entryTag = cachedMaxScaleTag.method_10602(i);
                this.cachedTargetScales.put(new class_2960(entryTag.method_10558("Type")), Float.valueOf(entryTag.method_10583("Value")));
            }
        }
        this.cachedPreviousTargetScales.clear();
        if (tag.method_10573("PreviousTargetScales", 9)) {
            cachedMaxScaleTag = tag.method_10554("PreviousTargetScales", 10);
            for (i = 0; i < cachedMaxScaleTag.size(); ++i) {
                entryTag = cachedMaxScaleTag.method_10602(i);
                this.cachedPreviousTargetScales.put(new class_2960(entryTag.method_10558("Type")), Float.valueOf(entryTag.method_10583("Value")));
            }
        }
        this.checkScales.clear();
        if (tag.method_10573("CheckScales", 9)) {
            class_2499 checkScalesTag = tag.method_10554("CheckScales", 10);
            for (i = 0; i < checkScalesTag.size(); ++i) {
                entryTag = checkScalesTag.method_10602(i);
                this.cachedPreviousTargetScales.put(new class_2960(entryTag.method_10558("Type")), Float.valueOf(entryTag.method_10583("Value")));
            }
        }
        this.shouldUpdateModifiers.clear();
        if (tag.method_10573("ShouldUpdateModifiers", 9)) {
            listTag = tag.method_10554("ShouldUpdateModifiers", 8);
            for (i = 0; i < listTag.size(); ++i) {
                this.shouldUpdateModifiers.add(new class_2960(listTag.method_10608(i)));
            }
        }
        this.shouldUpdatePreviousModifiers.clear();
        if (tag.method_10573("ShouldUpdatePreviousModifiers", 9)) {
            listTag = tag.method_10554("ShouldUpdatePreviousModifiers", 8);
            for (i = 0; i < listTag.size(); ++i) {
                this.shouldUpdatePreviousModifiers.add(new class_2960(listTag.method_10608(i)));
            }
        }
        if (tag.method_10573("ShouldUpdate", 1)) {
            this.shouldUpdate = tag.method_10577("ShouldUpdate");
        }
        if (tag.method_10573("ShouldUpdatePrevious", 1)) {
            this.shouldUpdatePrevious = tag.method_10577("ShouldUpdatePrevious");
        }
    }

    protected void reset() {
        this.addedScales = false;
        this.hasLoggedWarn = false;
        this.shouldUpdate = false;
        this.shouldUpdatePrevious = false;
        this.cachedTargetScales.clear();
        this.cachedPreviousTargetScales.clear();
        this.checkScales.clear();
        this.shouldUpdateModifiers.clear();
        this.shouldUpdatePreviousModifiers.clear();
    }

    protected void addScales(class_1309 entity) {
        if (!this.addedScales) {
            ScaleType scaleType;
            for (class_2960 scaleTypeId : this.getCachedScaleIds()) {
                scaleType = (ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (class_2960)scaleTypeId);
                ScaleData scaleData = scaleType.getScaleData((class_1297)entity);
                ((ScaleDataAccess)scaleData).apugli$removeFromApoliScaleModifiers(this.getId());
                scaleData.getBaseValueModifiers().remove((Object)this);
                ((ScaleDataAccess)scaleData).apugli$addToApoliScaleModifiers(this.getId());
                scaleData.getBaseValueModifiers().add(this);
            }
            for (class_2960 scaleTypeId : this.getCachedScaleIds()) {
                scaleType = (ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (class_2960)scaleTypeId);
                this.updateScale(entity, scaleType);
            }
            if (!entity.method_37908().method_8608()) {
                Services.POWER.syncPower(entity, this.power);
            }
            this.addedScales = true;
        }
    }

    public void tick(class_1309 entity) {
        boolean sync = false;
        for (class_2960 typeId : this.getCachedScaleIds()) {
            float value;
            ScaleData data = ((ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (class_2960)typeId)).getScaleData((class_1297)entity);
            boolean isActive = Services.POWER.isActive(this.power, entity);
            float f = value = !isActive ? data.getBaseScale() : (float)Services.PLATFORM.applyModifiers(data.getEntity(), this.modifiers, (double)data.getBaseScale());
            if (ApoliScaleModifier.compareFloats(this.checkScales.getOrDefault(typeId, Float.valueOf(data.getBaseScale())).floatValue(), value)) continue;
            this.checkScales.put(typeId, Float.valueOf(value));
            this.markForUpdating(typeId, false);
            sync = true;
        }
        if (sync) {
            Services.POWER.syncPower(entity, this.power);
            this.updateOthers(entity);
        }
    }

    protected void markForUpdating(class_2960 typeId, boolean notOriginalCall) {
        this.shouldUpdateModifiers.add(typeId);
        this.shouldUpdatePreviousModifiers.add(typeId);
        this.shouldUpdate = true;
        this.shouldUpdatePrevious = true;
        if (notOriginalCall) {
            this.cachedTargetScales.clear();
            this.cachedPreviousTargetScales.clear();
        }
    }

    protected void updateIfShould(class_1309 entity) {
        if (this.shouldUpdate || this.shouldUpdatePrevious) {
            this.updateAllScales(entity);
            this.shouldUpdate = false;
            this.shouldUpdatePrevious = false;
        }
    }

    public void updateOthers(class_1309 entity) {
        SortedSet<ApoliScaleModifier> tailSet = PehkuiUtil.getModifiersInOrder(entity).tailSet(this);
        for (ApoliScaleModifier modifier : tailSet) {
            if (modifier.getId().equals((Object)this.getId())) continue;
            modifier.getCachedScaleIds().forEach(id -> modifier.markForUpdating((class_2960)id, true));
            Services.POWER.syncPower(entity, modifier.power);
        }
    }

    public void updateAllScales(class_1309 entity) {
        this.getCachedScaleIds().stream().map(PehkuiUtil::getScaleType).forEach(type -> this.updateScale(entity, (ScaleType)type));
    }

    public void updateScale(class_1309 entity, ScaleType type) {
        ScaleData data = type.getScaleData((class_1297)entity);
        data.onUpdate();
        if (this.shouldUpdate) {
            data.getScale();
        }
        if (this.shouldUpdatePrevious) {
            data.getPrevScale();
        }
    }

    public class_2960 getId() {
        return ApugliPowers.MODIFY_SCALE.get().getPowerId(this.power);
    }

    public class_2960 getPowerId() {
        return ApugliPowers.MODIFY_SCALE.get().getPowerId(this.power);
    }

    public float modifyScale(ScaleData scaleData, float modifiedScale, float delta) {
        class_1297 class_12972 = scaleData.getEntity();
        if (!(class_12972 instanceof class_1309)) {
            this.logWarn();
            return modifiedScale;
        }
        class_1309 entity = (class_1309)class_12972;
        class_2960 id = this.getResourceLocationFromScaleData(scaleData);
        if (!Services.POWER.isActive(this.power, entity)) {
            return modifiedScale;
        }
        if (this.shouldUpdateModifiers.contains(id)) {
            this.cachedTargetScales.put(id, Float.valueOf((float)Services.PLATFORM.applyModifiers(scaleData.getEntity(), this.modifiers, (double)modifiedScale)));
        }
        return this.cachedTargetScales.getOrDefault(id, Float.valueOf(modifiedScale)).floatValue();
    }

    public float modifyPrevScale(ScaleData scaleData, float modifiedScale) {
        class_1297 class_12972 = scaleData.getEntity();
        if (!(class_12972 instanceof class_1309)) {
            this.logWarn();
            return modifiedScale;
        }
        class_1309 entity = (class_1309)class_12972;
        class_2960 id = this.getResourceLocationFromScaleData(scaleData);
        if (!Services.POWER.isActive(this.power, entity)) {
            return modifiedScale;
        }
        if (this.shouldUpdatePreviousModifiers.contains(id)) {
            this.cachedPreviousTargetScales.put(id, Float.valueOf((float)Services.PLATFORM.applyModifiers((class_1297)entity, this.modifiers, (double)modifiedScale)));
        }
        return this.cachedPreviousTargetScales.getOrDefault(id, Float.valueOf(modifiedScale)).floatValue();
    }

    protected static boolean compareFloats(float a, float b) {
        float diff = class_3532.method_15379((float)(a - b));
        return diff < 1.0E-4f;
    }

    protected void logWarn() {
        if (!this.hasLoggedWarn) {
            Apugli.LOG.warn("Attempted to use ApoliScaleModifier on a non-living entity. This should not be possible.");
        }
        this.hasLoggedWarn = true;
    }
}

