/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.integration.pehkui;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.integration.pehkui.ApoliScaleModifier;
import net.merchantpug.apugli.integration.pehkui.PehkuiUtil;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.joml.Math;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;

public class DelayedApoliScaleModifier<P>
extends ApoliScaleModifier<P> {
    private int ticks;
    private final int baseMaxTicks;
    private int maxTicks;
    protected final List<?> delayModifiers;
    private Map<class_2960, Double> previousResourceValues = new HashMap<class_2960, Double>();
    private Map<Integer, Map<class_2960, Double>> inBetweenResourceValues = new HashMap<Integer, Map<class_2960, Double>>();
    private Map<class_2960, Double> targetResourceValues = new HashMap<class_2960, Double>();
    protected final Optional<class_2960> easing;
    protected final Map<class_2960, Float> cachedPreviousScales = new HashMap<class_2960, Float>();
    protected final Map<class_2960, Float> cachedPreviousPreviousScales = new HashMap<class_2960, Float>();
    private final Map<class_2960, Map<Integer, Map<Float, Float>>> reachedScales = new HashMap<class_2960, Map<Integer, Map<Float, Float>>>();
    private final Map<class_2960, Map<Integer, Float>> reachedPreviousScales = new HashMap<class_2960, Map<Integer, Float>>();
    private final class_2960 tickUpdateScaleTypeId;
    private float tickUpdatePrevious;
    private float tickUpdateTarget;

    public DelayedApoliScaleModifier(P power, class_1309 entity, List<?> modifiers, List<?> delayModifiers, int maxTicks, Set<class_2960> cachedScaleIds, int powerPriority, Optional<class_2960> easing) {
        super(power, entity, modifiers, cachedScaleIds, powerPriority);
        this.delayModifiers = ImmutableList.copyOf(delayModifiers);
        this.baseMaxTicks = (int)Services.PLATFORM.applyModifiers((class_1297)this.owner, this.delayModifiers, (double)maxTicks);
        this.ticks = 0;
        this.maxTicks = maxTicks;
        this.easing = easing;
        this.tickUpdateScaleTypeId = (class_2960)this.getCachedScaleIds().stream().findFirst().orElseThrow();
        if (entity != null) {
            this.tickUpdateTarget = !Services.POWER.isActive(this.power, entity) ? PehkuiUtil.getScaleType(this.tickUpdateScaleTypeId).getScaleData((class_1297)entity).getBaseScale() : (float)Services.PLATFORM.applyModifiers((class_1297)entity, this.modifiers, (double)PehkuiUtil.getScaleType(this.tickUpdateScaleTypeId).getScaleData((class_1297)entity).getBaseScale());
            this.tickUpdatePrevious = PehkuiUtil.getScaleType(this.tickUpdateScaleTypeId).getScaleData((class_1297)entity).getBaseScale();
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public int getClampedTicks() {
        return class_3532.method_15340((int)this.ticks, (int)0, (int)this.getMaxTicks());
    }

    public void setTicks(int value) {
        this.ticks = class_3532.method_15340((int)value, (int)0, (int)this.getMaxTicks());
    }

    protected boolean isMax() {
        return this.ticks >= this.getMaxTicks();
    }

    protected boolean isMin() {
        return this.ticks <= 0;
    }

    @Override
    public class_2487 serialize(class_2487 tag) {
        class_2499 previousResourceValuesTag;
        class_2487 entryTag;
        tag.method_10569("MaxTicks", this.getMaxTicks());
        tag.method_10569("Ticks", this.getClampedTicks());
        super.serialize(tag);
        if (!this.cachedPreviousScales.isEmpty()) {
            class_2499 cachedPreviousScalesTag = new class_2499();
            for (Map.Entry<class_2960, Float> entry : this.cachedPreviousScales.entrySet()) {
                entryTag = new class_2487();
                entryTag.method_10582("Type", entry.getKey().toString());
                entryTag.method_10548("Value", entry.getValue().floatValue());
                cachedPreviousScalesTag.add((Object)entryTag);
            }
            tag.method_10566("PreviousScales", (class_2520)cachedPreviousScalesTag);
        }
        if (!this.cachedPreviousPreviousScales.isEmpty()) {
            class_2499 cachedPreviousPreviousScalesTag = new class_2499();
            for (Map.Entry<class_2960, Float> entry : this.cachedPreviousPreviousScales.entrySet()) {
                entryTag = new class_2487();
                entryTag.method_10582("Type", entry.getKey().toString());
                entryTag.method_10548("Value", entry.getValue().floatValue());
                cachedPreviousPreviousScalesTag.add((Object)entryTag);
            }
            tag.method_10566("PreviousPreviousScales", (class_2520)cachedPreviousPreviousScalesTag);
        }
        if (!this.targetResourceValues.isEmpty()) {
            class_2499 targetResourceValuesTag = new class_2499();
            for (Map.Entry<class_2960, Number> entry : this.targetResourceValues.entrySet()) {
                entryTag = new class_2487();
                entryTag.method_10582("Resource", entry.getKey().toString());
                entryTag.method_10549("Value", ((Double)entry.getValue()).doubleValue());
                targetResourceValuesTag.add((Object)entryTag);
            }
            tag.method_10566("TargetResourceValues", (class_2520)targetResourceValuesTag);
        }
        if (!this.previousResourceValues.isEmpty()) {
            previousResourceValuesTag = new class_2499();
            for (Map.Entry<class_2960, Number> entry : this.previousResourceValues.entrySet()) {
                entryTag = new class_2487();
                entryTag.method_10582("Resource", entry.getKey().toString());
                entryTag.method_10549("Value", ((Double)entry.getValue()).doubleValue());
                previousResourceValuesTag.add((Object)entryTag);
            }
            tag.method_10566("PreviousResourceValues", (class_2520)previousResourceValuesTag);
        }
        if (!this.inBetweenResourceValues.isEmpty()) {
            previousResourceValuesTag = new class_2499();
            for (Map.Entry<Object, Object> entry : this.inBetweenResourceValues.entrySet()) {
                if (((Map)entry.getValue()).isEmpty()) continue;
                entryTag = new class_2487();
                class_2499 valuesTag = new class_2499();
                for (Map.Entry innerEntry : ((Map)entry.getValue()).entrySet()) {
                    class_2487 innerEntryTag = new class_2487();
                    innerEntryTag.method_10582("Resource", ((class_2960)innerEntry.getKey()).toString());
                    innerEntryTag.method_10549("Value", ((Double)innerEntry.getValue()).doubleValue());
                    valuesTag.add((Object)innerEntryTag);
                }
                entryTag.method_10582("Ticks", ((Integer)entry.getKey()).toString());
                entryTag.method_10566("Values", (class_2520)valuesTag);
                previousResourceValuesTag.add((Object)entryTag);
            }
            tag.method_10566("InBetweenResourceValues", (class_2520)previousResourceValuesTag);
        }
        return tag;
    }

    @Override
    public void deserialize(class_2487 tag, boolean initialize) {
        class_2487 entryTag;
        int i;
        class_2499 listTag;
        this.maxTicks = tag.method_10550("MaxTicks");
        this.setTicks(tag.method_10550("Ticks"));
        super.deserialize(tag, false);
        this.cachedPreviousScales.clear();
        if (tag.method_10573("PreviousScales", 9)) {
            listTag = tag.method_10554("PreviousScales", 10);
            for (i = 0; i < listTag.size(); ++i) {
                entryTag = listTag.method_10602(i);
                this.cachedPreviousScales.put(new class_2960(entryTag.method_10558("Type")), Float.valueOf(entryTag.method_10583("Value")));
            }
        }
        this.cachedPreviousPreviousScales.clear();
        if (tag.method_10573("PreviousPreviousScales", 9)) {
            listTag = tag.method_10554("PreviousPreviousScales", 10);
            for (i = 0; i < listTag.size(); ++i) {
                entryTag = listTag.method_10602(i);
                this.cachedPreviousPreviousScales.put(new class_2960(entryTag.method_10558("Type")), Float.valueOf(entryTag.method_10583("Value")));
            }
        }
        this.targetResourceValues.clear();
        if (tag.method_10573("TargetResourceValues", 9)) {
            listTag = tag.method_10554("TargetResourceValues", 10);
            for (i = 0; i < listTag.size(); ++i) {
                entryTag = listTag.method_10602(i);
                this.targetResourceValues.put(new class_2960(entryTag.method_10558("Resource")), entryTag.method_10574("Value"));
            }
        }
        this.previousResourceValues.clear();
        if (tag.method_10573("PreviousResourceValues", 9)) {
            listTag = tag.method_10554("PreviousResourceValues", 10);
            for (i = 0; i < listTag.size(); ++i) {
                entryTag = listTag.method_10602(i);
                this.previousResourceValues.put(new class_2960(entryTag.method_10558("Resource")), entryTag.method_10574("Value"));
            }
        }
        this.inBetweenResourceValues.clear();
        if (tag.method_10573("InBetweenResourceValues", 9)) {
            listTag = tag.method_10554("InBetweenResourceValues", 10);
            for (i = 0; i < listTag.size(); ++i) {
                entryTag = listTag.method_10602(i);
                HashMap<class_2960, Double> values = new HashMap<class_2960, Double>();
                class_2499 valuesTag = entryTag.method_10554("Values", 10);
                for (int j = 0; j < valuesTag.size(); ++j) {
                    class_2487 innerTag = listTag.method_10602(j);
                    values.put(new class_2960(entryTag.method_10558("Resource")), entryTag.method_10574("Value"));
                }
                this.inBetweenResourceValues.put(entryTag.method_10550("Ticks"), values);
            }
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.cachedPreviousScales.clear();
        this.cachedPreviousPreviousScales.clear();
        this.reachedScales.clear();
        this.reachedPreviousScales.clear();
        this.targetResourceValues.clear();
        this.previousResourceValues.clear();
        this.inBetweenResourceValues.clear();
    }

    @Override
    public void tick(class_1309 entity) {
        boolean updateMaxTicks = false;
        boolean isActive = Services.POWER.isActive(this.power, entity);
        for (class_2960 typeId : this.cachedScaleIds) {
            float value;
            ScaleData data = ((ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (class_2960)typeId)).getScaleData((class_1297)entity);
            float f = value = !isActive ? data.getBaseScale() : (float)Services.PLATFORM.applyModifiers((class_1297)entity, this.modifiers, (double)data.getBaseScale());
            if (DelayedApoliScaleModifier.compareFloats(this.checkScales.getOrDefault(typeId, Float.valueOf(data.getBaseScale())).floatValue(), value)) continue;
            updateMaxTicks = true;
            this.checkScales.put(typeId, Float.valueOf(value));
            this.markForUpdating(typeId, false);
        }
        if (updateMaxTicks) {
            Map<Object, Double> newPrevious = this.targetResourceValues.isEmpty() ? Services.POWER.getClosestToBaseScale(entity, this.modifiers, 1.0) : (this.ticks == this.maxTicks ? this.targetResourceValues : (Map<Object, Double>)this.inBetweenResourceValues.entrySet().stream().filter(entry -> (Integer)entry.getKey() < this.ticks).max(Comparator.comparing(entry -> class_3532.method_15382((int)((Integer)entry.getKey() - this.ticks)))).map(Map.Entry::getValue).orElse(new HashMap()));
            this.targetResourceValues = Services.POWER.iterateThroughModifierForResources(entity, this.modifiers);
            this.inBetweenResourceValues = Services.POWER.getInBetweenResources(entity, this.modifiers, this.delayModifiers, this.baseMaxTicks, this.previousResourceValues);
            this.previousResourceValues = newPrevious;
            this.maxTicks = (int)Services.POWER.addAllInBetweensOfResourceModifiers(entity, this.modifiers, this.delayModifiers, this.baseMaxTicks, this.previousResourceValues);
            ScaleData data = PehkuiUtil.getScaleType(this.tickUpdateScaleTypeId).getScaleData((class_1297)entity);
            float currentScale = this.isMin() ? this.tickUpdatePrevious : (this.isMax() ? this.tickUpdateTarget : this.calculateScale(data, this.tickUpdateScaleTypeId, 1.0f, this.tickUpdateTarget, this.tickUpdatePrevious));
            this.tickUpdatePrevious = this.tickUpdateTarget;
            this.tickUpdateTarget = !isActive ? data.getBaseScale() : (float)Services.PLATFORM.applyModifiers((class_1297)entity, this.modifiers, (double)data.getBaseScale());
            float slope = (float)this.getMaxTicks() / (this.tickUpdateTarget - this.tickUpdatePrevious);
            this.setTicks(Math.round((float)(slope * (currentScale - this.tickUpdatePrevious))));
            this.shouldUpdate = true;
            this.shouldUpdatePrevious = true;
            Services.POWER.syncPower(entity, this.power);
            this.updateOthers(entity);
            return;
        }
        int modifiedDelay = (int)Services.POWER.addAllInBetweensOfResourceModifiers(entity, this.modifiers, this.delayModifiers, this.baseMaxTicks, this.previousResourceValues);
        if (this.maxTicks != modifiedDelay) {
            int inbetween = modifiedDelay - this.maxTicks;
            this.ticks += inbetween;
            this.maxTicks += inbetween;
            Services.POWER.syncPower(entity, this.power);
        }
        if (this.getClampedTicks() < this.getMaxTicks()) {
            this.setTicks(this.getClampedTicks() + 1);
            this.shouldUpdate = true;
            this.shouldUpdatePrevious = true;
            Services.POWER.syncPower(entity, this.power);
            this.updateOthers(entity);
        }
    }

    @Override
    protected void markForUpdating(class_2960 typeId, boolean notOriginalCall) {
        super.markForUpdating(typeId, notOriginalCall);
        if (notOriginalCall) {
            this.cachedPreviousScales.clear();
            this.cachedPreviousPreviousScales.clear();
        }
    }

    @Override
    public float modifyScale(ScaleData scaleData, float modifiedScale, float delta) {
        class_1297 class_12972 = scaleData.getEntity();
        if (!(class_12972 instanceof class_1309)) {
            this.logWarn();
            return modifiedScale;
        }
        class_1309 entity = (class_1309)class_12972;
        class_2960 scaleTypeId = this.getResourceLocationFromScaleData(scaleData);
        boolean isActive = Services.POWER.isActive(this.power, entity);
        if (this.shouldUpdateModifiers.contains(scaleTypeId)) {
            float target = !isActive ? modifiedScale : (float)Services.PLATFORM.applyModifiers((class_1297)entity, this.modifiers, (double)modifiedScale);
            float previous = this.cachedTargetScales.getOrDefault(scaleTypeId, Float.valueOf(modifiedScale)).floatValue();
            this.cachedTargetScales.put(scaleTypeId, Float.valueOf(target));
            this.cachedPreviousScales.put(scaleTypeId, Float.valueOf(previous));
            this.shouldUpdateModifiers.remove(scaleTypeId);
            this.reachedScales.remove(scaleTypeId);
        }
        if (!this.cachedTargetScales.containsKey(scaleTypeId) || !this.cachedPreviousScales.containsKey(scaleTypeId)) {
            return modifiedScale;
        }
        if (this.isMax()) {
            this.reachedScales.remove(scaleTypeId);
            return ((Float)this.cachedTargetScales.get(scaleTypeId)).floatValue();
        }
        if (this.isMin()) {
            return this.cachedPreviousScales.get(scaleTypeId).floatValue();
        }
        if (this.reachedScales.containsKey(scaleTypeId) && this.reachedScales.get(scaleTypeId).containsKey(this.ticks) && this.reachedScales.get(scaleTypeId).get(this.ticks).keySet().stream().anyMatch(aFloat -> DelayedApoliScaleModifier.compareFloats(aFloat.floatValue(), 1.0f))) {
            return ((Float)this.reachedScales.get(scaleTypeId).get(this.ticks).entrySet().stream().filter(entry -> DelayedApoliScaleModifier.compareFloats(((Float)entry.getKey()).floatValue(), 1.0f)).findFirst().get().getValue()).floatValue();
        }
        if (this.reachedScales.containsKey(scaleTypeId) && this.reachedScales.get(scaleTypeId).containsKey(this.ticks) && this.reachedScales.get(scaleTypeId).get(this.ticks).keySet().stream().anyMatch(aFloat -> DelayedApoliScaleModifier.compareFloats(aFloat.floatValue(), delta))) {
            return ((Float)this.reachedScales.get(scaleTypeId).get(this.ticks).entrySet().stream().filter(entry -> DelayedApoliScaleModifier.compareFloats(((Float)entry.getKey()).floatValue(), delta)).findFirst().get().getValue()).floatValue();
        }
        return this.calculateScale(scaleData, scaleTypeId, delta, ((Float)this.cachedTargetScales.get(scaleTypeId)).floatValue(), this.cachedPreviousScales.get(scaleTypeId).floatValue());
    }

    private float calculateScale(ScaleData scaleData, class_2960 scaleTypeId, float delta, float targetScale, float previousScale) {
        Float2FloatFunction easing = this.easing.map(location -> {
            if (ScaleRegistries.SCALE_EASINGS.containsKey(location)) {
                return (Float2FloatFunction)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_EASINGS, (class_2960)location);
            }
            Apugli.LOG.error("'easing' value '{}' for power '{}' is not a valid scale easing.", location, (Object)Services.POWER.getPowerId(this.power));
            return null;
        }).orElse(Optional.ofNullable(scaleData.getEasing()).orElseGet(() -> ((ScaleType)scaleData.getScaleType()).getDefaultEasing()));
        float progress = (float)this.getClampedTicks() + delta;
        int total = this.getMaxTicks();
        float range = targetScale - previousScale;
        float perTick = total == 0 ? 1.0f : ((Float)easing.apply((Object)Float.valueOf(progress / (float)total))).floatValue();
        float modified = previousScale + perTick * range;
        this.populateDeltaReachedScale(scaleTypeId, this.getClampedTicks(), delta, modified);
        return modified;
    }

    private void populateDeltaReachedScale(class_2960 scaleTypeId, int ticks, float delta, float modified) {
        if (!this.reachedScales.containsKey(scaleTypeId)) {
            this.reachedScales.put(scaleTypeId, new HashMap());
        }
        if (!this.reachedScales.get(scaleTypeId).containsKey(ticks)) {
            this.reachedScales.get(scaleTypeId).put(ticks, new HashMap());
        }
        if (this.reachedScales.containsKey(scaleTypeId) && ((Map)this.reachedScales.getOrDefault(scaleTypeId, new HashMap())).containsKey(ticks)) {
            this.reachedScales.get(scaleTypeId).get(ticks).put(Float.valueOf(delta), Float.valueOf(modified));
        }
    }

    @Override
    public float modifyPrevScale(ScaleData scaleData, float modifiedScale) {
        class_1297 class_12972 = scaleData.getEntity();
        if (!(class_12972 instanceof class_1309)) {
            this.logWarn();
            return modifiedScale;
        }
        class_1309 entity = (class_1309)class_12972;
        class_2960 scaleTypeId = this.getResourceLocationFromScaleData(scaleData);
        boolean isActive = Services.POWER.isActive(this.power, entity);
        if (this.shouldUpdatePreviousModifiers.contains(scaleTypeId)) {
            float target = !isActive ? modifiedScale : (float)Services.PLATFORM.applyModifiers((class_1297)entity, this.modifiers, (double)modifiedScale);
            float previous = this.cachedPreviousTargetScales.getOrDefault(scaleTypeId, Float.valueOf(modifiedScale)).floatValue();
            this.cachedPreviousTargetScales.put(scaleTypeId, Float.valueOf(target));
            this.cachedPreviousPreviousScales.put(scaleTypeId, Float.valueOf(previous));
            this.shouldUpdatePreviousModifiers.remove(scaleTypeId);
            this.reachedPreviousScales.remove(scaleTypeId);
        }
        if (!this.cachedPreviousTargetScales.containsKey(scaleTypeId) || !this.cachedPreviousPreviousScales.containsKey(scaleTypeId)) {
            return modifiedScale;
        }
        if (this.isMax()) {
            return ((Float)this.cachedPreviousTargetScales.get(scaleTypeId)).floatValue();
        }
        if (this.isMin()) {
            return this.cachedPreviousPreviousScales.get(scaleTypeId).floatValue();
        }
        if (this.reachedPreviousScales.containsKey(scaleTypeId) && ((Map)this.reachedPreviousScales.getOrDefault(scaleTypeId, new HashMap())).containsKey(this.ticks)) {
            return this.reachedPreviousScales.get(scaleTypeId).get(this.ticks).floatValue();
        }
        return this.calculatePreviousScale(scaleTypeId);
    }

    private float calculatePreviousScale(class_2960 scaleTypeId) {
        float targetScale = ((Float)this.cachedPreviousTargetScales.get(scaleTypeId)).floatValue();
        float previousScale = this.cachedPreviousPreviousScales.get(scaleTypeId).floatValue();
        float modified = class_3532.method_16439((float)((float)this.getClampedTicks() / (float)this.getMaxTicks()), (float)previousScale, (float)targetScale);
        this.populateReachedPreviousScale(scaleTypeId, this.ticks, modified);
        return modified;
    }

    private void populateReachedPreviousScale(class_2960 scaleTypeId, int ticks, float modified) {
        if (!this.reachedPreviousScales.containsKey(scaleTypeId)) {
            this.reachedPreviousScales.put(scaleTypeId, new HashMap());
        }
        if (this.reachedPreviousScales.containsKey(scaleTypeId)) {
            this.reachedPreviousScales.get(scaleTypeId).put(ticks, Float.valueOf(modified));
        }
    }
}

