/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.integration.pehkui;

import com.google.common.collect.ImmutableSet;
import io.github.apace100.calio.data.SerializableData;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.access.ScaleDataAccess;
import net.merchantpug.apugli.integration.pehkui.ApoliScaleModifier;
import net.merchantpug.apugli.integration.pehkui.DelayedApoliScaleModifier;
import net.merchantpug.apugli.network.s2c.integration.pehkui.SyncScalePacket;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;

public class PehkuiUtil {
    private static final Map<UUID, SortedSet<ApoliScaleModifier<?>>> MODIFIERS_IN_ORDER = new HashMap();

    private static void createModifiersInOrder(class_1309 entity, ApoliScaleModifier<?> modifier, boolean remove) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        if (!MODIFIERS_IN_ORDER.containsKey(entity.method_5667())) {
            MODIFIERS_IN_ORDER.put(entity.method_5667(), (SortedSet<ApoliScaleModifier<?>>)new ObjectAVLTreeSet());
        }
        if (!remove) {
            MODIFIERS_IN_ORDER.get(entity.method_5667()).add(modifier);
        } else {
            MODIFIERS_IN_ORDER.get(entity.method_5667()).remove(modifier);
            if (MODIFIERS_IN_ORDER.get(entity.method_5667()).isEmpty()) {
                MODIFIERS_IN_ORDER.remove(entity.method_5667());
            }
        }
    }

    public static SortedSet<ApoliScaleModifier<?>> getModifiersInOrder(class_1309 entity) {
        if (!MODIFIERS_IN_ORDER.containsKey(entity.method_5667())) {
            return new ObjectAVLTreeSet();
        }
        return MODIFIERS_IN_ORDER.get(entity.method_5667());
    }

    public static Set<class_2960> getTypesFromCache(SerializableData.Instance data) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        data.ifPresent("scale_type", id -> {
            if (PehkuiUtil.validate(id)) {
                builder.add(id);
            }
        });
        data.ifPresent("scale_types", ids -> ids.forEach(id -> {
            if (PehkuiUtil.validate(id)) {
                builder.add(id);
            }
        }));
        return builder.build();
    }

    private static boolean validate(class_2960 typeId) {
        boolean value = ScaleRegistries.SCALE_TYPES.containsKey((Object)typeId);
        if (!value) {
            Apugli.LOG.error("Identifier '{}' is not a valid scale type.", (Object)typeId);
        }
        return value;
    }

    public static ScaleType getScaleType(class_2960 id) {
        return (ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (class_2960)id);
    }

    public static void tickScalePowers(class_1309 entity) {
        if (!MODIFIERS_IN_ORDER.containsKey(entity.method_5667()) || MODIFIERS_IN_ORDER.get(entity.method_5667()).isEmpty() || MODIFIERS_IN_ORDER.get(entity.method_5667()).size() != Services.POWER.getPowers(entity, ApugliPowers.MODIFY_SCALE.get(), true).size()) {
            return;
        }
        for (ApoliScaleModifier apoliScaleModifier : MODIFIERS_IN_ORDER.get(entity.method_5667())) {
            if (!entity.method_37908().method_8608()) {
                apoliScaleModifier.addScales(entity);
                apoliScaleModifier.tick(entity);
            }
            apoliScaleModifier.updateIfShould(entity);
        }
    }

    public static <P> void onAddedOrRespawnedScalePower(P power, class_1309 entity) {
        Object object = ApugliPowers.MODIFY_SCALE.get().getApoliScaleModifier(power, (class_1297)entity);
        if (!(object instanceof ApoliScaleModifier)) {
            return;
        }
        ApoliScaleModifier scaleModifier = (ApoliScaleModifier)((Object)object);
        if (entity != null) {
            PehkuiUtil.createModifiersInOrder(entity, scaleModifier, false);
            scaleModifier.updateOthers(entity);
        }
    }

    public static <P> Object createApoliScaleModifier(P power, class_1309 entity, SerializableData.Instance data) {
        if (!data.isPresent("modifier") && !data.isPresent("modifiers")) {
            Apugli.LOG.error("Could not create scale power modifier as the 'modifier' and 'modifiers' fields are both not specified.");
            return new ApoliScaleModifier<P>(power, entity, List.of(), Set.of(), 0);
        }
        ApoliScaleModifier modifier = data.getInt("delay") > 0 ? new DelayedApoliScaleModifier<P>(power, entity, ApugliPowers.MODIFY_SCALE.get().getModifiers(power, (class_1297)entity), ApugliPowers.MODIFY_SCALE.get().getDelayModifiers(power, (class_1297)entity), data.getInt("delay"), PehkuiUtil.getTypesFromCache(data), data.getInt("priority"), Optional.ofNullable((class_2960)data.get("easing"))) : new ApoliScaleModifier(power, entity, ApugliPowers.MODIFY_SCALE.get().getModifiers(power, (class_1297)entity), PehkuiUtil.getTypesFromCache(data), data.getInt("priority"));
        return modifier;
    }

    public static <P> void onRemovedScalePower(P power, class_1309 entity) {
        ApoliScaleModifier modifier = (ApoliScaleModifier)((Object)ApugliPowers.MODIFY_SCALE.get().getApoliScaleModifier(power, (class_1297)entity));
        PehkuiUtil.removeModifierFromOrderList(entity, modifier);
        for (class_2960 scaleTypeId : modifier.getCachedScaleIds()) {
            ScaleType scaleType = PehkuiUtil.getScaleType(scaleTypeId);
            ScaleData scaleData = scaleType.getScaleData((class_1297)entity);
            modifier.updateOthers(entity);
            ((ScaleDataAccess)scaleData).apugli$removeFromApoliScaleModifiers(ApugliPowers.MODIFY_SCALE.get().getPowerId(power));
            scaleData.getBaseValueModifiers().remove((Object)modifier);
            scaleData.onUpdate();
        }
        Services.PLATFORM.sendS2CTrackingAndSelf(SyncScalePacket.removeScaleFromClient(entity.method_5628(), modifier.getCachedScaleIds().stream().toList(), ApugliPowers.MODIFY_SCALE.get().getPowerId(power)), (class_1297)entity);
    }

    public static void resetScalePower(Object modifier) {
        if (!(modifier instanceof ApoliScaleModifier)) {
            return;
        }
        ApoliScaleModifier apoliScaleModifier = (ApoliScaleModifier)((Object)modifier);
        apoliScaleModifier.reset();
    }

    public static void removeModifierFromOrderList(class_1309 entity, ApoliScaleModifier<?> modifier) {
        PehkuiUtil.createModifiersInOrder(entity, modifier, true);
    }

    public static <P> class_2487 serializeScalePower(P power, class_1309 entity, class_2487 tag) {
        ApoliScaleModifier modifier = (ApoliScaleModifier)((Object)ApugliPowers.MODIFY_SCALE.get().getApoliScaleModifier(power, (class_1297)entity));
        return modifier.serialize(tag);
    }

    public static <P> void deserializeScalePower(P power, class_1309 entity, class_2487 tag) {
        ApoliScaleModifier modifier = (ApoliScaleModifier)((Object)ApugliPowers.MODIFY_SCALE.get().getApoliScaleModifier(power, (class_1297)entity));
        modifier.deserialize(tag, entity);
    }

    public static float getScale(class_1297 entity, class_2960 scaleTypeId) {
        return ((ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (class_2960)scaleTypeId)).getScaleData(entity).getScale();
    }
}

