/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.mixin.fabric.common;

import com.mojang.datafixers.util.Pair;
import io.github.apace100.apoli.util.InventoryUtil;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.merchantpug.apugli.access.ItemStackAccess;
import net.merchantpug.apugli.component.ApugliEntityComponents;
import net.merchantpug.apugli.component.HitsOnTargetComponent;
import net.merchantpug.apugli.integration.pehkui.PehkuiUtil;
import net.merchantpug.apugli.network.ApugliPackets;
import net.merchantpug.apugli.network.s2c.SyncHitsOnTargetLessenedPacket;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.ActionOnJumpPower;
import net.merchantpug.apugli.power.EdibleItemPower;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Shadow
    @Final
    public static int field_30074;
    @Unique
    private float apugli$damageAmountOnDeath;
    @Unique
    private boolean apugli$hasModifiedDamage;

    @Shadow
    public abstract class_3414 method_18869(class_1799 var1);

    @Shadow
    public abstract boolean method_6092(class_1293 var1);

    @Shadow
    @Nullable
    public abstract class_1309 method_6124();

    @Shadow
    public abstract boolean method_29504();

    @Shadow
    public abstract class_1310 method_6046();

    @Shadow
    public abstract void method_5697(class_1297 var1);

    public LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="TAIL")})
    private void apugli$handleGroundJump(CallbackInfo ci) {
        Services.POWER.getPowers((class_1309)this, ApugliPowers.ACTION_ON_JUMP.get()).forEach(ActionOnJumpPower::executeAction);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void apugli$setItemStackEntities(CallbackInfo ci) {
        Services.POWER.getPowers((class_1309)this, ApugliPowers.MODIFY_ENCHANTMENT_LEVEL.get()).forEach(p -> ApugliPowers.MODIFY_ENCHANTMENT_LEVEL.get().tick(p, (class_1297)((class_1309)this)));
        if (!FabricLoader.getInstance().isModLoaded("pehkui") || Services.POWER.getPowers((class_1309)this, ApugliPowers.MODIFY_SCALE.get(), true).isEmpty()) {
            return;
        }
        PehkuiUtil.tickScalePowers((class_1309)this);
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN")})
    private void apugli$runDamageFunctions(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 class_12972;
        class_1321 tamable;
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        class_1309 thisAsLiving = (class_1309)this;
        if (thisAsLiving.method_6065() != null) {
            ApugliPowers.ACTION_ON_ATTACKER_HURT.get().execute(thisAsLiving, source, amount);
            ApugliPowers.ACTION_ON_TARGET_HURT.get().execute(thisAsLiving, source, amount);
        }
        if (source.method_5529() == null) {
            return;
        }
        if (thisAsLiving instanceof class_1321) {
            tamable = (class_1321)thisAsLiving;
            ApugliPowers.ACTION_WHEN_TAME_HIT.get().execute(tamable, source, amount);
        }
        if ((class_12972 = source.method_5529()) instanceof class_1321) {
            tamable = (class_1321)class_12972;
            ApugliPowers.ACTION_ON_TAME_HIT.get().execute(tamable, source, amount, thisAsLiving);
        }
        HitsOnTargetComponent hitsComponent = (HitsOnTargetComponent)ApugliEntityComponents.HITS_ON_TARGET_COMPONENT.get((Object)thisAsLiving);
        hitsComponent.setHits(source.method_5529().method_5628(), (Integer)hitsComponent.getHits().getOrDefault(source.method_5529().method_5628(), (class_3545<Integer, Integer>)new class_3545((Object)0, (Object)0)).method_15442() + 1, 0);
        if (!(thisAsLiving instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)thisAsLiving;
        ApugliPackets.sendS2CTrackingAndSelf(new SyncHitsOnTargetLessenedPacket(source.method_5529().method_5628(), hitsComponent.getPreviousHits(), hitsComponent.getHits()), serverPlayer);
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;die(Lnet/minecraft/world/damagesource/DamageSource;)V")})
    private void apugli$captureDamageAmount(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.apugli$damageAmountOnDeath = amount;
    }

    @Inject(method={"die"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/DamageSource;getEntity()Lnet/minecraft/world/entity/Entity;")})
    private void apugli$runActionsOnTargetDeath(class_1282 source, CallbackInfo ci) {
        if (this.method_37908().field_9236) {
            return;
        }
        if (source.method_5529() != null && !source.method_5529().equals((Object)this.method_6124()) && this.method_6124() != null) {
            ApugliPowers.ACTION_ON_TARGET_DEATH.get().onTargetDeath(this.method_6124(), (class_1297)((class_1309)this), source, this.apugli$damageAmountOnDeath, true);
            return;
        }
        class_1297 class_12972 = source.method_5529();
        if (!(class_12972 instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309)class_12972;
        ApugliPowers.ACTION_ON_TARGET_DEATH.get().onTargetDeath(living, (class_1297)((class_1309)this), source, this.apugli$damageAmountOnDeath, false);
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), argsOnly=true)
    private float apugli$modifyDamageBasedOnEnchantment(float originalValue, class_1282 source, float amount) {
        float enchantmentDamageBonus;
        class_1309 attacker;
        float additionalValue = 0.0f;
        class_1309 thisAsLiving = (class_1309)this;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309) {
            attacker = (class_1309)class_12972;
            if (source.method_5526() == attacker) {
                additionalValue += ApugliPowers.MODIFY_ENCHANTMENT_DAMAGE_DEALT.get().applyModifiers(attacker, source, amount, thisAsLiving);
            }
        }
        if ((class_12972 = source.method_5529()) instanceof class_1309) {
            attacker = (class_1309)class_12972;
            additionalValue += ApugliPowers.MODIFY_ENCHANTMENT_DAMAGE_TAKEN.get().applyModifiers(thisAsLiving, source, attacker, amount);
        }
        boolean bl = this.apugli$hasModifiedDamage = originalValue + additionalValue != originalValue;
        if (additionalValue > 0.0f && (class_12972 = source.method_5529()) instanceof class_1657 && (enchantmentDamageBonus = class_1890.method_8218((class_1799)(attacker = (class_1657)class_12972).method_6047(), (class_1310)this.method_6046())) <= 0.0f && !this.method_37908().field_9236) {
            attacker.method_7304((class_1297)this);
        }
        return originalValue + additionalValue;
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isSleeping()Z")}, cancellable=true)
    private void apugli$preventHitIfDamageIsZero(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.apugli$hasModifiedDamage && amount == 0.0f) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;actuallyHurt(Lnet/minecraft/world/damagesource/DamageSource;F)V")})
    private void apugli$runDamageFunctionsBeforeDamaged(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (amount == 0.0f) {
            return;
        }
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            Services.POWER.getPowers(living, ApugliPowers.ACTION_ON_HARM.get()).forEach(p -> ApugliPowers.ACTION_ON_HARM.get().execute(p, living, source, amount, (class_1309)this));
            Services.POWER.getPowers(living, ApugliPowers.DAMAGE_NEARBY_ON_HIT.get()).forEach(p -> ApugliPowers.DAMAGE_NEARBY_ON_HIT.get().execute(p, living, source, amount, (class_1309)this));
        }
        Services.POWER.getPowers((class_1309)this, ApugliPowers.ACTION_WHEN_HARMED.get()).forEach(p -> ApugliPowers.ACTION_WHEN_HARMED.get().execute(p, (class_1309)this, source, amount));
        Services.POWER.getPowers((class_1309)this, ApugliPowers.DAMAGE_NEARBY_WHEN_HIT.get()).forEach(p -> ApugliPowers.DAMAGE_NEARBY_WHEN_HIT.get().execute(p, (class_1309)this, source, amount));
    }

    @Inject(method={"eat"}, at={@At(value="HEAD")})
    private void apugli$eatStackFood(class_1937 world, class_1799 stack, CallbackInfoReturnable<class_1799> cir) {
        class_1297 class_12972 = ((ItemStackAccess)stack).apugli$getEntity();
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            Optional<EdibleItemPower> power = Services.POWER.getPowers(living, ApugliPowers.EDIBLE_ITEM.get()).stream().filter(p -> p.doesApply(world, stack)).findFirst();
            power.ifPresent(p -> {
                world.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), this.method_18869(stack), class_3419.field_15254, 1.0f, 1.0f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.4f);
                List list = p.getFoodComponent().method_19235();
                for (Pair pair : list) {
                    if (world.field_9236 || pair.getFirst() == null || !(world.field_9229.method_43057() < ((Float)pair.getSecond()).floatValue())) continue;
                    this.method_6092(new class_1293((class_1293)pair.getFirst()));
                }
            });
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void apugli$tickLivingEntity(CallbackInfo ci) {
        if (!this.method_5805()) {
            return;
        }
        InventoryUtil.forEachStack((class_1297)((class_1309)this), stack -> ((ItemStackAccess)stack).apugli$setEntity((class_1297)((class_1309)this)));
        if (Services.POWER.hasPower((class_1309)this, ApugliPowers.HOVER.get())) {
            this.method_18799(this.method_18798().method_18805(1.0, 0.0, 1.0));
            this.field_6017 = 0.0f;
        }
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")})
    private void apugli$travelLivingEntity(class_243 movementInput, CallbackInfo ci) {
        if (this.method_29504() || this.method_37908().field_9236) {
            return;
        }
        ApugliPowers.BUNNY_HOP.get().onTravel((class_1309)this, movementInput);
    }
}

