/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.c2s;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Active;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.component.ApugliEntityComponents;
import net.merchantpug.apugli.component.KeyPressComponent;
import net.merchantpug.apugli.network.ApugliPackets;
import net.merchantpug.apugli.network.c2s.ApugliPacketC2S;
import net.merchantpug.apugli.network.s2c.SyncKeysLessenedPacket;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public record UpdateKeysPressedPacket(Set<Active.Key> addedKeys, Set<Active.Key> removedKeys) implements ApugliPacketC2S
{
    public static final class_2960 ID = Apugli.asResource("update_keys_pressed");

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(this.addedKeys.size());
        for (Active.Key key : this.addedKeys) {
            ApoliDataTypes.KEY.send(buf, (Object)key);
        }
        buf.writeInt(this.removedKeys.size());
        for (Active.Key key : this.removedKeys) {
            ApoliDataTypes.KEY.send(buf, (Object)key);
        }
    }

    public static UpdateKeysPressedPacket decode(class_2540 buf) {
        HashSet<Active.Key> addedKeys = new HashSet<Active.Key>();
        int addedKeySize = buf.readInt();
        for (int i = 0; i < addedKeySize; ++i) {
            addedKeys.add((Active.Key)ApoliDataTypes.KEY.receive(buf));
        }
        HashSet<Active.Key> removedKeys = new HashSet<Active.Key>();
        int removedKeySize = buf.readInt();
        for (int i = 0; i < removedKeySize; ++i) {
            removedKeys.add((Active.Key)ApoliDataTypes.KEY.receive(buf));
        }
        return new UpdateKeysPressedPacket(addedKeys, removedKeys);
    }

    @Override
    public class_2960 getFabricId() {
        return ID;
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        server.execute(() -> {
            KeyPressComponent component = (KeyPressComponent)ApugliEntityComponents.KEY_PRESS_COMPONENT.get((Object)player);
            this.addedKeys.forEach(component::addKey);
            this.removedKeys.forEach(component::removeKey);
            Set<Active.Key> keysToAdd = component.getCurrentlyUsedKeys().stream().filter(key -> !component.getPreviouslyUsedKeys().contains(key)).collect(Collectors.toSet());
            Set<Active.Key> keysToRemove = component.getPreviouslyUsedKeys().stream().filter(key -> !component.getCurrentlyUsedKeys().contains(key)).collect(Collectors.toSet());
            component.setPreviouslyUsedKeys();
            ArrayList<class_3222> players = new ArrayList<class_3222>(PlayerLookup.tracking((class_1297)player));
            players.add(player);
            for (class_3222 otherPlayer : players) {
                ApugliPackets.sendS2C(new SyncKeysLessenedPacket(player.method_5628(), keysToAdd, keysToRemove), otherPlayer);
            }
        });
    }
}

