/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;

public record SendParticlesPacket(class_2394 effect, boolean force, double x, double y, double z, float offsetX, float offsetY, float offsetZ, float speed, Optional<class_243> velocity, int count) implements ApugliPacketS2C
{
    public static final class_2960 ID = Apugli.asResource("send_particles");

    @Override
    public void encode(class_2540 buf) {
        SerializableDataTypes.PARTICLE_EFFECT.send(buf, (Object)this.effect);
        buf.writeBoolean(this.force);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.offsetX);
        buf.writeFloat(this.offsetY);
        buf.writeFloat(this.offsetZ);
        buf.writeBoolean(this.velocity.isPresent());
        this.velocity.ifPresentOrElse(vec3d -> {
            buf.writeDouble(vec3d.field_1352);
            buf.writeDouble(vec3d.field_1351);
            buf.writeDouble(vec3d.field_1350);
        }, () -> buf.writeFloat(this.speed));
        buf.writeInt(this.count);
    }

    public static SendParticlesPacket decode(class_2540 buf) {
        class_243 velocity;
        float speed;
        class_2394 effect = (class_2394)SerializableDataTypes.PARTICLE_EFFECT.receive(buf);
        boolean force = buf.readBoolean();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        float offsetX = buf.readFloat();
        float offsetY = buf.readFloat();
        float offsetZ = buf.readFloat();
        boolean hasVelocity = buf.readBoolean();
        if (hasVelocity) {
            speed = 0.0f;
            velocity = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        } else {
            speed = buf.readFloat();
            velocity = null;
        }
        int count = buf.readInt();
        return new SendParticlesPacket(effect, force, x, y, z, offsetX, offsetY, offsetZ, speed, Optional.ofNullable(velocity), count);
    }

    @Override
    public class_2960 getFabricId() {
        return ID;
    }

    @Override
    public void handle() {
        class_310.method_1551().execute(new Runnable(){

            @Override
            public void run() {
                class_638 world = class_310.method_1551().field_1687;
                if (world == null) {
                    Apugli.LOG.info("Could not find world to send particles to.");
                    return;
                }
                if (SendParticlesPacket.this.count == 0) {
                    try {
                        double d = SendParticlesPacket.this.velocity.isPresent() ? SendParticlesPacket.this.velocity.get().field_1352 : (double)(SendParticlesPacket.this.speed * SendParticlesPacket.this.offsetX);
                        double e = SendParticlesPacket.this.velocity.isPresent() ? SendParticlesPacket.this.velocity.get().field_1351 : (double)(SendParticlesPacket.this.speed * SendParticlesPacket.this.offsetY);
                        double f = SendParticlesPacket.this.velocity.isPresent() ? SendParticlesPacket.this.velocity.get().field_1350 : (double)(SendParticlesPacket.this.speed * SendParticlesPacket.this.offsetZ);
                        world.method_8466(SendParticlesPacket.this.effect, SendParticlesPacket.this.force, SendParticlesPacket.this.x, SendParticlesPacket.this.y, SendParticlesPacket.this.z, d, e, f);
                    }
                    catch (Throwable throwable) {
                        Apugli.LOG.warn("Could not spawn particle effect {}", (Object)SendParticlesPacket.this.effect);
                    }
                } else {
                    for (int i = 0; i < SendParticlesPacket.this.count; ++i) {
                        double g = world.field_9229.method_43059() * (double)SendParticlesPacket.this.offsetX;
                        double h = world.field_9229.method_43059() * (double)SendParticlesPacket.this.offsetY;
                        double j = world.field_9229.method_43059() * (double)SendParticlesPacket.this.offsetZ;
                        double k = SendParticlesPacket.this.velocity.map(v -> v.field_1352).orElseGet(() -> world.field_9229.method_43059() * (double)SendParticlesPacket.this.speed);
                        double l = SendParticlesPacket.this.velocity.map(v -> v.field_1351).orElseGet(() -> world.field_9229.method_43059() * (double)SendParticlesPacket.this.speed);
                        double m = SendParticlesPacket.this.velocity.map(v -> v.field_1350).orElseGet(() -> world.field_9229.method_43059() * (double)SendParticlesPacket.this.speed);
                        try {
                            world.method_8466(SendParticlesPacket.this.effect, SendParticlesPacket.this.force, SendParticlesPacket.this.x + g, SendParticlesPacket.this.y + h, SendParticlesPacket.this.z + j, k, l, m);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            Apugli.LOG.warn("Could not spawn particle effect {}", (Object)SendParticlesPacket.this.effect);
                            return;
                        }
                    }
                }
            }
        });
    }
}

