/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.access.ExplosionAccess;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_5362;
import net.minecraft.class_638;

public record SyncExplosionPacket<BI, B>(int userId, double x, double y, double z, List<?> damageModifiers, List<?> knockbackModifiers, List<?> volumeModifiers, List<?> pitchModifiers, @Nullable BI biEntityConditions, boolean hasCalculator, @Nullable B blockConditions, boolean indestructible, float power) implements ApugliPacketS2C
{
    public static final class_2960 ID = Apugli.asResource("sync_explosion");

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(this.userId());
        buf.writeDouble(this.x());
        buf.writeDouble(this.y());
        buf.writeDouble(this.z());
        Services.PLATFORM.getModifiersDataType().send(buf, this.damageModifiers());
        Services.PLATFORM.getModifiersDataType().send(buf, this.knockbackModifiers());
        Services.PLATFORM.getModifiersDataType().send(buf, this.volumeModifiers());
        Services.PLATFORM.getModifiersDataType().send(buf, this.pitchModifiers());
        buf.writeBoolean(this.biEntityConditions() != null);
        if (this.biEntityConditions() != null) {
            Services.CONDITION.biEntityDataType().send(buf, this.biEntityConditions());
        }
        buf.writeBoolean(this.hasCalculator());
        buf.writeBoolean(this.blockConditions() != null);
        if (this.blockConditions() != null) {
            Services.CONDITION.blockDataType().send(buf, this.blockConditions());
        }
        buf.writeBoolean(this.indestructible());
        buf.writeFloat(this.power());
    }

    public static <BI, B> SyncExplosionPacket<BI, B> decode(class_2540 buf) {
        int userId = buf.readInt();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        List damageModifiers = (List)Services.PLATFORM.getModifiersDataType().receive(buf);
        List knockbackModifiers = (List)Services.PLATFORM.getModifiersDataType().receive(buf);
        List volumeModifiers = (List)Services.PLATFORM.getModifiersDataType().receive(buf);
        List pitchModifiers = (List)Services.PLATFORM.getModifiersDataType().receive(buf);
        boolean hasBiEntityCondition = buf.readBoolean();
        Object biEntityCondition = null;
        if (hasBiEntityCondition) {
            biEntityCondition = Services.CONDITION.biEntityDataType().receive(buf);
        }
        boolean hasCalculator = buf.readBoolean();
        boolean hasBlockDataCondition = buf.readBoolean();
        Object blockDataCondition = null;
        if (hasBlockDataCondition) {
            blockDataCondition = Services.CONDITION.blockDataType().receive(buf);
        }
        boolean indestructible = buf.readBoolean();
        float radius = buf.readFloat();
        return new SyncExplosionPacket<Object, Object>(userId, x, y, z, damageModifiers, knockbackModifiers, volumeModifiers, pitchModifiers, biEntityCondition, hasCalculator, blockDataCondition, indestructible, radius);
    }

    @Override
    public class_2960 getFabricId() {
        return ID;
    }

    @Override
    public void handle() {
        class_310.method_1551().execute(new Runnable(){

            @Override
            public void run() {
                class_638 level = class_310.method_1551().field_1687;
                class_1297 entity = level.method_8469(SyncExplosionPacket.this.userId);
                class_1927 explosion = new class_1927((class_1937)level, entity, null, SyncExplosionPacket.this.createBlockConditionedExplosionDamageCalculator(SyncExplosionPacket.this.blockConditions(), (class_1937)level, SyncExplosionPacket.this.indestructible), SyncExplosionPacket.this.x, SyncExplosionPacket.this.y, SyncExplosionPacket.this.z, SyncExplosionPacket.this.power, false, class_1927.class_4179.field_40878);
                ((ExplosionAccess)explosion).apugli$setExplosionDamageModifiers(SyncExplosionPacket.this.damageModifiers());
                ((ExplosionAccess)explosion).apugli$setExplosionKnockbackModifiers(SyncExplosionPacket.this.knockbackModifiers());
                ((ExplosionAccess)explosion).apugli$setExplosionVolumeModifiers(SyncExplosionPacket.this.volumeModifiers());
                ((ExplosionAccess)explosion).apugli$setExplosionPitchModifiers(SyncExplosionPacket.this.pitchModifiers());
                ((ExplosionAccess)explosion).apugli$setBiEntityPredicate(SyncExplosionPacket.this.biEntityConditions());
                explosion.method_8350(true);
            }
        });
    }

    private <C> class_5362 createBlockConditionedExplosionDamageCalculator(final C blockCondition, final class_1937 levelIn, final boolean indestructible) {
        return new class_5362(){

            public Optional<Float> method_29555(class_1927 explosion, class_1922 level, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
                Optional ovr;
                Optional def = super.method_29555(explosion, level, pos, blockState, fluidState);
                Optional<Object> optional = ovr = Services.CONDITION.checkBlock(blockCondition, levelIn, pos) == indestructible ? Optional.of(Float.valueOf(class_2246.field_10382.method_9520())) : Optional.empty();
                return ovr.isPresent() ? (def.isPresent() ? (((Float)def.get()).floatValue() > ((Float)ovr.get()).floatValue() ? def : ovr) : ovr) : def;
            }
        };
    }
}

