/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.component.ApugliEntityComponents;
import net.merchantpug.apugli.component.HitsOnTargetComponent;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;

public record SyncHitsOnTargetLessenedPacket(int entityId, Map<Integer, class_3545<Integer, Integer>> previousHits, Map<Integer, class_3545<Integer, Integer>> hits) implements ApugliPacketS2C
{
    public static final class_2960 ID = Apugli.asResource("sync_hits_on_target_lessened");

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.previousHits.size());
        this.previousHits.forEach((entityId, value) -> {
            buf.writeInt(entityId.intValue());
            buf.writeInt(((Integer)value.method_15442()).intValue());
            buf.writeInt(((Integer)value.method_15441()).intValue());
        });
        buf.writeInt(this.hits.size());
        this.hits.forEach((entityId, value) -> {
            buf.writeInt(entityId.intValue());
            buf.writeInt(((Integer)value.method_15442()).intValue());
            buf.writeInt(((Integer)value.method_15441()).intValue());
        });
    }

    public static SyncHitsOnTargetLessenedPacket decode(class_2540 buf) {
        int entityId = buf.readInt();
        int updateSize = buf.readInt();
        HashMap<Integer, class_3545<Integer, Integer>> previousHits = new HashMap<Integer, class_3545<Integer, Integer>>();
        for (int i = 0; i < updateSize; ++i) {
            int otherEntityId = buf.readInt();
            int amount = buf.readInt();
            int ticksLeft = buf.readInt();
            previousHits.put(otherEntityId, (class_3545<Integer, Integer>)new class_3545((Object)amount, (Object)ticksLeft));
        }
        int hitsSize = buf.readInt();
        HashMap<Integer, class_3545<Integer, Integer>> hits = new HashMap<Integer, class_3545<Integer, Integer>>();
        for (int i = 0; i < hitsSize; ++i) {
            int otherEntityId = buf.readInt();
            int amount = buf.readInt();
            int ticksLeft = buf.readInt();
            hits.put(otherEntityId, (class_3545<Integer, Integer>)new class_3545((Object)amount, (Object)ticksLeft));
        }
        return new SyncHitsOnTargetLessenedPacket(entityId, previousHits, hits);
    }

    @Override
    public class_2960 getFabricId() {
        return ID;
    }

    @Override
    public void handle() {
        class_310.method_1551().execute(() -> {
            class_1297 entity = class_310.method_1551().field_1687.method_8469(this.entityId);
            if (!(entity instanceof class_1309)) {
                Apugli.LOG.warn("Could not find living entity to sync hits on target with.");
                return;
            }
            HitsOnTargetComponent component = (HitsOnTargetComponent)ApugliEntityComponents.HITS_ON_TARGET_COMPONENT.get((Object)entity);
            HashMap<Integer, Object> updateMap = new HashMap<Integer, Object>();
            HashSet removalMap = new HashSet();
            for (Map.Entry<Integer, class_3545<Integer, Integer>> entry : this.hits.entrySet()) {
                if (!this.previousHits.containsKey(entry.getKey())) {
                    updateMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                class_3545<Integer, Integer> currentPair = entry.getValue();
                class_3545<Integer, Integer> previousPair = this.previousHits.get(entry.getKey());
                if (((Integer)currentPair.method_15442()).equals(previousPair.method_15442()) && ((Integer)currentPair.method_15441()).equals(currentPair.method_15441())) continue;
                updateMap.put(entry.getKey(), entry.getValue());
            }
            this.previousHits.keySet().stream().filter(key -> !this.hits.containsKey(key)).forEach(removalMap::add);
            updateMap.forEach((entityId, value) -> component.setHits((int)entityId, (Integer)value.method_15442(), (Integer)value.method_15441()));
            removalMap.forEach(component::removeHits);
        });
    }
}

