/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Active;
import java.util.HashSet;
import java.util.Set;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.component.ApugliEntityComponents;
import net.merchantpug.apugli.component.KeyPressComponent;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public record SyncKeysLessenedPacket(int entityId, Set<Active.Key> addedKeys, Set<Active.Key> removedKeys) implements ApugliPacketS2C
{
    public static final class_2960 ID = Apugli.asResource("sync_keys_lessened");

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.addedKeys.size());
        for (Active.Key key : this.addedKeys) {
            ApoliDataTypes.KEY.send(buf, (Object)key);
        }
        buf.writeInt(this.removedKeys.size());
        for (Active.Key key : this.removedKeys) {
            ApoliDataTypes.KEY.send(buf, (Object)key);
        }
    }

    public static SyncKeysLessenedPacket decode(class_2540 buf) {
        int entityId = buf.readInt();
        HashSet<Active.Key> addedKeys = new HashSet<Active.Key>();
        int keysToAddSize = buf.readInt();
        for (int i = 0; i < keysToAddSize; ++i) {
            addedKeys.add((Active.Key)ApoliDataTypes.KEY.receive(buf));
        }
        HashSet<Active.Key> removedKeys = new HashSet<Active.Key>();
        int keysToRemoveSize = buf.readInt();
        for (int i = 0; i < keysToRemoveSize; ++i) {
            removedKeys.add((Active.Key)ApoliDataTypes.KEY.receive(buf));
        }
        return new SyncKeysLessenedPacket(entityId, addedKeys, removedKeys);
    }

    @Override
    public class_2960 getFabricId() {
        return ID;
    }

    @Override
    public void handle() {
        class_310.method_1551().execute(() -> {
            class_1297 entity = class_310.method_1551().field_1687.method_8469(this.entityId);
            if (!(entity instanceof class_1657)) {
                Apugli.LOG.warn("Could not find player entity to sync keys with.");
                return;
            }
            class_1657 player = (class_1657)entity;
            KeyPressComponent component = (KeyPressComponent)ApugliEntityComponents.KEY_PRESS_COMPONENT.get((Object)player);
            for (Active.Key key : this.addedKeys) {
                component.addKey(key);
            }
            for (Active.Key key : this.removedKeys) {
                component.removeKey(key);
            }
        });
    }
}

