/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import java.util.HashSet;
import java.util.Set;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.client.util.TextureUtilClient;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.lang3.tuple.Triple;

public record UpdateUrlTexturesPacket(Set<Triple<class_2960, String, class_2960>> urlTextures) implements ApugliPacketS2C
{
    public static final class_2960 ID = Apugli.asResource("update_url_textures");

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(this.urlTextures.size());
        for (Triple<class_2960, String, class_2960> entry : this.urlTextures) {
            buf.method_10812((class_2960)entry.getLeft());
            buf.method_10814((String)entry.getMiddle());
            buf.writeBoolean(entry.getRight() != null);
            if (entry.getRight() == null) continue;
            buf.method_10812((class_2960)entry.getRight());
        }
    }

    public static UpdateUrlTexturesPacket decode(class_2540 buf) {
        int powerTypesSize = buf.readInt();
        HashSet<Triple<class_2960, String, class_2960>> powerData = new HashSet<Triple<class_2960, String, class_2960>>();
        for (int i = 0; i < powerTypesSize; ++i) {
            class_2960 textureId = buf.method_10810();
            String textureUrl = buf.method_19772();
            boolean hasTextureLocation = buf.readBoolean();
            class_2960 textureLocation = null;
            if (hasTextureLocation) {
                textureLocation = buf.method_10810();
            }
            powerData.add((Triple<class_2960, String, class_2960>)Triple.of((Object)textureId, (Object)textureUrl, (Object)textureLocation));
        }
        return new UpdateUrlTexturesPacket(powerData);
    }

    @Override
    public class_2960 getFabricId() {
        return ID;
    }

    @Override
    public void handle() {
        class_310.method_1551().execute(() -> {
            this.urlTextures.forEach(value -> {
                if (value.getRight() != null && TextureUtilClient.doesTextureExist((class_2960)value.getRight())) {
                    return;
                }
                TextureUtilClient.registerPowerTexture((class_2960)value.getLeft(), (String)value.getMiddle(), false);
            });
            TextureUtilClient.update();
        });
    }
}

