/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c.integration.pehkui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.access.ScaleDataAccess;
import net.merchantpug.apugli.integration.pehkui.ApoliScaleModifier;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.compress.utils.Lists;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;

public record SyncScalePacket(int entityId, List<class_2960> scaleTypes, class_2960 powerId, boolean remove) implements ApugliPacketS2C
{
    public static final class_2960 ID = Apugli.asResource("sync_scale");

    @Deprecated
    public static SyncScalePacket addScaleToClient(int entityId, List<class_2960> scaleTypes, class_2960 powerId) {
        return new SyncScalePacket(entityId, scaleTypes, powerId, false);
    }

    public static SyncScalePacket removeScaleFromClient(int entityId, List<class_2960> scaleTypes, class_2960 powerId) {
        return new SyncScalePacket(entityId, scaleTypes, powerId, true);
    }

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(this.entityId());
        buf.writeInt(this.scaleTypes().size());
        for (int i = 0; i < this.scaleTypes().size(); ++i) {
            buf.method_10812(this.scaleTypes().get(i));
        }
        buf.method_10812(this.powerId());
        buf.writeBoolean(this.remove());
    }

    public static SyncScalePacket decode(class_2540 buf) {
        int entityId = buf.readInt();
        int typeSize = buf.readInt();
        ArrayList scaleTypes = Lists.newArrayList();
        for (int i = 0; i < typeSize; ++i) {
            class_2960 typeId = buf.method_10810();
            scaleTypes.add(typeId);
        }
        class_2960 powerId = buf.method_10810();
        boolean remove = buf.readBoolean();
        return new SyncScalePacket(entityId, scaleTypes, powerId, remove);
    }

    @Override
    public class_2960 getFabricId() {
        return ID;
    }

    @Override
    public void handle() {
        class_310.method_1551().execute(new Runnable(){

            @Override
            public void run() {
                if (!Services.PLATFORM.isModLoaded("pehkui")) {
                    Apugli.LOG.warn("Attempted loading SyncScalePacket without Pehkui.");
                    return;
                }
                class_1297 entity = class_310.method_1551().field_1687.method_8469(SyncScalePacket.this.entityId());
                if (entity == null) {
                    return;
                }
                Object object = ApugliPowers.MODIFY_SCALE.get().getApoliScaleModifier(SyncScalePacket.this.powerId(), entity);
                if (!(object instanceof ApoliScaleModifier)) {
                    Apugli.LOG.warn("Could not find ApoliScaleModifier for syncing removal from order list.");
                    return;
                }
                ApoliScaleModifier apoliModifier = (ApoliScaleModifier)((Object)object);
                for (class_2960 scaleTypeId : SyncScalePacket.this.scaleTypes()) {
                    ScaleType scaleType = (ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (class_2960)scaleTypeId);
                    ScaleData scaleData = scaleType.getScaleData(entity);
                    ((ScaleDataAccess)scaleData).apugli$removeFromApoliScaleModifiers(SyncScalePacket.this.powerId());
                    scaleData.getBaseValueModifiers().remove((Object)apoliModifier);
                    if (SyncScalePacket.this.remove()) continue;
                    ((ScaleDataAccess)scaleData).apugli$addToApoliScaleModifiers(SyncScalePacket.this.powerId());
                    scaleData.getBaseValueModifiers().add(apoliModifier);
                }
            }
        });
    }
}

