/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.platform;

import com.google.auto.service.AutoService;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import java.util.Optional;
import java.util.function.Consumer;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.merchantpug.apugli.platform.services.IActionHelper;
import net.merchantpug.apugli.util.ActionFactoryWrapperCodec;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

@AutoService(value={IActionHelper.class})
public class FabricActionHelper
implements IActionHelper {
    @Override
    public SerializableDataType<?> biEntityDataType() {
        return ApoliDataTypes.BIENTITY_ACTION;
    }

    @Override
    public void registerBiEntity(String name, IActionFactory<class_3545<class_1297, class_1297>> action) {
        class_2960 id = Apugli.asResource(name);
        class_2378.method_10230((class_2378)ApoliRegistries.BIENTITY_ACTION, (class_2960)id, (Object)new ActionFactory(id, action.getSerializableData(), action::execute));
    }

    @Override
    public void executeBiEntity(SerializableData.Instance data, String fieldName, class_1297 actor, class_1297 target) {
        if (data.isPresent(fieldName)) {
            ((Consumer)data.get(fieldName)).accept(new class_3545((Object)actor, (Object)target));
        }
    }

    @Override
    public <A> void executeBiEntity(A action, class_1297 actor, class_1297 target) {
        if (action != null) {
            ((Consumer)action).accept(new class_3545((Object)actor, (Object)target));
        }
    }

    @Override
    @Nullable
    public Consumer<class_3545<class_1297, class_1297>> biEntityConsumer(SerializableData.Instance data, String fieldName) {
        return (Consumer)data.get(fieldName);
    }

    @Override
    public <T> void writeBiEntityActionToNbt(class_2487 tag, String path, T object) {
        if (object == null) {
            return;
        }
        ActionFactoryWrapperCodec codec = new ActionFactoryWrapperCodec(ApoliRegistries.BIENTITY_ACTION);
        ActionFactory.Instance instance = (ActionFactory.Instance)object;
        Optional tagOptional = codec.encodeStart((DynamicOps)class_2509.field_11560, instance).resultOrPartial(s -> Apugli.LOG.warn("Could only partially encode bi-entity action to tag: {}", s));
        if (tagOptional.isEmpty()) {
            Apugli.LOG.error("Failed to serialize bi-entity action to tag.");
            return;
        }
        tag.method_10566(path, (class_2520)tagOptional.get());
    }

    @Override
    public <T> T readBiEntityActionFromNbt(class_2487 tag, String path) {
        if (!tag.method_10573(path, 10)) {
            return null;
        }
        ActionFactoryWrapperCodec codec = new ActionFactoryWrapperCodec(ApoliRegistries.BIENTITY_ACTION);
        Optional<ActionFactory.Instance> instanceOptional = codec.decode((DynamicOps)class_2509.field_11560, tag.method_10562(path)).resultOrPartial(s -> Apugli.LOG.warn("Could only partially decode bi-entity action from tag: {}", s)).map(Pair::getFirst);
        if (instanceOptional.isEmpty()) {
            Apugli.LOG.error("Failed to deserialize bi-entity action from tag.");
            return null;
        }
        return (T)instanceOptional.get();
    }

    @Override
    public SerializableDataType<?> blockDataType() {
        return ApoliDataTypes.BLOCK_ACTION;
    }

    @Override
    public void registerBlock(String name, IActionFactory<Triple<class_1937, class_2338, class_2350>> action) {
        class_2960 id = Apugli.asResource(name);
        class_2378.method_10230((class_2378)ApoliRegistries.BLOCK_ACTION, (class_2960)id, (Object)new ActionFactory(id, action.getSerializableData(), action::execute));
    }

    @Override
    public void executeBlock(SerializableData.Instance data, String fieldName, class_1937 level, class_2338 pos, class_2350 direction) {
        if (data.isPresent(fieldName)) {
            ((Consumer)data.get(fieldName)).accept(Triple.of((Object)level, (Object)pos, (Object)direction));
        }
    }

    @Override
    public <A> void executeBlock(A action, class_1937 level, class_2338 pos, class_2350 direction) {
        if (action != null) {
            ((Consumer)action).accept(Triple.of((Object)level, (Object)pos, (Object)direction));
        }
    }

    @Override
    public Consumer<Triple<class_1937, class_2338, class_2350>> blockConsumer(SerializableData.Instance data, String fieldName) {
        return (Consumer)data.get(fieldName);
    }

    @Override
    public <T> void writeBlockActionToNbt(class_2487 tag, String path, T object) {
        if (object == null) {
            return;
        }
        ActionFactoryWrapperCodec codec = new ActionFactoryWrapperCodec(ApoliRegistries.BIENTITY_ACTION);
        ActionFactory.Instance instance = (ActionFactory.Instance)object;
        Optional tagOptional = codec.encodeStart((DynamicOps)class_2509.field_11560, instance).resultOrPartial(s -> Apugli.LOG.warn("Could only partially encode block action to tag: {}", s));
        if (tagOptional.isEmpty()) {
            Apugli.LOG.error("Failed to serialize block action to tag.");
            return;
        }
        tag.method_10566(path, (class_2520)tagOptional.get());
    }

    @Override
    public <T> T readBlockActionFromNbt(class_2487 tag, String path) {
        if (!tag.method_10573(path, 10)) {
            return null;
        }
        ActionFactoryWrapperCodec codec = new ActionFactoryWrapperCodec(ApoliRegistries.BLOCK_ACTION);
        Optional<ActionFactory.Instance> instanceOptional = codec.decode((DynamicOps)class_2509.field_11560, tag.method_10562(path)).resultOrPartial(s -> Apugli.LOG.warn("Could only partially decode bi-entity action from tag: {}", s)).map(Pair::getFirst);
        if (instanceOptional.isEmpty()) {
            Apugli.LOG.error("Failed to deserialize bi-entity action from tag.");
            return null;
        }
        return (T)instanceOptional.get();
    }

    @Override
    public SerializableDataType<?> entityDataType() {
        return ApoliDataTypes.ENTITY_ACTION;
    }

    @Override
    public void registerEntity(String name, IActionFactory<class_1297> action) {
        class_2960 id = Apugli.asResource(name);
        class_2378.method_10230((class_2378)ApoliRegistries.ENTITY_ACTION, (class_2960)id, (Object)new ActionFactory(id, action.getSerializableData(), action::execute));
    }

    @Override
    public void executeEntity(SerializableData.Instance data, String fieldName, class_1297 entity) {
        if (data.isPresent(fieldName)) {
            ((Consumer)data.get(fieldName)).accept(entity);
        }
    }

    @Override
    public <A> void executeEntity(A action, class_1297 entity) {
        if (action != null) {
            ((Consumer)action).accept(entity);
        }
    }

    @Override
    public Consumer<class_1297> entityConsumer(SerializableData.Instance data, String fieldName) {
        return (Consumer)data.get(fieldName);
    }

    @Override
    public SerializableDataType<?> itemDataType() {
        return ApoliDataTypes.ITEM_ACTION;
    }

    @Override
    public void registerItem(String name, IActionFactory<class_3545<class_1937, Mutable<class_1799>>> action) {
        class_2960 id = Apugli.asResource(name);
        class_2378.method_10230((class_2378)ApoliRegistries.ITEM_ACTION, (class_2960)id, (Object)new ActionFactory(id, action.getSerializableData(), (data, pair) -> action.execute((SerializableData.Instance)data, (class_3545<class_1937, Mutable<class_1799>>)new class_3545((Object)((class_1937)pair.method_15442()), (Object)new MutableObject((Object)((class_1799)pair.method_15441()))))));
    }

    @Override
    public void executeItem(SerializableData.Instance data, String fieldName, class_1937 level, Mutable<class_1799> mutable) {
        if (data.isPresent(fieldName)) {
            ((Consumer)data.get(fieldName)).accept(new class_3545((Object)level, (Object)((class_1799)mutable.getValue())));
        }
    }

    @Override
    public <A> void executeEntity(A action, class_1937 level, Mutable<class_1799> mutable) {
        if (action != null) {
            ((Consumer)action).accept(new class_3545((Object)level, (Object)((class_1799)mutable.getValue())));
        }
    }

    @Override
    public Consumer<class_3545<class_1937, Mutable<class_1799>>> itemConsumer(SerializableData.Instance data, String fieldName) {
        return data.isPresent(fieldName) ? levelAndStack -> ((Consumer)data.get(fieldName)).accept(new class_3545((Object)((class_1937)levelAndStack.method_15442()), (Object)((class_1799)((Mutable)levelAndStack.method_15441()).getValue()))) : null;
    }
}

