/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.platform;

import com.google.auto.service.AutoService;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import java.util.Optional;
import java.util.function.Predicate;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.condition.factory.IConditionFactory;
import net.merchantpug.apugli.platform.services.IConditionHelper;
import net.merchantpug.apugli.util.ConditionFactoryWrapperCodec;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2694;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3610;
import net.minecraft.class_4538;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

@AutoService(value={IConditionHelper.class})
public class FabricConditionHelper
implements IConditionHelper {
    @Override
    public SerializableDataType<?> biEntityDataType() {
        return ApoliDataTypes.BIENTITY_CONDITION;
    }

    @Override
    public void registerBiEntity(String name, IConditionFactory<class_3545<class_1297, class_1297>> condition) {
        class_2960 id = Apugli.asResource(name);
        class_2378.method_10230((class_2378)ApoliRegistries.BIENTITY_CONDITION, (class_2960)id, (Object)new ConditionFactory(id, condition.getSerializableData(), condition::check));
    }

    @Override
    public boolean checkBiEntity(SerializableData.Instance data, String fieldName, class_1297 actor, class_1297 target) {
        return !data.isPresent(fieldName) || ((Predicate)data.get(fieldName)).test(new class_3545((Object)actor, (Object)target));
    }

    @Override
    public <C> boolean checkBiEntity(C condition, class_1297 actor, class_1297 target) {
        return condition == null || ((Predicate)condition).test(new class_3545((Object)actor, (Object)target));
    }

    @Override
    @Nullable
    public Predicate<class_3545<class_1297, class_1297>> biEntityPredicate(SerializableData.Instance data, String fieldName) {
        return (Predicate)data.get(fieldName);
    }

    @Override
    public <T> void writeBiEntityConditionToNbt(class_2487 tag, String path, T object) {
        if (object == null) {
            return;
        }
        ConditionFactoryWrapperCodec codec = new ConditionFactoryWrapperCodec(ApoliRegistries.BIENTITY_CONDITION);
        ConditionFactory.Instance instance = (ConditionFactory.Instance)object;
        Optional tagOptional = codec.encodeStart((DynamicOps)class_2509.field_11560, instance).resultOrPartial(s -> Apugli.LOG.warn("Could only partially encode bi-entity condition to tag: {}", s));
        if (tagOptional.isEmpty()) {
            Apugli.LOG.error("Failed to serialize bi-entity condition to tag.");
            return;
        }
        tag.method_10566(path, (class_2520)tagOptional.get());
    }

    @Override
    public <T> T readBiEntityConditionFromNbt(class_2487 tag, String path) {
        if (!tag.method_10573(path, 10)) {
            return null;
        }
        ConditionFactoryWrapperCodec codec = new ConditionFactoryWrapperCodec(ApoliRegistries.BIENTITY_CONDITION);
        Optional<ConditionFactory.Instance> instanceOptional = codec.decode((DynamicOps)class_2509.field_11560, tag.method_10562(path)).resultOrPartial(s -> Apugli.LOG.warn("Could only partially decode bi-entity condition from tag: {}", s)).map(Pair::getFirst);
        if (instanceOptional.isEmpty()) {
            Apugli.LOG.error("Failed to deserialize bi-entity condition from tag.");
            return null;
        }
        return (T)instanceOptional.get();
    }

    @Override
    public SerializableDataType<?> biomeDataType() {
        return ApoliDataTypes.BIOME_CONDITION;
    }

    @Override
    public void registerBiome(String name, IConditionFactory<class_6880<class_1959>> condition) {
        class_2960 id = Apugli.asResource(name);
        class_2378.method_10230((class_2378)ApoliRegistries.BIOME_CONDITION, (class_2960)id, (Object)new ConditionFactory(id, condition.getSerializableData(), condition::check));
    }

    @Override
    public boolean checkBiome(SerializableData.Instance data, String fieldName, class_6880<class_1959> biome) {
        return !data.isPresent(fieldName) || ((Predicate)data.get(fieldName)).test(biome);
    }

    @Override
    @Nullable
    public Predicate<class_6880<class_1959>> biomePredicate(SerializableData.Instance data, String fieldName) {
        return (Predicate)data.get(fieldName);
    }

    @Override
    public <C> boolean checkBiome(C condition, class_6880<class_1959> biome) {
        return condition == null || ((Predicate)condition).test(biome);
    }

    @Override
    public SerializableDataType<?> blockDataType() {
        return ApoliDataTypes.BLOCK_CONDITION;
    }

    @Override
    public void registerBlock(String name, IConditionFactory<class_2694> condition) {
        class_2960 id = Apugli.asResource(name);
        class_2378.method_10230((class_2378)ApoliRegistries.BLOCK_CONDITION, (class_2960)id, (Object)new ConditionFactory(id, condition.getSerializableData(), condition::check));
    }

    @Override
    public boolean checkBlock(SerializableData.Instance data, String fieldName, class_1937 level, class_2338 pos) {
        return !data.isPresent(fieldName) || ((Predicate)data.get(fieldName)).test(new class_2694((class_4538)level, pos, true));
    }

    @Override
    public <C> boolean checkBlock(C condition, class_1937 level, class_2338 pos) {
        return condition == null || ((Predicate)condition).test(new class_2694((class_4538)level, pos, true));
    }

    @Override
    public <T> void writeBlockConditionToNbt(class_2487 tag, String path, T object) {
        if (object == null) {
            return;
        }
        ConditionFactoryWrapperCodec codec = new ConditionFactoryWrapperCodec(ApoliRegistries.BLOCK_CONDITION);
        ConditionFactory.Instance instance = (ConditionFactory.Instance)object;
        Optional tagOptional = codec.encodeStart((DynamicOps)class_2509.field_11560, instance).resultOrPartial(s -> Apugli.LOG.warn("Could only partially encode block condition to tag: {}", s));
        if (tagOptional.isEmpty()) {
            Apugli.LOG.error("Failed to serialize block condition to tag.");
            return;
        }
        tag.method_10566(path, (class_2520)tagOptional.get());
    }

    @Override
    public <T> T readBlockConditionFromNbt(class_2487 tag, String path) {
        if (!tag.method_10573(path, 10)) {
            return null;
        }
        ConditionFactoryWrapperCodec codec = new ConditionFactoryWrapperCodec(ApoliRegistries.BLOCK_CONDITION);
        Optional<ConditionFactory.Instance> instanceOptional = codec.decode((DynamicOps)class_2509.field_11560, tag.method_10562(path)).resultOrPartial(s -> Apugli.LOG.warn("Could only partially decode block condition from tag: {}", s)).map(Pair::getFirst);
        if (instanceOptional.isEmpty()) {
            Apugli.LOG.error("Failed to deserialize block condition from tag.");
            return null;
        }
        return (T)instanceOptional.get();
    }

    @Override
    @Nullable
    public Predicate<class_2694> blockPredicate(SerializableData.Instance data, String fieldName) {
        return (Predicate)data.get(fieldName);
    }

    @Override
    public SerializableDataType<?> damageDataType() {
        return ApoliDataTypes.DAMAGE_CONDITION;
    }

    @Override
    public void registerDamage(String name, IConditionFactory<class_3545<class_1282, Float>> condition) {
        class_2960 id = Apugli.asResource(name);
        class_2378.method_10230((class_2378)ApoliRegistries.DAMAGE_CONDITION, (class_2960)id, (Object)new ConditionFactory(id, condition.getSerializableData(), condition::check));
    }

    @Override
    public boolean checkDamage(SerializableData.Instance data, String fieldName, class_1282 source, float amount) {
        return !data.isPresent(fieldName) || ((Predicate)data.get(fieldName)).test(new class_3545((Object)source, (Object)Float.valueOf(amount)));
    }

    @Override
    public <C> boolean checkDamage(C condition, class_1282 source, float amount) {
        return condition == null || ((Predicate)condition).test(new class_3545((Object)source, (Object)Float.valueOf(amount)));
    }

    @Override
    @Nullable
    public Predicate<class_3545<class_1282, Float>> damagePredicate(SerializableData.Instance data, String fieldName) {
        return (Predicate)data.get(fieldName);
    }

    @Override
    public SerializableDataType<?> entityDataType() {
        return ApoliDataTypes.ENTITY_CONDITION;
    }

    @Override
    public void registerEntity(String name, IConditionFactory<class_1297> condition) {
        class_2960 id = Apugli.asResource(name);
        class_2378.method_10230((class_2378)ApoliRegistries.ENTITY_CONDITION, (class_2960)id, (Object)new ConditionFactory(id, condition.getSerializableData(), condition::check));
    }

    @Override
    public boolean checkEntity(SerializableData.Instance data, String fieldName, class_1297 entity) {
        return !data.isPresent(fieldName) || ((Predicate)data.get(fieldName)).test(entity);
    }

    @Override
    public <C> boolean checkEntity(C condition, class_1297 entity) {
        return condition == null || ((Predicate)condition).test(entity);
    }

    @Override
    @Nullable
    public Predicate<class_1297> entityPredicate(SerializableData.Instance data, String fieldName) {
        return (Predicate)data.get(fieldName);
    }

    @Override
    public SerializableDataType<?> fluidDataType() {
        return ApoliDataTypes.FLUID_CONDITION;
    }

    @Override
    public void registerFluid(String name, IConditionFactory<class_3610> condition) {
        class_2960 id = Apugli.asResource(name);
        class_2378.method_10230((class_2378)ApoliRegistries.FLUID_CONDITION, (class_2960)id, (Object)new ConditionFactory(id, condition.getSerializableData(), condition::check));
    }

    @Override
    public boolean checkFluid(SerializableData.Instance data, String fieldName, class_3610 fluidState) {
        return !data.isPresent(fieldName) || ((Predicate)data.get(fieldName)).test(fluidState);
    }

    @Override
    public <C> boolean checkFluid(C condition, class_3610 fluidState) {
        return condition == null || ((Predicate)condition).test(fluidState);
    }

    @Override
    @Nullable
    public Predicate<class_3610> fluidPredicate(SerializableData.Instance data, String fieldName) {
        return (Predicate)data.get(fieldName);
    }

    @Override
    public SerializableDataType<?> itemDataType() {
        return ApoliDataTypes.ITEM_CONDITION;
    }

    @Override
    public void registerItem(String name, IConditionFactory<class_1799> condition) {
        class_2960 id = Apugli.asResource(name);
        class_2378.method_10230((class_2378)ApoliRegistries.ITEM_CONDITION, (class_2960)id, (Object)new ConditionFactory(id, condition.getSerializableData(), condition::check));
    }

    @Override
    public boolean checkItem(SerializableData.Instance data, String fieldName, class_1937 level, class_1799 stack) {
        return !data.isPresent(fieldName) || ((Predicate)data.get(fieldName)).test(stack);
    }

    @Override
    public <C> boolean checkItem(C condition, class_1937 level, class_1799 stack) {
        return condition == null || ((Predicate)condition).test(stack);
    }

    @Override
    @javax.annotation.Nullable
    public Predicate<class_3545<class_1937, class_1799>> itemPredicate(SerializableData.Instance data, String fieldName) {
        if (!data.isPresent(fieldName)) {
            return null;
        }
        return levelAndStack -> ((Predicate)data.get(fieldName)).test((class_1799)levelAndStack.method_15441());
    }
}

