/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.platform;

import com.google.auto.service.AutoService;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeReference;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.power.VariableIntPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.modifier.IModifierOperation;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.platform.services.IPowerHelper;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.merchantpug.apugli.power.factory.SpecialPowerFactory;
import net.merchantpug.apugli.registry.ApugliRegisters;
import net.merchantpug.apugli.registry.services.RegistryObject;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

@AutoService(value={IPowerHelper.class})
public class FabricPowerHelper
implements IPowerHelper<PowerTypeReference> {
    public PowerFactory<?> unwrapSimpleFactory(PowerFactory<?> factory) {
        return factory;
    }

    @Override
    public <F extends SimplePowerFactory<?>> RegistryObject<F> registerFactory(F factory) {
        return ApugliRegisters.POWERS.register(factory.getSerializerId().method_12832(), () -> factory);
    }

    @Override
    public <F extends SpecialPowerFactory<?>> RegistryObject<F> registerFactory(String name, Class<F> factoryClass) {
        SpecialPowerFactory factory = (SpecialPowerFactory)Services.load(factoryClass);
        return ApugliRegisters.POWERS.register(name, () -> (PowerFactory)factory);
    }

    @Override
    public <P> P getPowerFromType(class_1309 entity, PowerType<?> powerType) {
        return (P)powerType.get((class_1297)entity);
    }

    @Override
    public <P extends Power> List<P> getPowers(class_1309 entity, SimplePowerFactory<P> factory) {
        return PowerHolderComponent.getPowers((class_1297)entity, factory.getPowerClass());
    }

    @Override
    public <P extends Power> List<P> getPowers(class_1309 entity, SimplePowerFactory<P> factory, boolean includeInactive) {
        if (entity != null && PowerHolderComponent.KEY.isProvidedBy((Object)entity)) {
            return ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)entity)).getPowers(factory.getPowerClass(), includeInactive);
        }
        return List.of();
    }

    @Override
    public <P> List<P> getPowers(class_1309 entity, SpecialPowerFactory<P> factory) {
        LinkedList list = new LinkedList();
        if (entity != null && PowerHolderComponent.KEY.isProvidedBy((Object)entity)) {
            Class<P> cls = factory.getPowerClass();
            return ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)entity)).getPowers(cls);
        }
        return list;
    }

    @Override
    public <P> List<P> getPowers(class_1309 entity, SpecialPowerFactory<P> factory, boolean includeInactive) {
        LinkedList<Power> list = new LinkedList<Power>();
        if (entity != null && PowerHolderComponent.KEY.isProvidedBy((Object)entity)) {
            Class<P> cls = factory.getPowerClass();
            List powers = ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)entity)).getPowers(cls, includeInactive);
            for (Power power : powers) {
                if (!includeInactive && !power.isActive()) continue;
                list.add(power);
            }
        }
        return list;
    }

    @Override
    public <P extends Power> boolean hasPower(class_1309 entity, SimplePowerFactory<P> factory) {
        return PowerHolderComponent.hasPower((class_1297)entity, factory.getPowerClass());
    }

    @Override
    public <P> boolean hasPower(class_1309 entity, SpecialPowerFactory<P> factory) {
        if (entity != null && PowerHolderComponent.KEY.isProvidedBy((Object)entity)) {
            List powers = ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)entity)).getPowers();
            Class<P> cls = factory.getPowerClass();
            for (Power power : powers) {
                if (!cls.isAssignableFrom(power.getClass()) || !power.isActive()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public SerializableDataType<PowerTypeReference> getPowerTypeDataType() {
        return ApoliDataTypes.POWER_TYPE;
    }

    @Override
    public <P> boolean isActive(P power, class_1309 entity) {
        return ((Power)power).isActive();
    }

    @Override
    public void syncPower(class_1309 entity, PowerType<?> powerType) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            if (serverPlayer.field_13987 == null) {
                return;
            }
        }
        PowerHolderComponent.syncPower((class_1297)entity, powerType);
    }

    @Override
    public <P> void syncPower(class_1309 entity, P power) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            if (serverPlayer.field_13987 == null) {
                return;
            }
        }
        PowerHolderComponent.syncPower((class_1297)entity, (PowerType)((Power)power).getType());
    }

    @Override
    public OptionalInt getResource(class_1309 entity, PowerTypeReference powerType) {
        Power power = powerType.get((class_1297)entity);
        if (power instanceof VariableIntPower) {
            VariableIntPower vip = (VariableIntPower)power;
            return OptionalInt.of(vip.getValue());
        }
        if (power instanceof CooldownPower) {
            CooldownPower cdp = (CooldownPower)power;
            return OptionalInt.of(cdp.getRemainingTicks());
        }
        Apugli.LOG.warn("Failed to get resource for power [{}], because it doesn't hold any resource!", (Object)powerType.getIdentifier());
        return OptionalInt.empty();
    }

    @Override
    public OptionalInt setResource(class_1309 entity, PowerTypeReference powerType, int value) {
        Power power = powerType.get((class_1297)entity);
        if (power instanceof VariableIntPower) {
            VariableIntPower vip = (VariableIntPower)power;
            int result = vip.setValue(value);
            PowerHolderComponent.syncPower((class_1297)entity, (PowerType)powerType);
            return OptionalInt.of(result);
        }
        if (power instanceof CooldownPower) {
            CooldownPower cdp = (CooldownPower)power;
            cdp.setCooldown(value);
            PowerHolderComponent.syncPower((class_1297)entity, (PowerType)powerType);
            return OptionalInt.of(cdp.getRemainingTicks());
        }
        Apugli.LOG.warn("Failed to set resource for power [{}], because it doesn't hold any resource!", (Object)powerType.getIdentifier());
        return OptionalInt.empty();
    }

    @Override
    public <P> class_2960 getPowerFromParameter(P power) {
        return ((PowerTypeReference)power).getIdentifier();
    }

    @Override
    public <P> class_2960 getPowerId(P power) {
        return ((Power)power).getType().getIdentifier();
    }

    @Override
    public <P> P getPowerFromId(class_1297 entity, class_2960 powerId) {
        return (P)new PowerTypeReference(powerId).get(entity);
    }

    @Override
    public void grantPower(class_2960 powerId, class_2960 source, class_1309 entity) {
        if (!PowerHolderComponent.KEY.isProvidedBy((Object)entity) || !PowerTypeRegistry.contains((class_2960)powerId)) {
            return;
        }
        PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)entity);
        component.addPower(PowerTypeRegistry.get((class_2960)powerId), source);
        component.sync();
    }

    @Override
    public void revokePower(class_2960 powerId, class_2960 source, class_1309 entity) {
        PowerType powerType;
        if (!PowerHolderComponent.KEY.isProvidedBy((Object)entity) || !PowerTypeRegistry.contains((class_2960)powerId)) {
            return;
        }
        PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)entity);
        if (component.hasPower(powerType = PowerTypeRegistry.get((class_2960)powerId), source)) {
            component.removePower(powerType, source);
            component.sync();
        }
    }

    @Override
    public boolean hasPowerType(class_2960 powerId, class_2960 source, class_1309 entity) {
        if (!PowerTypeRegistry.contains((class_2960)powerId)) {
            return false;
        }
        return ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)entity)).hasPower(PowerTypeRegistry.get((class_2960)powerId), source);
    }

    @Override
    public Map<class_2960, Double> iterateThroughModifierForResources(class_1309 entity, List<?> modifiers) {
        HashMap<class_2960, Double> returnMap = new HashMap<class_2960, Double>();
        List<?> originalMods = modifiers;
        for (Modifier modifier : originalMods) {
            OptionalDouble doubleValue;
            if (modifier.getData().isPresent("resource") && (doubleValue = this.getResource(entity, (PowerTypeReference)modifier.getData().get("resource")).stream().mapToDouble(i -> i).min()).isPresent()) {
                returnMap.put(((PowerTypeReference)modifier.getData().get("resource")).getIdentifier(), doubleValue.getAsDouble());
            }
            if (!modifier.getData().isPresent("modifier")) continue;
            returnMap.putAll(this.iterateThroughModifierForResources(entity, (List)modifier.getData().get("modifier")));
        }
        return returnMap;
    }

    @Override
    public Map<Integer, Map<class_2960, Double>> getInBetweenResources(class_1309 entity, List<?> modifiers, List<?> delayModifiers, double base, Map<class_2960, Double> startingResources) {
        HashMap<Integer, Map<class_2960, Double>> returnMap = new HashMap<Integer, Map<class_2960, Double>>();
        List<Modifier> originalMods = modifiers;
        int previousResourceValue = 0;
        HashMap<class_2960, Double> resources = new HashMap<class_2960, Double>(startingResources);
        HashMap<class_2960, Double> targetResources = new HashMap<class_2960, Double>();
        for (Map.Entry entry2 : resources.entrySet()) {
            OptionalInt resourceValue = this.getResource(entity, new PowerTypeReference((class_2960)entry2.getKey()));
            if (!resourceValue.isPresent()) continue;
            targetResources.put((class_2960)entry2.getKey(), Double.valueOf(resourceValue.getAsInt()));
        }
        if (originalMods.stream().noneMatch(modifier -> modifier.getData().isPresent("resource") && startingResources.containsKey(((PowerTypeReference)modifier.getData().get("resource")).getIdentifier()))) {
            return returnMap;
        }
        while (resources.entrySet().stream().anyMatch(entry -> !Objects.equals(targetResources.get(entry.getKey()), entry.getValue()))) {
            for (Modifier modifier2 : originalMods) {
                if (modifier2.getData().isPresent("resource") && startingResources.containsKey(((PowerTypeReference)modifier2.getData().get("resource")).getIdentifier())) {
                    int key = returnMap.keySet().isEmpty() ? 0 : (Integer)returnMap.keySet().stream().max(Integer::compareTo).orElseThrow() + previousResourceValue;
                    returnMap.computeIfAbsent(key, k -> new HashMap());
                    OptionalDouble doubleValue = this.getResource(entity, (PowerTypeReference)modifier2.getData().get("resource")).stream().mapToDouble(i -> i).min();
                    if (doubleValue.isPresent()) {
                        ((Map)returnMap.get(key)).put(((PowerTypeReference)modifier2.getData().get("resource")).getIdentifier(), doubleValue.getAsDouble());
                        previousResourceValue = (int)Services.PLATFORM.applyModifiers((class_1297)entity, delayModifiers, base);
                    }
                }
                if (!modifier2.getData().isPresent("modifier")) continue;
                Map<Integer, Map<class_2960, Double>> innerMap = this.getInBetweenResources(entity, (List)modifier2.getData().get("modifier"), delayModifiers, base, startingResources);
                innerMap.forEach((integer, resourceLocationDoubleMap) -> returnMap.merge((Integer)integer, (Map<class_2960, Double>)resourceLocationDoubleMap, (map, map2) -> {
                    map.putAll(map2);
                    return map;
                }));
            }
            FabricPowerHelper.incrementMods(originalMods, resources, targetResources);
        }
        return returnMap;
    }

    @Override
    public double addAllInBetweensOfResourceModifiers(class_1309 entity, List<?> modifiers, List<?> delayModifiers, double base, Map<class_2960, Double> startingResources) {
        if (startingResources.isEmpty()) {
            return base;
        }
        List<Modifier> originalMods = modifiers;
        double currentValue = base;
        HashMap<class_2960, Double> resources = new HashMap<class_2960, Double>(startingResources);
        HashMap<class_2960, Double> targetResources = new HashMap<class_2960, Double>();
        for (Map.Entry entry2 : resources.entrySet()) {
            OptionalInt resourceValue = this.getResource(entity, new PowerTypeReference((class_2960)entry2.getKey()));
            if (!resourceValue.isPresent()) continue;
            targetResources.put((class_2960)entry2.getKey(), Double.valueOf(resourceValue.getAsInt()));
        }
        while (resources.entrySet().stream().anyMatch(entry -> !Objects.equals(((Double)targetResources.get(entry.getKey())).intValue(), ((Double)entry.getValue()).intValue()))) {
            currentValue += this.applyModifierWithSpecificValueAtIndex(entity, delayModifiers, base, resources);
            FabricPowerHelper.incrementMods(originalMods, resources, targetResources);
        }
        return currentValue;
    }

    private static void incrementMods(List<Modifier> modifiers, Map<class_2960, Double> resources, Map<class_2960, Double> targetResources) {
        for (Modifier modifier : modifiers) {
            if (modifier.getData().isPresent("modifier")) {
                FabricPowerHelper.incrementMods((List)modifier.getData().get("modifier"), resources, targetResources);
            }
            if (!modifier.getData().isPresent("resource") || !resources.containsKey(((PowerTypeReference)modifier.getData().get("resource")).getIdentifier())) continue;
            class_2960 resourceId = ((PowerTypeReference)modifier.getData().get("resource")).getIdentifier();
            if (Objects.equals(targetResources.get(resourceId).intValue(), resources.get(resourceId).intValue())) {
                return;
            }
            int increment = targetResources.get(resourceId) < resources.get(resourceId) ? -1 : 1;
            resources.put(resourceId, resources.get(resourceId) + (double)increment);
        }
    }

    @Override
    public double applyModifierWithSpecificValueAtIndex(class_1309 entity, List<?> modifiers, double base, Map<class_2960, Double> resourceMap) {
        List<Modifier> modifierList = modifiers;
        if (this.iterateThroughModifierForResources(entity, modifiers).keySet().stream().noneMatch(resourceMap::containsKey)) {
            return Services.PLATFORM.applyModifiers((class_1297)entity, modifiers, base);
        }
        return ModifierUtil.applyModifiers((class_1297)entity, this.remapModifiers(modifierList, resourceMap), (double)base);
    }

    private Map<IModifierOperation, List<SerializableData.Instance>> remapModifiers(List<Modifier> modifiers, Map<class_2960, Double> resourceMap) {
        HashMap<IModifierOperation, List<SerializableData.Instance>> map = new HashMap<IModifierOperation, List<SerializableData.Instance>>();
        for (Modifier modifier : modifiers) {
            List list = map.computeIfAbsent(modifier.getOperation(), op -> new LinkedList());
            SerializableData.Instance instance = modifier.getData();
            if (instance.isPresent("resource") && resourceMap.containsKey(((PowerTypeReference)instance.get("resource")).getIdentifier())) {
                SerializableData.Instance inst = new SerializableData.Instance(modifier.getOperation().getData());
                inst.set("value", (Object)resourceMap.get(((PowerTypeReference)instance.get("resource")).getIdentifier()));
                inst.set("resource", null);
                if (modifier.getData().isPresent("modifier")) {
                    inst.set("modifier", this.remapModifiersInner((List)modifier.getData().get("modifier"), resourceMap));
                } else {
                    inst.set("modifier", null);
                }
                instance = inst;
            }
            list.add(instance);
        }
        return map;
    }

    private List<Modifier> remapModifiersInner(List<Modifier> modifiers, Map<class_2960, Double> resourceMap) {
        ArrayList<Modifier> list = new ArrayList<Modifier>();
        for (Modifier modifier : modifiers) {
            if (modifier.getData().isPresent("resource") && resourceMap.containsKey(((PowerTypeReference)modifier.getData().get("resource")).getIdentifier())) {
                SerializableData.Instance inst = new SerializableData.Instance(modifier.getOperation().getData());
                inst.set("value", (Object)resourceMap.get(((PowerTypeReference)modifier.getData().get("resource")).getIdentifier()));
                inst.set("resource", null);
                if (modifier.getData().isPresent("modifier")) {
                    inst.set("modifier", this.remapModifiersInner((List)modifier.getData().get("modifier"), resourceMap));
                } else {
                    inst.set("modifier", null);
                }
                modifier = new Modifier(modifier.getOperation(), inst);
            }
            list.add(modifier);
        }
        return list;
    }

    @Override
    public Map<class_2960, Double> getClosestToBaseScale(class_1309 entity, List<?> modifiers, double base) {
        HashMap<class_2960, Double> returnMap = new HashMap<class_2960, Double>();
        List<?> originalMods = modifiers;
        for (Modifier modifier : originalMods) {
            if (!modifier.getData().isPresent("resource") || entity == null || !((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)entity)).hasPower(((PowerTypeReference)modifier.getData().get("resource")).getReferencedPowerType())) continue;
            Power power = ((PowerTypeReference)modifier.getData().get("resource")).get((class_1297)entity);
            if (power instanceof VariableIntPower) {
                VariableIntPower vip = (VariableIntPower)power;
                returnMap.putAll(this.handleAdditionToReturnMap(entity, modifier, base, vip.getMin(), vip.getMax()));
                continue;
            }
            power = ((PowerTypeReference)modifier.getData().get("resource")).get((class_1297)entity);
            if (!(power instanceof CooldownPower)) continue;
            CooldownPower clp = (CooldownPower)power;
            returnMap.putAll(this.handleAdditionToReturnMap(entity, modifier, base, 0, clp.cooldownDuration));
        }
        return returnMap;
    }

    private Map<class_2960, Double> handleAdditionToReturnMap(class_1309 entity, Modifier modifier, double base, int min, int max) {
        HashMap<class_2960, Double> currentResourceMap = new HashMap<class_2960, Double>();
        if (modifier.getData().isPresent("resource")) {
            for (int i = min; i < max; ++i) {
                for (Modifier modifier1 : (List)modifier.getData().get("modifier")) {
                    currentResourceMap.putAll(this.handleAdditionToReturnMap(entity, modifier1, base, min, max));
                }
                double distance = Math.abs(this.applyModifierWithSpecificValueAtIndex(entity, List.of(modifier), base, currentResourceMap) - base);
                class_2960 thisIndex = ((PowerTypeReference)modifier.getData().get("resource")).getReferencedPowerType().getIdentifier();
                if (currentResourceMap.containsKey(thisIndex) && !(distance < Math.abs((Double)currentResourceMap.get(thisIndex) - base))) continue;
                currentResourceMap.put(thisIndex, Double.valueOf(i));
            }
        }
        return currentResourceMap;
    }
}

