/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.platform.services;

import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.apoli.util.ResourceOperation;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.merchantpug.apugli.network.c2s.ApugliPacketC2S;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.ValueModifyingPowerFactory;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_4050;
import net.minecraft.class_8109;
import org.jetbrains.annotations.Nullable;

public interface IPlatformHelper {
    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    public double getReachDistance(class_1297 var1);

    public double getAttackRange(class_1297 var1);

    public <K> SerializableDataType<K> getKeyDataType();

    public <M> SerializableDataType<M> getModifierDataType();

    public <M> SerializableDataType<List<M>> getModifiersDataType();

    public double applyModifiers(class_1297 var1, List<?> var2, double var3);

    default public <P> double applyModifiers(class_1309 entity, ValueModifyingPowerFactory<P> power, double value, Predicate<P> predicate) {
        List modifierList = Services.POWER.getPowers(entity, power).stream().filter(p -> predicate == null || predicate.test(p)).map(p -> power.getModifiers(p, (class_1297)entity)).flatMap(Collection::stream).toList();
        return this.applyModifiers((class_1297)entity, modifierList, value);
    }

    default public <P> double applyModifiers(class_1309 entity, ValueModifyingPowerFactory<P> power, double value) {
        return this.applyModifiers(entity, power, value, null);
    }

    public void sendS2C(ApugliPacketS2C var1, class_3222 var2);

    public void sendS2CTrackingAndSelf(ApugliPacketS2C var1, class_1297 var2);

    public void sendC2S(ApugliPacketC2S var1);

    public int compareModifiers(Object var1, Object var2);

    public float[] getColorPowerRgba(class_1309 var1);

    public void updateKeys(SerializableData.Instance var1, class_1657 var2);

    public boolean isCurrentlyUsingKey(SerializableData.Instance var1, class_1657 var2);

    public class_3545<Integer, Integer> getHitsOnTarget(class_1297 var1, class_1309 var2);

    public void setHitsOnTarget(class_1297 var1, class_1297 var2, int var3, int var4, ResourceOperation var5, ResourceOperation var6);

    public HudRender getDefaultHudRender();

    public float getEntityEyeHeight(class_1297 var1);

    public SerializableDataType<?> damageSourceDescriptionDataType();

    public class_1282 createDamageSource(class_8109 var1, SerializableData.Instance var2, String var3, String var4);

    public class_1282 createDamageSource(class_8109 var1, SerializableData.Instance var2, class_1297 var3, String var4, String var5);

    public class_1282 createDamageSource(class_8109 var1, SerializableData.Instance var2, class_1297 var3, class_1297 var4, String var5, String var6);

    default public boolean canSetPose(class_1657 player) {
        return true;
    }

    default public void setForcedPlayerPose(class_1657 player, @Nullable class_4050 pose) {
    }
}

