/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.platform.services;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.merchantpug.apugli.power.factory.SpecialPowerFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;

public interface IPowerHelper<T> {
    public Object unwrapSimpleFactory(PowerFactory<?> var1);

    public <F extends SimplePowerFactory<?>> Supplier<F> registerFactory(F var1);

    public <F extends SpecialPowerFactory<?>> Supplier<F> registerFactory(String var1, Class<F> var2);

    public <P> P getPowerFromType(class_1309 var1, PowerType<?> var2);

    public <P extends Power> List<P> getPowers(class_1309 var1, SimplePowerFactory<P> var2);

    public <P extends Power> List<P> getPowers(class_1309 var1, SimplePowerFactory<P> var2, boolean var3);

    public <P> List<P> getPowers(class_1309 var1, SpecialPowerFactory<P> var2);

    public <P> List<P> getPowers(class_1309 var1, SpecialPowerFactory<P> var2, boolean var3);

    public <P extends Power> boolean hasPower(class_1309 var1, SimplePowerFactory<P> var2);

    public <P> boolean hasPower(class_1309 var1, SpecialPowerFactory<P> var2);

    public SerializableDataType<T> getPowerTypeDataType();

    public <P> boolean isActive(P var1, class_1309 var2);

    public void syncPower(class_1309 var1, PowerType<?> var2);

    public <P> void syncPower(class_1309 var1, P var2);

    public OptionalInt getResource(class_1309 var1, T var2);

    default public OptionalInt getResource(class_1309 entity, SerializableData.Instance data, String fieldName) {
        return this.getResource(entity, data.get(fieldName));
    }

    public OptionalInt setResource(class_1309 var1, T var2, int var3);

    default public OptionalInt setResource(class_1309 entity, SerializableData.Instance data, String fieldName, int value) {
        return this.setResource(entity, data.get(fieldName), value);
    }

    public <P> class_2960 getPowerFromParameter(P var1);

    public <P> class_2960 getPowerId(P var1);

    public <P> P getPowerFromId(class_1297 var1, class_2960 var2);

    default public <P extends Power> P getPowerFromId(class_2960 powerId, SimplePowerFactory<P> factory, class_1309 living, boolean includeInactive) {
        Optional<Power> optional = this.getPowers(living, factory, includeInactive).stream().filter(p -> this.getPowerId(p).equals((Object)powerId)).findFirst();
        return (P)((Power)optional.orElse(null));
    }

    @Nullable
    default public <P> P getPowerFromId(class_2960 powerId, SpecialPowerFactory<P> factory, class_1309 living, boolean includeInactive) {
        Optional<Object> optional = this.getPowers(living, factory, includeInactive).stream().filter(p -> this.getPowerId(p).equals((Object)powerId)).findFirst();
        return optional.orElse(null);
    }

    public void grantPower(class_2960 var1, class_2960 var2, class_1309 var3);

    public void revokePower(class_2960 var1, class_2960 var2, class_1309 var3);

    public boolean hasPowerType(class_2960 var1, class_2960 var2, class_1309 var3);

    public Map<class_2960, Double> iterateThroughModifierForResources(class_1309 var1, List<?> var2);

    public Map<Integer, Map<class_2960, Double>> getInBetweenResources(class_1309 var1, List<?> var2, List<?> var3, double var4, Map<class_2960, Double> var6);

    public double addAllInBetweensOfResourceModifiers(class_1309 var1, List<?> var2, List<?> var3, double var4, Map<class_2960, Double> var6);

    public double applyModifierWithSpecificValueAtIndex(class_1309 var1, List<?> var2, double var3, Map<class_2960, Double> var5);

    public Map<class_2960, Double> getClosestToBaseScale(class_1309 var1, List<?> var2, double var3);
}

