/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2694;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class ActionOnBonemealPower
extends Power {
    @Nullable
    private final Consumer<Triple<class_1937, class_2338, class_2350>> blockAction;
    @Nullable
    private final Consumer<class_1297> entityAction;
    @Nullable
    private final Predicate<class_2694> blockCondition;

    public ActionOnBonemealPower(PowerType<?> type, class_1309 entity, @Nullable Consumer<Triple<class_1937, class_2338, class_2350>> blockAction, @Nullable Consumer<class_1297> entityAction, @Nullable Predicate<class_2694> blockCondition) {
        super(type, entity);
        this.blockAction = blockAction;
        this.entityAction = entityAction;
        this.blockCondition = blockCondition;
    }

    public boolean doesApply(class_2694 cachedBlockPosition) {
        return this.blockCondition == null || this.blockCondition.test(cachedBlockPosition);
    }

    public void executeActions(class_1937 world, class_2338 blockPos, class_2350 direction) {
        if (this.blockAction != null) {
            this.blockAction.accept((Triple<class_1937, class_2338, class_2350>)Triple.of((Object)world, (Object)blockPos, (Object)direction));
        }
        if (this.entityAction != null) {
            this.entityAction.accept((class_1297)this.entity);
        }
    }

    public static class Factory
    extends SimplePowerFactory<ActionOnBonemealPower> {
        public Factory() {
            super("action_on_bonemeal", new SerializableData().add("block_action", Services.ACTION.blockDataType(), null).add("self_action", Services.ACTION.entityDataType(), null).add("block_condition", Services.CONDITION.biomeDataType(), null), data -> (type, entity) -> new ActionOnBonemealPower((PowerType<?>)type, (class_1309)entity, Services.ACTION.blockConsumer((SerializableData.Instance)data, "block_action"), Services.ACTION.entityConsumer((SerializableData.Instance)data, "self_action"), Services.CONDITION.blockPredicate((SerializableData.Instance)data, "block_condition")));
            this.allowCondition();
        }

        @Override
        public Class<ActionOnBonemealPower> getPowerClass() {
            return ActionOnBonemealPower.class;
        }
    }
}

