/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import com.mojang.datafixers.util.Either;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3545;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionOnDurabilityChangePower
extends Power {
    @Nullable
    private final class_1304 slot;
    @Nullable
    private final Predicate<class_3545<class_1937, class_1799>> itemCondition;
    @Nullable
    private final Consumer<class_1297> increaseAction;
    @Nullable
    private final Consumer<class_3545<class_1937, Mutable<class_1799>>> itemIncreaseAction;
    @Nullable
    private final Consumer<class_1297> decreaseAction;
    @Nullable
    private final Consumer<class_3545<class_1937, Mutable<class_1799>>> itemDecreaseAction;
    @Nullable
    private final Consumer<class_1297> breakAction;
    @Nullable
    private final Consumer<class_3545<class_1937, Mutable<class_1799>>> itemBreakAction;
    Set<Either<class_1304, Integer>> operatedStacks = new HashSet<Either<class_1304, Integer>>();

    public ActionOnDurabilityChangePower(PowerType<?> type, class_1309 entity, @Nullable class_1304 slot, @Nullable Predicate<class_3545<class_1937, class_1799>> itemCondition, @Nullable Consumer<class_1297> increaseAction, @Nullable Consumer<class_3545<class_1937, Mutable<class_1799>>> itemIncreaseAction, @Nullable Consumer<class_1297> decreaseAction, @Nullable Consumer<class_3545<class_1937, Mutable<class_1799>>> itemDecreaseAction, @Nullable Consumer<class_1297> breakAction, @Nullable Consumer<class_3545<class_1937, Mutable<class_1799>>> itemBreakAction) {
        super(type, entity);
        this.slot = slot;
        this.itemCondition = itemCondition;
        this.increaseAction = increaseAction;
        this.itemIncreaseAction = itemIncreaseAction;
        this.decreaseAction = decreaseAction;
        this.itemDecreaseAction = itemDecreaseAction;
        this.breakAction = breakAction;
        this.itemBreakAction = itemBreakAction;
        this.setTicking();
    }

    public void tick() {
        this.operatedStacks.clear();
    }

    public void onRemoved() {
        this.operatedStacks.clear();
    }

    public boolean doesApply(class_1799 stack) {
        return !(this.slot != null && !class_1799.method_7973((class_1799)this.entity.method_6118(this.slot), (class_1799)stack) || this.itemCondition != null && !this.itemCondition.test((class_3545<class_1937, class_1799>)new class_3545((Object)this.entity.method_37908(), (Object)stack)));
    }

    private void executeAction(class_1799 stack, Consumer<class_1297> entityAction, Consumer<class_3545<class_1937, Mutable<class_1799>>> itemAction) {
        class_1304 slot2;
        Optional<Object> equipmentSlot = Optional.empty();
        for (class_1304 slot2 : class_1304.values()) {
            if (!class_1799.method_7973((class_1799)stack, (class_1799)this.entity.method_6118(slot2))) continue;
            equipmentSlot = Optional.of(slot2);
            break;
        }
        Optional finalEquipmentSlot = equipmentSlot;
        Optional<Object> playerInventoryIndex = Optional.empty();
        if (equipmentSlot.isEmpty() && (slot2 = this.entity) instanceof class_1657) {
            class_1657 player = (class_1657)slot2;
            for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                if (!class_1799.method_7973((class_1799)stack, (class_1799)((class_1799)player.method_31548().field_7547.get(i)))) continue;
                playerInventoryIndex = Optional.of(i);
                break;
            }
        }
        Optional<Integer> finalPlayerInventoryIndex = playerInventoryIndex;
        if (equipmentSlot.isEmpty() && playerInventoryIndex.isEmpty() || finalEquipmentSlot.isPresent() && this.operatedStacks.stream().anyMatch(either -> either.left().isPresent() && ((class_1304)either.left().get()).equals(finalEquipmentSlot.get())) || this.entity instanceof class_1657 && finalPlayerInventoryIndex.isPresent() && this.operatedStacks.stream().anyMatch(either -> either.right().isPresent() && ((Integer)either.right().get()).intValue() == ((Integer)finalPlayerInventoryIndex.get()).intValue())) {
            return;
        }
        equipmentSlot.ifPresent(slot1 -> this.operatedStacks.add((Either<class_1304, Integer>)Either.left((Object)slot1)));
        playerInventoryIndex.ifPresent(index -> this.operatedStacks.add((Either<class_1304, Integer>)Either.right((Object)index)));
        if (entityAction != null) {
            entityAction.accept((class_1297)this.entity);
        }
        if (itemAction != null) {
            MutableObject mutable = new MutableObject((Object)stack.method_7972());
            itemAction.accept((class_3545<class_1937, Mutable<class_1799>>)new class_3545((Object)this.entity.method_37908(), (Object)mutable));
            if (equipmentSlot.isPresent()) {
                this.entity.method_5673((class_1304)equipmentSlot.get(), (class_1799)mutable.getValue());
            } else {
                class_1309 class_13092 = this.entity;
                if (class_13092 instanceof class_1657) {
                    class_1657 player = (class_1657)class_13092;
                    player.method_31548().field_7547.set(((Integer)playerInventoryIndex.get()).intValue(), (Object)((class_1799)mutable.getValue()));
                }
            }
        }
    }

    public void executeIncreaseAction(class_1799 stack) {
        this.executeAction(stack, this.increaseAction, this.itemIncreaseAction);
    }

    public void executeDecreaseAction(class_1799 stack) {
        this.executeAction(stack, this.decreaseAction, this.itemDecreaseAction);
    }

    public void executeBreakAction(class_1799 stack) {
        this.executeAction(stack, this.breakAction, this.itemBreakAction);
    }

    public static class Factory
    extends SimplePowerFactory<ActionOnDurabilityChangePower> {
        public Factory() {
            super("action_on_durability_change", new SerializableData().add("slot", SerializableDataTypes.EQUIPMENT_SLOT, null).add("item_condition", Services.CONDITION.itemDataType(), null).add("increase_action", Services.ACTION.entityDataType(), null).add("increase_item_action", Services.ACTION.itemDataType(), null).add("decrease_action", Services.ACTION.entityDataType(), null).add("decrease_item_action", Services.ACTION.itemDataType(), null).add("break_action", Services.ACTION.entityDataType(), null).add("break_item_action", Services.ACTION.itemDataType(), null), data -> (type, entity) -> new ActionOnDurabilityChangePower((PowerType<?>)type, (class_1309)entity, (class_1304)data.get("slot"), Services.CONDITION.itemPredicate((SerializableData.Instance)data, "item_condition"), Services.ACTION.entityConsumer((SerializableData.Instance)data, "increase_action"), Services.ACTION.itemConsumer((SerializableData.Instance)data, "increase_item_action"), Services.ACTION.entityConsumer((SerializableData.Instance)data, "decrease_action"), Services.ACTION.itemConsumer((SerializableData.Instance)data, "decrease_item_action"), Services.ACTION.entityConsumer((SerializableData.Instance)data, "break_action"), Services.ACTION.itemConsumer((SerializableData.Instance)data, "break_item_action")));
            this.allowCondition();
        }

        @Override
        @NotNull
        public Class<ActionOnDurabilityChangePower> getPowerClass() {
            return ActionOnDurabilityChangePower.class;
        }
    }
}

