/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;

public class AllowAnvilEnchantPower
extends Power {
    @Nullable
    private final Predicate<class_3545<class_1937, class_1799>> itemCondition;
    private final List<class_1887> enchantments = new ArrayList<class_1887>();
    public Comparison comparison;
    public int compareTo;

    public AllowAnvilEnchantPower(PowerType<?> type, class_1309 entity, @Nullable Predicate<class_3545<class_1937, class_1799>> itemCondition, Comparison comparison, int compareTo) {
        super(type, entity);
        this.itemCondition = itemCondition;
        this.compareTo = compareTo;
        this.comparison = comparison;
    }

    public boolean doesApply(class_1887 enchantment, class_1799 stackA, class_1799 stackB) {
        if (!this.enchantments.contains(enchantment)) {
            return false;
        }
        if (this.itemCondition != null && !this.itemCondition.test((class_3545<class_1937, class_1799>)new class_3545((Object)this.entity.method_37908(), (Object)stackA))) {
            return false;
        }
        Map map = class_1890.method_8222((class_1799)stackB);
        if (!map.containsKey(enchantment)) {
            return false;
        }
        return this.comparison.compare((double)((Integer)map.get(enchantment)).intValue(), (double)this.compareTo);
    }

    public static class Factory
    extends SimplePowerFactory<AllowAnvilEnchantPower> {
        public Factory() {
            super("allow_anvil_enchant", new SerializableData().add("enchantment", SerializableDataTypes.ENCHANTMENT, null).add("enchantments", SerializableDataType.list((SerializableDataType)SerializableDataTypes.ENCHANTMENT), null).add("compare_to", SerializableDataTypes.INT, (Object)0).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL).add("item_condition", Services.CONDITION.itemDataType()), data -> (type, player) -> {
                AllowAnvilEnchantPower power = new AllowAnvilEnchantPower((PowerType<?>)type, (class_1309)player, Services.CONDITION.itemPredicate((SerializableData.Instance)data, "item_condition"), (Comparison)data.get("comparison"), data.getInt("compare_to"));
                if (data.isPresent("enchantment")) {
                    power.enchantments.add((class_1887)data.get("enchantment"));
                }
                if (data.isPresent("enchantments")) {
                    power.enchantments.addAll((Collection)data.get("enchantments"));
                }
                return power;
            });
            this.allowCondition();
        }

        @Override
        public Class<AllowAnvilEnchantPower> getPowerClass() {
            return AllowAnvilEnchantPower.class;
        }
    }
}

