/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import com.google.auto.service.AutoService;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import net.merchantpug.apugli.mixin.fabric.common.accessor.CooldownPowerAccessor;
import net.merchantpug.apugli.power.AbstractActiveCooldownPower;
import net.merchantpug.apugli.power.factory.CustomProjectilePowerFactory;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

@AutoService(value={CustomProjectilePowerFactory.class})
public class CustomProjectilePower
extends AbstractActiveCooldownPower<Instance>
implements CustomProjectilePowerFactory<Instance> {
    public CustomProjectilePower() {
        super("custom_projectile", CustomProjectilePowerFactory.getSerializableData(), data -> (type, entity) -> new Instance((PowerType<?>)type, (class_1309)entity, (SerializableData.Instance)data));
        this.allowCondition();
    }

    @Override
    public SerializableData.Instance getDataFromPower(Instance power) {
        return power.data;
    }

    @Override
    public Class<Instance> getPowerClass() {
        return Instance.class;
    }

    @Override
    public class_2960 getPowerId(Instance power) {
        return power.getType().getIdentifier();
    }

    @Override
    public long getLastUseTime(Instance power, class_1297 entity) {
        return ((CooldownPowerAccessor)((Object)power)).apugli$getLastUseTime();
    }

    @Override
    public int getShotProjectiles(Instance power, class_1297 entity) {
        return power.shotProjectiles;
    }

    @Override
    public boolean isFiringProjectiles(Instance power, class_1297 entity) {
        return power.isFiringProjectiles;
    }

    @Override
    public boolean finishedStartDelay(Instance power, class_1297 entity) {
        return power.finishedStartDelay;
    }

    @Override
    public void setShotProjectiles(Instance power, class_1297 entity, int value) {
        power.shotProjectiles = value;
    }

    @Override
    public void setFiringProjectiles(Instance power, class_1297 entity, boolean value) {
        power.isFiringProjectiles = value;
    }

    @Override
    public void setFinishedStartDelay(Instance power, class_1297 entity, boolean value) {
        power.finishedStartDelay = value;
    }

    public static class Instance
    extends AbstractActiveCooldownPower.Instance {
        private int shotProjectiles;
        private boolean finishedStartDelay;
        private boolean isFiringProjectiles;

        public Instance(PowerType<?> type, class_1309 entity, SerializableData.Instance data) {
            super(type, entity, data);
            this.setTicking();
        }

        public void tick() {
            ApugliPowers.CUSTOM_PROJECTILE.get().tick(this, this.entity);
        }

        @Override
        public void onUse() {
            if (this.canUse()) {
                this.isFiringProjectiles = true;
                this.use();
            }
        }

        public class_2520 toTag() {
            class_2487 nbt = new class_2487();
            nbt.method_10544("LastUseTime", this.lastUseTime);
            nbt.method_10569("ShotProjectiles", this.shotProjectiles);
            nbt.method_10556("FinishedStartDelay", this.finishedStartDelay);
            nbt.method_10556("IsFiringProjectiles", this.isFiringProjectiles);
            return nbt;
        }

        public void fromTag(class_2520 tag) {
            if (tag instanceof class_2487) {
                class_2487 compound = (class_2487)tag;
                this.lastUseTime = compound.method_10537("LastUseTime");
                this.shotProjectiles = compound.method_10550("ShotProjectiles");
                this.finishedStartDelay = compound.method_10577("FinishedStartDelay");
                this.isFiringProjectiles = compound.method_10577("IsFiringProjectiles");
            }
        }
    }
}

