/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.merchantpug.apugli.data.ApugliDataTypes;
import net.merchantpug.apugli.util.SoundEventPitchVolume;
import net.merchantpug.apugli.util.SoundEventWeight;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3414;

public abstract class CustomSoundPower
extends Power {
    private final List<SoundEventWeight> sounds = new ArrayList<SoundEventWeight>();
    private final boolean muted;
    private final float pitch;
    private final float volume;

    public CustomSoundPower(PowerType<?> type, class_1309 living, boolean muted, float volume, float pitch) {
        super(type, living);
        this.muted = muted;
        this.pitch = pitch;
        this.volume = volume;
    }

    public CustomSoundPower(PowerType<?> type, class_1309 living, SerializableData.Instance data) {
        this(type, living, data.getBoolean("muted"), data.getFloat("volume"), data.getFloat("pitch"));
        if (data.isPresent("sound")) {
            this.sounds.add((SoundEventWeight)data.get("sound"));
        }
        if (data.isPresent("sounds")) {
            this.sounds.addAll((Collection)data.get("sounds"));
        }
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void playSound(class_1297 entity) {
        if (this.muted) {
            return;
        }
        SoundEventWeight chosenSounds = switch (this.sounds.size()) {
            case 0 -> null;
            case 1 -> this.sounds.get(0);
            default -> {
                int index;
                int totalWeight = 0;
                for (SoundEventWeight sew : this.sounds) {
                    totalWeight += sew.weight;
                }
                double r = Math.random() * (double)totalWeight;
                for (index = 0; index < this.sounds.size() - 1 && !((r -= (double)this.sounds.get((int)index).weight) <= 0.0); ++index) {
                }
                yield this.sounds.get(index);
            }
        };
        if (chosenSounds == null) {
            return;
        }
        for (SoundEventPitchVolume sound : chosenSounds.soundEventList) {
            float volume = Float.isNaN(sound.volume) ? this.volume : sound.volume;
            float pitch = Float.isNaN(sound.pitch) ? this.pitch : sound.pitch;
            this.playSound(entity, sound.soundEvent, volume, pitch);
        }
    }

    protected abstract void playSound(class_1297 var1, class_3414 var2, float var3, float var4);

    public static SerializableData getSerializableData() {
        return new SerializableData().add("muted", SerializableDataTypes.BOOLEAN, (Object)false).add("sound", ApugliDataTypes.SOUND_EVENT_OPTIONAL_WEIGHT, null).add("sounds", SerializableDataType.list(ApugliDataTypes.SOUND_EVENT_OPTIONAL_WEIGHT), null).add("volume", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("pitch", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f));
    }
}

