/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3545;
import net.minecraft.class_4174;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class EdibleItemPower
extends Power {
    private final Predicate<class_3545<class_1937, class_1799>> predicate;
    private final class_4174 foodComponent;
    private final EatAnimation useAction;
    private final class_1799 returnStack;
    private final class_3414 sound;
    private final Consumer<class_1297> entityActionWhenEaten;
    private final Consumer<class_3545<class_1937, Mutable<class_1799>>> itemActionWhenEaten;

    public EdibleItemPower(PowerType<?> type, class_1309 entity, Predicate<class_3545<class_1937, class_1799>> predicate, class_4174 foodComponent, EatAnimation useAction, class_1799 returnStack, class_3414 sound, Consumer<class_1297> entityActionWhenEaten, Consumer<class_3545<class_1937, Mutable<class_1799>>> itemActionWhenEaten) {
        super(type, entity);
        this.predicate = predicate;
        this.foodComponent = foodComponent;
        this.useAction = useAction;
        this.returnStack = returnStack;
        this.sound = sound;
        this.entityActionWhenEaten = entityActionWhenEaten;
        this.itemActionWhenEaten = itemActionWhenEaten;
    }

    public boolean doesApply(class_1937 level, class_1799 stack) {
        return this.predicate.test((class_3545<class_1937, class_1799>)new class_3545((Object)level, (Object)stack));
    }

    public class_4174 getFoodComponent() {
        return this.foodComponent;
    }

    public EatAnimation getUseAction() {
        return this.useAction;
    }

    public class_1799 getReturnStack() {
        return this.returnStack;
    }

    public class_3414 getSound() {
        return this.sound;
    }

    public static void executeEntityActions(class_1309 entity, class_1799 stack) {
        Services.POWER.getPowers(entity, ApugliPowers.EDIBLE_ITEM.get()).stream().filter(p -> p.doesApply(entity.method_37908(), stack) && p.entityActionWhenEaten != null).forEach(p -> p.entityActionWhenEaten.accept((class_1297)entity));
    }

    public static class_1799 executeItemActions(class_1309 entity, class_1799 stack, class_1799 originalStack) {
        MutableObject mutable = new MutableObject((Object)stack.method_7972());
        Services.POWER.getPowers(entity, ApugliPowers.EDIBLE_ITEM.get()).stream().filter(p -> p.doesApply(entity.method_37908(), originalStack) && p.itemActionWhenEaten != null).forEach(arg_0 -> EdibleItemPower.lambda$executeItemActions$3(entity, (Mutable)mutable, arg_0));
        return (class_1799)mutable.getValue();
    }

    private static /* synthetic */ void lambda$executeItemActions$3(class_1309 entity, Mutable mutable, EdibleItemPower p) {
        p.itemActionWhenEaten.accept((class_3545<class_1937, Mutable<class_1799>>)new class_3545((Object)entity.method_37908(), (Object)mutable));
    }

    public static enum EatAnimation {
        EAT,
        DRINK;

    }

    public static class Factory
    extends SimplePowerFactory<EdibleItemPower> {
        public Factory() {
            super("edible_item", new SerializableData().add("item_condition", Services.CONDITION.itemDataType()).add("food_component", SerializableDataTypes.FOOD_COMPONENT).add("use_action", SerializableDataType.enumValue(EatAnimation.class), (Object)EatAnimation.EAT).add("return_stack", SerializableDataTypes.ITEM_STACK, null).add("sound", SerializableDataTypes.SOUND_EVENT, null).add("entity_action", Services.ACTION.entityDataType(), null).add("item_action", Services.ACTION.itemDataType(), null), data -> (type, player) -> new EdibleItemPower((PowerType<?>)type, (class_1309)player, Services.CONDITION.itemPredicate((SerializableData.Instance)data, "item_condition"), (class_4174)data.get("food_component"), (EatAnimation)((Object)((Object)((Object)data.get("use_action")))), (class_1799)data.get("return_stack"), (class_3414)data.get("sound"), Services.ACTION.entityConsumer((SerializableData.Instance)data, "entity_action"), Services.ACTION.itemConsumer((SerializableData.Instance)data, "item_action")));
            this.allowCondition();
        }

        @Override
        public Class<EdibleItemPower> getPowerClass() {
            return EdibleItemPower.class;
        }
    }
}

