/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.HashSet;
import java.util.List;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;

public class InstantEffectImmunityPower
extends Power {
    protected final HashSet<class_1291> effects = new HashSet();
    private final boolean inverted;

    public InstantEffectImmunityPower(PowerType<?> type, class_1309 entity, boolean inverted) {
        super(type, entity);
        this.inverted = inverted;
    }

    public InstantEffectImmunityPower addEffect(class_1291 effect) {
        this.effects.add(effect);
        return this;
    }

    public boolean doesApply(class_1293 instance) {
        return this.doesApply(instance.method_5579());
    }

    public boolean doesApply(class_1291 effect) {
        return this.inverted ^ this.effects.contains(effect);
    }

    public static class Factory
    extends SimplePowerFactory<InstantEffectImmunityPower> {
        public Factory() {
            super("instant_effect_immunity", new SerializableData().add("effect", SerializableDataTypes.STATUS_EFFECT, null).add("effects", SerializableDataTypes.STATUS_EFFECTS, null).add("inverted", SerializableDataTypes.BOOLEAN, (Object)false), data -> (type, player) -> {
                InstantEffectImmunityPower power = new InstantEffectImmunityPower((PowerType<?>)type, (class_1309)player, (Boolean)data.get("inverted"));
                if (data.isPresent("effect")) {
                    power.addEffect((class_1291)data.get("effect"));
                }
                if (data.isPresent("effects")) {
                    ((List)data.get("effects")).forEach(power::addEffect);
                }
                return power;
            });
            this.allowCondition();
        }

        @Override
        public Class<InstantEffectImmunityPower> getPowerClass() {
            return InstantEffectImmunityPower.class;
        }
    }
}

