/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import org.apache.commons.lang3.tuple.Triple;

public class ModifyBlockPlacedPower
extends Power {
    private final List<class_2680> blockStates = new ArrayList<class_2680>();
    public final Predicate<class_3545<class_1937, class_1799>> itemCondition;
    private final Consumer<Triple<class_1937, class_2338, class_2350>> blockAction;
    private int seed = (int)(Math.random() * 2.147483647E9);

    public ModifyBlockPlacedPower(PowerType<?> type, class_1309 entity, Predicate<class_3545<class_1937, class_1799>> itemCondition, Consumer<Triple<class_1937, class_2338, class_2350>> blockAction) {
        super(type, entity);
        this.itemCondition = itemCondition;
        this.blockAction = blockAction;
    }

    public void fromTag(class_2520 tag) {
        if (!(tag instanceof class_2487)) {
            return;
        }
        this.seed = ((class_2487)tag).method_10550("Seed");
    }

    public class_2520 toTag() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("Seed", this.seed);
        return nbt;
    }

    public int getSeed() {
        return this.seed;
    }

    public void generateSeed() {
        if (!(this.entity instanceof class_1657)) {
            return;
        }
        if (!this.entity.method_37908().method_8608()) {
            this.seed = (int)(Math.random() * 2.147483647E9);
            Services.POWER.syncPower(this.entity, this.getType());
        }
    }

    public void executeAction(Optional<class_2338> placedBlockPos) {
        if (placedBlockPos.isEmpty() || this.blockAction == null) {
            return;
        }
        this.blockAction.accept((Triple<class_1937, class_2338, class_2350>)Triple.of((Object)this.entity.method_37908(), (Object)placedBlockPos.get(), (Object)class_2350.field_11036));
    }

    public void addBlockState(class_2680 blockState) {
        this.blockStates.add(blockState);
    }

    public List<class_2680> getBlockStates() {
        return this.blockStates;
    }

    public static class Factory
    extends SimplePowerFactory<ModifyBlockPlacedPower> {
        public Factory() {
            super("modify_block_placed", new SerializableData().add("block", SerializableDataTypes.BLOCK, null).add("block_state", SerializableDataTypes.BLOCK_STATE, null).add("blocks", SerializableDataType.list((SerializableDataType)SerializableDataTypes.BLOCK), null).add("block_states", SerializableDataType.list((SerializableDataType)SerializableDataTypes.BLOCK_STATE), null).add("block_action", Services.ACTION.blockDataType(), null).add("item_condition", Services.CONDITION.itemDataType()), data -> (type, entity) -> {
                ModifyBlockPlacedPower power = new ModifyBlockPlacedPower((PowerType<?>)type, (class_1309)entity, Services.CONDITION.itemPredicate((SerializableData.Instance)data, "item_condition"), Services.ACTION.blockConsumer((SerializableData.Instance)data, "block_action"));
                data.ifPresent("block", block -> power.addBlockState(block.method_9564()));
                data.ifPresent("block_state", power::addBlockState);
                data.ifPresent("blocks", blocks -> blocks.forEach(block -> power.addBlockState(block.method_9564())));
                data.ifPresent("block_states", states -> states.forEach(power::addBlockState));
                return power;
            });
            this.allowCondition();
        }

        @Override
        public Class<ModifyBlockPlacedPower> getPowerClass() {
            return ModifyBlockPlacedPower.class;
        }
    }
}

