/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3545;

public class PreventBreedingPower
extends Power {
    private final Predicate<class_3545<class_1297, class_1297>> biEntityCondition;
    private final Consumer<class_3545<class_1297, class_1297>> biEntityAction;
    public final boolean preventFollow;

    public PreventBreedingPower(PowerType<?> type, class_1309 entity, Predicate<class_3545<class_1297, class_1297>> biEntityCondition, Consumer<class_3545<class_1297, class_1297>> biEntityAction, boolean preventFollow) {
        super(type, entity);
        this.biEntityCondition = biEntityCondition;
        this.biEntityAction = biEntityAction;
        this.preventFollow = preventFollow;
    }

    public boolean doesApply(class_1297 mobEntity) {
        return this.biEntityCondition == null || this.biEntityCondition.test((class_3545<class_1297, class_1297>)new class_3545((Object)this.entity, (Object)mobEntity));
    }

    public void executeAction(class_1297 mobEntity) {
        if (this.biEntityAction == null) {
            return;
        }
        this.biEntityAction.accept((class_3545<class_1297, class_1297>)new class_3545((Object)this.entity, (Object)mobEntity));
    }

    public boolean hasAction() {
        return this.biEntityAction != null;
    }

    public static class Factory
    extends SimplePowerFactory<PreventBreedingPower> {
        public Factory() {
            super("prevent_breeding", new SerializableData().add("bientity_condition", Services.CONDITION.biEntityDataType(), null).add("bientity_action", Services.ACTION.biEntityDataType(), null).add("prevent_follow", SerializableDataTypes.BOOLEAN, (Object)true), data -> (type, entity) -> new PreventBreedingPower((PowerType<?>)type, (class_1309)entity, (Predicate)data.get("bientity_condition"), (Consumer)data.get("bientity_action"), data.getBoolean("prevent_follow")));
        }

        @Override
        public Class<PreventBreedingPower> getPowerClass() {
            return PreventBreedingPower.class;
        }
    }
}

