/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.List;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.class_1309;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class PreventSoundPower
extends Power {
    private final List<class_3419> categories = new ArrayList<class_3419>();
    private final List<class_3414> sounds = new ArrayList<class_3414>();
    private final List<class_3414> soundWhitelist = new ArrayList<class_3414>();

    public PreventSoundPower(PowerType<?> type, class_1309 entity) {
        super(type, entity);
    }

    public boolean isSoundNotWhitelisted(class_3414 soundEvent) {
        return !this.soundWhitelist.contains(soundEvent);
    }

    public void addWhitelistedSound(class_3414 soundEvent) {
        this.soundWhitelist.add(soundEvent);
    }

    public boolean doesApplyToSound(class_3414 soundEvent) {
        return this.sounds.contains(soundEvent);
    }

    public void addSound(class_3414 soundEvent) {
        this.sounds.add(soundEvent);
    }

    public boolean doesApplyToCategory(class_3419 category) {
        return this.categories.contains(category);
    }

    public void addCategory(class_3419 category) {
        this.categories.add(category);
    }

    public static class Factory
    extends SimplePowerFactory<PreventSoundPower> {
        public Factory() {
            super("prevent_sound", new SerializableData().add("category", SerializableDataType.enumValue(class_3419.class), null).add("categories", SerializableDataType.list((SerializableDataType)SerializableDataType.enumValue(class_3419.class)), null).add("sound", SerializableDataTypes.SOUND_EVENT, null).add("sounds", SerializableDataType.list((SerializableDataType)SerializableDataTypes.SOUND_EVENT), null).add("whitelist", SerializableDataType.list((SerializableDataType)SerializableDataTypes.SOUND_EVENT), null), data -> (type, entity) -> {
                PreventSoundPower power = new PreventSoundPower((PowerType<?>)type, (class_1309)entity);
                data.ifPresent("category", power::addCategory);
                data.ifPresent("categories", categories -> categories.forEach(power::addCategory));
                data.ifPresent("sound", power::addSound);
                data.ifPresent("sound", soundEvents -> soundEvents.forEach(power::addSound));
                data.ifPresent("whitelist", soundEvents -> soundEvents.forEach(power::addWhitelistedSound));
                return power;
            });
            this.allowCondition();
        }

        @Override
        public Class<PreventSoundPower> getPowerClass() {
            return PreventSoundPower.class;
        }
    }
}

