/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1676;
import net.minecraft.class_3545;

public class ProjectileActionOverTimePower
extends Power {
    private final int interval;
    private final Consumer<class_3545<class_1297, class_1297>> biEntityAction;
    private final Consumer<class_3545<class_1297, class_1297>> risingAction;
    private final Consumer<class_3545<class_1297, class_1297>> fallingAction;
    private final Predicate<class_3545<class_1297, class_1297>> biEntityCondition;
    private boolean wasActive = false;
    private final Map<class_1676, Integer> initialTicks = new HashMap<class_1676, Integer>();

    public ProjectileActionOverTimePower(PowerType<?> type, class_1309 entity, int interval, Consumer<class_3545<class_1297, class_1297>> biEntityAction, Consumer<class_3545<class_1297, class_1297>> risingAction, Consumer<class_3545<class_1297, class_1297>> fallingAction, Predicate<class_3545<class_1297, class_1297>> biEntityCondition) {
        super(type, entity);
        this.interval = interval;
        this.biEntityAction = biEntityAction;
        this.risingAction = risingAction;
        this.fallingAction = fallingAction;
        this.biEntityCondition = biEntityCondition;
    }

    public boolean doesApply(class_1676 projectile) {
        return this.biEntityCondition == null || this.biEntityCondition.test((class_3545<class_1297, class_1297>)new class_3545((Object)this.entity, (Object)projectile));
    }

    public void projectileTick(class_1676 projectile) {
        if (!this.initialTicks.containsKey(projectile)) {
            this.initialTicks.put(projectile, projectile.field_6012 % this.interval);
        }
        if (this.entity.field_6012 % this.interval == this.initialTicks.get(projectile)) {
            if (this.isActive() && this.doesApply(projectile)) {
                if (!this.wasActive && this.risingAction != null) {
                    this.risingAction.accept((class_3545<class_1297, class_1297>)new class_3545((Object)this.entity, (Object)projectile));
                }
                if (this.biEntityAction != null) {
                    this.biEntityAction.accept((class_3545<class_1297, class_1297>)new class_3545((Object)this.entity, (Object)projectile));
                }
                this.wasActive = true;
            } else {
                if (this.wasActive && this.fallingAction != null) {
                    this.fallingAction.accept((class_3545<class_1297, class_1297>)new class_3545((Object)this.entity, (Object)projectile));
                }
                this.wasActive = false;
            }
        }
        if (projectile.method_31481()) {
            this.initialTicks.remove(projectile);
        }
    }

    public static class Factory
    extends SimplePowerFactory<ProjectileActionOverTimePower> {
        public Factory() {
            super("projectile_action_over_time", new SerializableData().add("interval", SerializableDataTypes.INT, (Object)20).add("bientity_action", Services.ACTION.biEntityDataType(), null).add("rising_action", Services.ACTION.biEntityDataType(), null).add("falling_action", Services.ACTION.biEntityDataType(), null).add("bientity_condition", Services.CONDITION.biEntityDataType(), null), data -> (type, entity) -> new ProjectileActionOverTimePower((PowerType<?>)type, (class_1309)entity, data.getInt("interval"), Services.ACTION.biEntityConsumer((SerializableData.Instance)data, "bientity_action"), Services.ACTION.biEntityConsumer((SerializableData.Instance)data, "rising_action"), Services.ACTION.biEntityConsumer((SerializableData.Instance)data, "falling_action"), Services.CONDITION.biEntityPredicate((SerializableData.Instance)data, "bientity_condition")));
            this.allowCondition();
        }

        @Override
        public Class<ProjectileActionOverTimePower> getPowerClass() {
            return ProjectileActionOverTimePower.class;
        }
    }
}

