/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.HashMap;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.class_1309;

public class RedirectLightningPower
extends Power {
    public static final HashMap<class_1309, Float> STRUCK_BY_LIGHTNING_CHANCES = new HashMap();
    private final float chance;

    public RedirectLightningPower(PowerType<?> type, class_1309 entity, float chance) {
        super(type, entity);
        this.chance = chance;
    }

    public void onAdded() {
        float chances = 0.0f;
        for (RedirectLightningPower power : Services.POWER.getPowers(this.entity, ApugliPowers.REDIRECT_LIGHTNING.get())) {
            chances += power.chance;
        }
        STRUCK_BY_LIGHTNING_CHANCES.put(this.entity, Float.valueOf(chances));
    }

    public void onRemoved() {
        float chances = 0.0f;
        for (RedirectLightningPower power : Services.POWER.getPowers(this.entity, ApugliPowers.REDIRECT_LIGHTNING.get())) {
            chances += power.chance;
        }
        if (chances == 0.0f) {
            STRUCK_BY_LIGHTNING_CHANCES.remove(this.entity);
        } else {
            STRUCK_BY_LIGHTNING_CHANCES.put(this.entity, Float.valueOf(chances));
        }
    }

    public static class Factory
    extends SimplePowerFactory<RedirectLightningPower> {
        public Factory() {
            super("redirect_lightning", new SerializableData().add("chance", SerializableDataTypes.FLOAT, null), data -> (type, entity) -> new RedirectLightningPower((PowerType<?>)type, (class_1309)entity, data.getFloat("chance")));
            this.allowCondition();
        }

        @Override
        public Class<RedirectLightningPower> getPowerClass() {
            return RedirectLightningPower.class;
        }
    }
}

