/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.ResourcePowerFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;

public interface BunnyHopPowerFactory<P>
extends ResourcePowerFactory<P> {
    public static SerializableData getSerializableData() {
        return ResourcePowerFactory.getSerializableData().add("increase_per_tick", SerializableDataTypes.FLOAT, (Object)Float.valueOf(3.75E-4f)).add("tick_rate", SerializableDataTypes.INT, (Object)10);
    }

    default public void reset(P power, class_1309 entity) {
        if (this.getValue(power, (class_1297)entity) != 0) {
            this.assign(power, (class_1297)entity, 0);
            this.sync(entity, power);
        }
    }

    default public void onTravel(class_1309 entity, class_243 movementInput) {
        if (!this.canGainResource(entity)) {
            return;
        }
        Services.POWER.getPowers(entity, this).forEach(power -> {
            SerializableData.Instance data = this.getDataFromPower(power);
            int tickRate = Math.max(1, data.getInt("tick_rate"));
            if (!entity.method_37908().field_9236 && entity.field_6012 % tickRate == 0) {
                int value = this.getValue(power, (class_1297)entity);
                if (this.increment(power, (class_1297)entity) != value) {
                    this.sync(entity, power);
                }
            }
            entity.method_5724(data.getFloat("increase_per_tick") * (float)this.getValue(power, (class_1297)entity), movementInput);
        });
    }

    default public boolean canGainResource(class_1309 entity) {
        return !entity.method_24828() && !entity.method_5799() && !entity.method_5771() && !entity.method_5765() && !entity.method_6128();
    }
}

