/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Locale;
import net.merchantpug.apugli.entity.CustomProjectile;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.ActiveCooldownPowerFactory;
import net.merchantpug.apugli.util.TextureUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.apache.commons.lang3.tuple.Triple;

public interface CustomProjectilePowerFactory<P>
extends ActiveCooldownPowerFactory<P> {
    public static SerializableData getSerializableData() {
        return ActiveCooldownPowerFactory.getSerializableData().add("texture_location", SerializableDataTypes.IDENTIFIER, null).add("texture_url", SerializableDataTypes.STRING, null).add("count", SerializableDataTypes.INT, (Object)1).add("interval", SerializableDataTypes.INT, (Object)0).add("start_delay", SerializableDataTypes.INT, (Object)0).add("speed", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.5f)).add("divergence", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("sound", SerializableDataTypes.SOUND_EVENT, null).add("tag", SerializableDataTypes.NBT, null).add("entity_action_before_firing", Services.ACTION.entityDataType(), null).add("bientity_action_after_firing", Services.ACTION.biEntityDataType(), null).add("block_action_on_hit", Services.ACTION.blockDataType(), null).add("bientity_action_on_miss", Services.ACTION.biEntityDataType(), null).add("bientity_action_on_hit", Services.ACTION.biEntityDataType(), null).add("owner_target_bientity_action_on_hit", Services.ACTION.biEntityDataType(), null).add("allow_conditional_cancelling", SerializableDataTypes.BOOLEAN, (Object)false).add("block_action_cancels_miss_action", SerializableDataTypes.BOOLEAN, (Object)false).add("block_condition", Services.CONDITION.blockDataType(), null).add("bientity_condition", Services.CONDITION.biEntityDataType(), null).add("owner_bientity_condition", Services.CONDITION.biEntityDataType(), null).add("tick_bientity_action", Services.ACTION.biEntityDataType(), null);
    }

    default public void cacheTextureUrl(class_2960 powerId, P power) {
        class_2960 urlTextureLocation = this.getUrlTextureIdentifier(powerId);
        TextureUtil.getCache().add((Triple<class_2960, String, class_2960>)Triple.of((Object)urlTextureLocation, (Object)this.getDataFromPower(power).getString("texture_url"), (Object)this.getDataFromPower(power).getId("texture_location")));
    }

    default public class_2960 getUrlTextureIdentifier(class_2960 powerId) {
        return new class_2960("apugli", this.getPowerClassString().toLowerCase(Locale.ROOT) + "/" + powerId.method_12836() + "/" + powerId.method_12832());
    }

    default public String getPowerClassString() {
        return "CustomProjectilePower";
    }

    public class_2960 getPowerId(P var1);

    public long getLastUseTime(P var1, class_1297 var2);

    public int getShotProjectiles(P var1, class_1297 var2);

    public boolean isFiringProjectiles(P var1, class_1297 var2);

    public boolean finishedStartDelay(P var1, class_1297 var2);

    public void setShotProjectiles(P var1, class_1297 var2, int var3);

    public void setFiringProjectiles(P var1, class_1297 var2, boolean var3);

    public void setFinishedStartDelay(P var1, class_1297 var2, boolean var3);

    default public void tick(P power, class_1309 entity) {
        if (this.isFiringProjectiles(power, (class_1297)entity)) {
            SerializableData.Instance data = this.getDataFromPower(power);
            if (!this.finishedStartDelay(power, (class_1297)entity) && data.getInt("start_delay") == 0) {
                this.setFinishedStartDelay(power, (class_1297)entity, true);
            }
            if (!this.finishedStartDelay(power, (class_1297)entity) && (entity.method_5770().method_8510() - this.getLastUseTime(power, (class_1297)entity)) % (long)data.getInt("start_delay") == 0L) {
                this.setFinishedStartDelay(power, (class_1297)entity, true);
                this.setShotProjectiles(power, (class_1297)entity, this.getShotProjectiles(power, (class_1297)entity) + 1);
                if (this.getShotProjectiles(power, (class_1297)entity) <= data.getInt("count")) {
                    this.playSound(data, entity);
                    if (!entity.method_37908().field_9236) {
                        this.fireProjectile(power, data, entity);
                    }
                } else {
                    this.reset(power, entity);
                }
            } else if (data.getInt("interval") == 0 && this.finishedStartDelay(power, (class_1297)entity)) {
                this.playSound(data, entity);
                if (!entity.method_37908().field_9236) {
                    while (this.getShotProjectiles(power, (class_1297)entity) < data.getInt("count")) {
                        this.fireProjectile(power, data, entity);
                        this.setShotProjectiles(power, (class_1297)entity, this.getShotProjectiles(power, (class_1297)entity) + 1);
                    }
                }
                this.reset(power, entity);
            } else if (this.finishedStartDelay(power, (class_1297)entity) && (entity.method_5770().method_8510() - this.getLastUseTime(power, (class_1297)entity)) % (long)data.getInt("interval") == 0L) {
                this.setShotProjectiles(power, (class_1297)entity, this.getShotProjectiles(power, (class_1297)entity) + 1);
                if (this.getShotProjectiles(power, (class_1297)entity) <= data.getInt("count")) {
                    this.playSound(data, entity);
                    if (!entity.method_37908().field_9236) {
                        this.fireProjectile(power, data, entity);
                    }
                } else {
                    this.reset(power, entity);
                }
            }
        }
    }

    default public void playSound(SerializableData.Instance data, class_1309 entity) {
        if (data.get("sound") != null) {
            entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), (class_3414)data.get("sound"), class_3419.field_15254, 0.5f, 0.4f / (entity.method_6051().method_43057() * 0.4f + 0.8f));
        }
    }

    default public void reset(P power, class_1309 entity) {
        this.setShotProjectiles(power, (class_1297)entity, 0);
        this.setFinishedStartDelay(power, (class_1297)entity, false);
        this.setFiringProjectiles(power, (class_1297)entity, false);
    }

    default public void fireProjectile(P power, SerializableData.Instance data, class_1309 entity) {
        Services.ACTION.executeEntity(data, "entity_action_before_firing", (class_1297)entity);
        if (data.getBoolean("allow_conditional_cancelling") && !Services.POWER.isActive(power, entity)) {
            this.setFiringProjectiles(power, (class_1297)entity, false);
            return;
        }
        float yaw = entity.method_36454();
        float pitch = entity.method_36455();
        class_243 rotationVec = entity.method_5720();
        class_243 spawnPos = entity.method_19538().method_1031(0.0, (double)entity.method_5751(), 0.0).method_1019(rotationVec);
        CustomProjectile projectile = new CustomProjectile(spawnPos.method_10216(), spawnPos.method_10214(), spawnPos.method_10215(), entity, entity.method_37908());
        projectile.setEntityId(this.getPowerId(power));
        projectile.method_7432((class_1297)entity);
        projectile.method_24919((class_1297)entity, pitch, yaw, 0.0f, data.getFloat("speed"), data.getFloat("divergence") * 0.075f);
        projectile.setImpactBlockAction(data, "block_action_on_hit");
        projectile.setBlockActionCancelsMissAction(data.getBoolean("block_action_cancels_miss_action"));
        projectile.setMissBiEntityAction(data, "bientity_action_on_miss");
        projectile.setImpactBiEntityAction(data, "bientity_action_on_hit");
        projectile.setOwnerImpactBiEntityAction(data, "owner_target_bientity_action_on_hit");
        projectile.setTextureLocation(data.getId("texture_location"));
        projectile.setUrlLocation(this.getUrlTextureIdentifier(this.getPowerId(power)));
        projectile.setBlockCondition(data, "block_condition");
        projectile.setOwnerBiEntityCondition(data, "owner_bientity_condition");
        projectile.setBiEntityCondition(data, "bientity_condition");
        projectile.setTickBiEntityAction(data, "tick_bientity_action");
        if (data.get("tag") != null) {
            class_2487 mergedTag = projectile.method_5647(new class_2487());
            mergedTag.method_10543((class_2487)data.get("tag"));
            projectile.method_5651(mergedTag);
        }
        entity.method_37908().method_8649((class_1297)projectile);
        Services.ACTION.executeBiEntity(data, "bientity_action_after_firing", (class_1297)entity, (class_1297)projectile);
    }
}

