/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.List;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.CooldownPowerFactory;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public interface DamageNearbyPowerFactory<P>
extends CooldownPowerFactory<P> {
    public static SerializableData getSerializableData() {
        return CooldownPowerFactory.getSerializableData().add("damage_condition", Services.CONDITION.damageDataType(), null).add("damage_type", SerializableDataTypes.DAMAGE_TYPE, null).add("source", Services.PLATFORM.damageSourceDescriptionDataType(), null).add("modifier", Services.PLATFORM.getModifierDataType(), null).add("modifiers", Services.PLATFORM.getModifiersDataType(), null).add("radius", SerializableDataTypes.FLOAT, (Object)Float.valueOf(16.0f));
    }

    default public void execute(P power, class_1309 powerHolder, class_1282 damageSource, float damageAmount, @Nullable class_1297 attacker, class_1309 target, String attackerName, String targetName, boolean damagerIsAttacker) {
        SerializableData.Instance data = this.getDataFromPower(power);
        if (this.canUse(power, (class_1297)powerHolder) && (!data.isPresent("damage_condition") || Services.CONDITION.checkDamage(data, "damage_condition", damageSource, damageAmount)) && (!data.isPresent(attackerName + "_" + targetName + "_bientity_condition") || attacker != null && Services.CONDITION.checkBiEntity(data, attackerName + "_" + targetName + "_bientity_condition", attacker, (class_1297)target))) {
            float radius = data.getFloat("radius");
            List<Object> modifiers = new ArrayList();
            if (data.isPresent("modifiers")) {
                modifiers = (List)data.get("modifiers");
            }
            if (data.isPresent("modifier")) {
                modifiers.add(data.get("modifier"));
            }
            for (class_1309 nearby : target.method_37908().method_18467(class_1309.class, class_238.method_30048((class_243)target.method_30950(1.0f), (double)radius, (double)radius, (double)radius))) {
                if (nearby == attacker || nearby == target || (attacker != null || data.isPresent(attackerName + "_" + targetName + "_bientity_condition")) && !Services.CONDITION.checkBiEntity(data, attackerName + "_nearby_bientity_condition", attacker, (class_1297)nearby) || !Services.CONDITION.checkBiEntity(data, targetName + "_nearby_bientity_condition", (class_1297)target, (class_1297)nearby)) continue;
                if (attacker != null) {
                    nearby.method_5643(Services.PLATFORM.createDamageSource(target.method_48923(), data, (class_1297)(damagerIsAttacker ? attacker : powerHolder), "damage_type", "source"), (float)Services.PLATFORM.applyModifiers((class_1297)powerHolder, modifiers, (double)damageAmount));
                    if (data.isPresent(attackerName + "_" + targetName + "_bientity_action")) {
                        Services.ACTION.executeBiEntity(data, attackerName + "_" + targetName + "_bientity_action", attacker, (class_1297)target);
                    }
                    if (data.isPresent(attackerName + "_nearby_bientity_action")) {
                        Services.ACTION.executeBiEntity(data, attackerName + "_nearby_bientity_action", (class_1297)target, (class_1297)nearby);
                    }
                } else {
                    nearby.method_5643(Services.PLATFORM.createDamageSource(target.method_48923(), data, "damage_type", "source"), (float)Services.PLATFORM.applyModifiers((class_1297)powerHolder, modifiers, (double)damageAmount));
                }
                if (!data.isPresent(targetName + "_nearby_bientity_action")) continue;
                Services.ACTION.executeBiEntity(data, targetName + "_nearby_bientity_action", (class_1297)target, (class_1297)nearby);
            }
            this.use(power, (class_1297)powerHolder);
        }
    }
}

