/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.merchantpug.apugli.access.ItemStackAccess;
import net.merchantpug.apugli.mixin.xplatform.common.accessor.SlotArgumentAccessor;
import net.merchantpug.apugli.network.s2c.ModifyEnchantmentLevelPacket;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.ValueModifyingPowerFactory;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.merchantpug.apugli.util.ComparableItemStack;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5630;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public interface ModifyEnchantmentLevelPowerFactory<P>
extends ValueModifyingPowerFactory<P> {
    public static final ConcurrentHashMap<UUID, class_1799> ENTITY_EMPTY_STACK_MAP = new ConcurrentHashMap();

    public static boolean isWorkableEmptyStack(class_1297 entity, class_5630 slotAccess) {
        return slotAccess != null && slotAccess != class_5630.field_27860 && slotAccess.method_32327().method_7960() && ENTITY_EMPTY_STACK_MAP.containsKey(entity.method_5667()) && slotAccess.method_32327() == ENTITY_EMPTY_STACK_MAP.get(entity.method_5667());
    }

    public static class_1799 getWorkableEmptyStack(@NotNull class_1297 entity) {
        if (!ApugliPowers.MODIFY_ENCHANTMENT_LEVEL.get().getEntityItemEnchants().containsKey(entity.method_5667())) {
            return class_1799.field_8037;
        }
        if (!ENTITY_EMPTY_STACK_MAP.containsKey(entity.method_5667())) {
            class_1799 stack = new class_1799((Void)null);
            ((ItemStackAccess)stack).apugli$setEntity(entity);
            ENTITY_EMPTY_STACK_MAP.put(entity.method_5667(), stack);
        }
        return ENTITY_EMPTY_STACK_MAP.get(entity.method_5667());
    }

    public static SerializableData getSerializableData() {
        return ValueModifyingPowerFactory.getSerializableData().add("enchantment", SerializableDataTypes.ENCHANTMENT).add("item_condition", Services.CONDITION.itemDataType(), null);
    }

    default public void onAdded(P power, class_1297 entity) {
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309)entity;
        this.getEntityItemEnchants().computeIfAbsent(living.method_5667(), _living -> new ConcurrentHashMap());
        ConcurrentHashMap cache = this.getPowerModifierCache().computeIfAbsent(living.method_5667(), _living -> new ConcurrentHashMap());
        cache.compute(power, (p, _val) -> new class_3545((Object)0, (Object)false));
        if (entity.method_37908().method_8608()) {
            return;
        }
        Services.PLATFORM.sendS2CTrackingAndSelf(new ModifyEnchantmentLevelPacket(entity.method_5628(), Services.POWER.getPowerId(power), false), entity);
    }

    default public void tick(P power, class_1297 entity) {
        for (int slot : SlotArgumentAccessor.apugli$getSlots().values()) {
            class_1799 stack;
            class_5630 slotAccess = entity.method_32318(slot);
            if (slotAccess == class_5630.field_27860 || ((ItemStackAccess)slotAccess.method_32327()).apugli$getEntity() != null || !(stack = slotAccess.method_32327()).method_7960() || ModifyEnchantmentLevelPowerFactory.isWorkableEmptyStack(entity, slotAccess)) continue;
            slotAccess.method_32332(ModifyEnchantmentLevelPowerFactory.getWorkableEmptyStack(entity));
        }
    }

    default public void onRemoved(P power, class_1297 entity) {
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309)entity;
        this.getPowerModifierCache().computeIfAbsent(living.method_5667(), _living -> new ConcurrentHashMap()).remove(power);
        if (Services.POWER.getPowers(living, this).size() - 1 == 0) {
            for (int slot : SlotArgumentAccessor.apugli$getSlots().values()) {
                class_5630 slotAccess = entity.method_32318(slot);
                if (slotAccess == class_5630.field_27860 || !ModifyEnchantmentLevelPowerFactory.isWorkableEmptyStack(entity, slotAccess)) continue;
                slotAccess.method_32332(class_1799.field_8037);
            }
            this.getEntityItemEnchants().remove(living.method_5667());
        }
        if (entity.method_37908().method_8608()) {
            return;
        }
        Services.PLATFORM.sendS2CTrackingAndSelf(new ModifyEnchantmentLevelPacket(entity.method_5628(), Services.POWER.getPowerId(power), true), entity);
    }

    default public boolean doesApply(P power, class_1887 enchantment, class_1937 level, class_1799 self) {
        return enchantment.equals(this.getDataFromPower(power).get("enchantment")) && this.checkItemCondition(power, level, self);
    }

    default public boolean checkItemCondition(P power, class_1937 level, class_1799 self) {
        return !this.getDataFromPower(power).isPresent("item_condition") || Services.CONDITION.checkItem(this.getDataFromPower(power), "item_condition", level, self);
    }

    default public Optional<Integer> findEnchantIndex(class_2960 id, class_2499 enchants) {
        for (int i = 0; i < enchants.size(); ++i) {
            String string = enchants.method_10602(i).method_10558("id");
            class_2960 enchantId = class_2960.method_12829((String)string);
            if (enchantId == null || !enchantId.equals((Object)id)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    default public class_2499 generateEnchantments(class_2499 enchants, class_1799 self) {
        if (self == null) {
            return enchants;
        }
        class_1297 entity = ((ItemStackAccess)self).apugli$getEntity();
        if (!(entity instanceof class_1309)) {
            return enchants;
        }
        class_1309 living = (class_1309)entity;
        class_2499 newEnchants = enchants.method_10612();
        List powers = Services.POWER.getPowers(living, this);
        for (Object power : powers) {
            class_1887 enchantment = (class_1887)this.getDataFromPower(power).get("enchantment");
            class_2960 id = class_7923.field_41176.method_10221((Object)enchantment);
            if (!this.doesApply(power, enchantment, entity.method_37908(), self)) continue;
            Optional<Integer> idx = this.findEnchantIndex(id, newEnchants);
            if (idx.isPresent()) {
                class_2487 existingEnchant = newEnchants.method_10602(idx.get().intValue());
                int lvl = existingEnchant.method_10550("lvl");
                int newLvl = (int)Services.PLATFORM.applyModifiers((class_1297)living, this.getModifiers(power, (class_1297)living), (double)lvl);
                existingEnchant.method_10569("lvl", newLvl);
                newEnchants.method_10606(idx.get().intValue(), (class_2520)existingEnchant);
                continue;
            }
            class_2487 newEnchant = new class_2487();
            newEnchant.method_10582("id", id.toString());
            newEnchant.method_10569("lvl", (int)Services.PLATFORM.applyModifiers((class_1297)living, this.getModifiers(power, (class_1297)living), 0.0));
            newEnchants.add((Object)newEnchant);
        }
        return newEnchants;
    }

    default public class_2499 getEnchantments(class_1799 self, class_2499 originalTag) {
        class_1297 entity;
        if (self != null && (entity = ((ItemStackAccess)self).apugli$getEntity()) instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            if (this.getEntityItemEnchants().containsKey(living.method_5667())) {
                ConcurrentHashMap<ComparableItemStack, class_2499> itemEnchants = this.getEntityItemEnchants().get(living.method_5667());
                ComparableItemStack comparableStack = new ComparableItemStack(self);
                if (this.shouldReapplyEnchantments(living, comparableStack)) {
                    itemEnchants.computeIfAbsent(comparableStack, tag -> originalTag);
                    return itemEnchants.compute(comparableStack, (tagEnchants, tag) -> this.generateEnchantments(originalTag, self));
                }
                return itemEnchants.getOrDefault(comparableStack, originalTag);
            }
        }
        return originalTag;
    }

    default public Map<class_1887, Integer> getItemEnchantments(class_1799 self) {
        class_1297 entity = ((ItemStackAccess)self).apugli$getEntity();
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            if (this.getEntityItemEnchants().containsKey(living.method_5667())) {
                ConcurrentHashMap<ComparableItemStack, class_2499> itemEnchants = this.getEntityItemEnchants().get(living.method_5667());
                ComparableItemStack comparableItemStack = new ComparableItemStack(self);
                return class_1890.method_22445((class_2499)itemEnchants.computeIfAbsent(comparableItemStack, stack -> stack.stack().method_7921()));
            }
        }
        return class_1890.method_8222((class_1799)self);
    }

    default public int getEnchantmentLevel(class_1887 enchantment, class_1309 living) {
        if (this.getEntityItemEnchants().containsKey(living.method_5667())) {
            int i = 0;
            for (class_1799 stack : living.method_5743()) {
                int j = this.getItemEnchantmentLevel(enchantment, stack);
                if (j <= i) continue;
                i = j;
            }
            return i;
        }
        return class_1890.method_8203((class_1887)enchantment, (class_1309)living);
    }

    default public int getItemEnchantmentLevel(class_1887 enchantment, class_1799 self) {
        if (self == null) {
            return 0;
        }
        class_1297 entity = ((ItemStackAccess)self).apugli$getEntity();
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            if (this.getEntityItemEnchants().containsKey(living.method_5667())) {
                class_2499 newEnchants;
                ConcurrentHashMap<ComparableItemStack, class_2499> itemEnchants = this.getEntityItemEnchants().get(living.method_5667());
                ComparableItemStack comparableStack = new ComparableItemStack(self);
                class_2960 id = class_7923.field_41176.method_10221((Object)enchantment);
                Optional<Integer> idx = this.findEnchantIndex(id, newEnchants = itemEnchants.getOrDefault(comparableStack, self.method_7921()));
                if (idx.isPresent()) {
                    class_2487 existingEnchant = newEnchants.method_10602(idx.get().intValue());
                    return existingEnchant.method_10550("lvl");
                }
                return 0;
            }
        }
        return class_1890.method_8225((class_1887)enchantment, (class_1799)self);
    }

    default public boolean updateIfDifferent(ConcurrentHashMap<P, class_3545<Integer, Boolean>> map, P power, int modifierValue, boolean conditionValue) {
        map.computeIfAbsent(power, p -> new class_3545((Object)0, (Object)false));
        boolean value = false;
        if ((Integer)map.get(power).method_15442() != modifierValue) {
            map.get(power).method_34964((Object)modifierValue);
            value = true;
        }
        if ((Boolean)map.get(power).method_15441() != conditionValue) {
            map.get(power).method_34965((Object)conditionValue);
            value = true;
        }
        return value;
    }

    default public boolean shouldReapplyEnchantments(class_1309 living, ComparableItemStack stack) {
        List powers = Services.POWER.getPowers(living, this, true);
        ConcurrentHashMap<ComparableItemStack, class_2499> enchants = this.getEntityItemEnchants().get(living.method_5667());
        ConcurrentHashMap cache = this.getPowerModifierCache().computeIfAbsent(living.method_5667(), _living -> new ConcurrentHashMap());
        return !enchants.containsKey(stack) || powers.stream().anyMatch(power -> this.updateIfDifferent(cache, power, (int)Services.PLATFORM.applyModifiers((class_1297)living, this.getModifiers(power, (class_1297)living), 0.0), Services.POWER.isActive(power, living) && this.checkItemCondition(power, living.method_37908(), stack.stack())));
    }

    public ConcurrentHashMap<UUID, ConcurrentHashMap<ComparableItemStack, class_2499>> getEntityItemEnchants();

    public ConcurrentHashMap<UUID, ConcurrentHashMap<P, class_3545<Integer, Boolean>>> getPowerModifierCache();
}

