/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import net.merchantpug.apugli.access.ExplosionAccess;
import net.merchantpug.apugli.network.s2c.SyncExplosionPacket;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.ActiveCooldownPowerFactory;
import net.merchantpug.apugli.registry.ApugliTags;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1927;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

@Deprecated
public interface RocketJumpPowerFactory<P>
extends ActiveCooldownPowerFactory<P> {
    public static SerializableData getSerializableData() {
        return ActiveCooldownPowerFactory.getSerializableData().add("distance", SerializableDataTypes.DOUBLE, (Object)Double.NaN).add("damage_type", SerializableDataTypes.DAMAGE_TYPE, null).add("source", ApoliDataTypes.DAMAGE_SOURCE_DESCRIPTION, null).add("amount", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("velocity", SerializableDataTypes.DOUBLE, (Object)1.0).addFunctionedDefault("horizontal_velocity", SerializableDataTypes.DOUBLE, data -> data.getDouble("velocity")).addFunctionedDefault("vertical_velocity", SerializableDataTypes.DOUBLE, data -> data.getDouble("velocity")).add("velocity_clamp_multiplier", SerializableDataTypes.DOUBLE, (Object)1.8).add("use_charged", SerializableDataTypes.BOOLEAN, (Object)false).add("charged_modifier", Services.PLATFORM.getModifierDataType(), null).add("charged_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("water_modifier", Services.PLATFORM.getModifierDataType(), null).add("water_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("damage_modifier", Services.PLATFORM.getModifierDataType(), null).add("damage_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("targetable_bientity_condition", Services.CONDITION.biEntityDataType(), null).add("damage_bientity_condition", Services.CONDITION.biEntityDataType(), null);
    }

    public List<?> chargedModifiers(P var1, class_1297 var2);

    public List<?> waterModifiers(P var1, class_1297 var2);

    public List<?> damageModifiers(P var1, class_1297 var2);

    public List<?> knockbackModifiers();

    public List<?> volumeModifiers();

    public List<?> pitchModifiers();

    default public void executeJump(P power, class_1297 entity) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            if (!entity.method_37908().method_8608()) {
                class_239.class_240 entityHitResultType;
                SerializableData.Instance data = this.getDataFromPower(power);
                double distance = !Double.isNaN(data.getDouble("distance")) ? data.getDouble("distance") : Services.PLATFORM.getReachDistance(entity);
                class_243 eyePosition = entity.method_5836(0.0f);
                class_243 lookVector = entity.method_5828(0.0f).method_1021(distance);
                class_243 traceEnd = eyePosition.method_1019(lookVector);
                class_3959 context = new class_3959(eyePosition, traceEnd, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, entity);
                class_3965 blockHitResult = entity.method_37908().method_17742(context);
                double entityDistance = !Double.isNaN(data.getDouble("distance")) ? data.getDouble("distance") : Services.PLATFORM.getAttackRange(entity);
                class_243 entityLookVector = entity.method_5828(0.0f).method_1021(entityDistance);
                class_243 entityTraceEnd = eyePosition.method_1019(entityLookVector);
                class_238 entityBox = entity.method_5829().method_18804(lookVector).method_1014(1.0);
                double blockHitResultSquaredDistance = blockHitResult.method_17777().method_10268(eyePosition.field_1352, eyePosition.field_1351, eyePosition.field_1350);
                double entityReach = Math.min(blockHitResultSquaredDistance, entityDistance * entityDistance);
                class_3966 entityHitResult = class_1675.method_18075((class_1297)entity, (class_243)eyePosition, (class_243)entityTraceEnd, (class_238)entityBox, traceEntity -> !traceEntity.method_7325() && traceEntity.method_30948() && Services.CONDITION.checkBiEntity(data, "targetable_bientity_condition", entity, (class_1297)traceEntity), (double)entityReach);
                class_239.class_240 blockHitResultType = blockHitResult.method_17783();
                class_239.class_240 class_2402 = entityHitResultType = entityHitResult != null ? entityHitResult.method_17783() : class_239.class_240.field_1333;
                if (blockHitResultType == class_239.class_240.field_1333 && entityHitResultType == class_239.class_240.field_1333) {
                    return;
                }
                boolean isCharged = living.method_6026().stream().anyMatch(effect -> class_7923.field_41174.method_29113((Object)effect.method_5579()).isPresent() && class_7923.field_41174.method_40264((class_5321)class_7923.field_41174.method_29113((Object)effect.method_5579()).get()).isPresent() && ((class_6880.class_6883)class_7923.field_41174.method_40264((class_5321)class_7923.field_41174.method_29113((Object)effect.method_5579()).get()).get()).method_40220(ApugliTags.CHARGED_EFFECTS));
                if (entityHitResultType == class_239.class_240.field_1331) {
                    this.handleRocketJump(power, data, living, (class_239)entityHitResult, isCharged);
                    return;
                }
                if (blockHitResultType == class_239.class_240.field_1332) {
                    this.handleRocketJump(power, data, living, (class_239)blockHitResult, isCharged);
                }
            }
        }
    }

    default public void handleRocketJump(P power, SerializableData.Instance data, class_1309 entity, class_239 hitResult, boolean isCharged) {
        float e;
        boolean useCharged = data.getBoolean("use_charged");
        double horizontalVelocity = isCharged && useCharged && !this.chargedModifiers(power, (class_1297)entity).isEmpty() ? Services.PLATFORM.applyModifiers((class_1297)entity, this.chargedModifiers(power, (class_1297)entity), data.getDouble("horizontal_velocity")) : data.getDouble("horizontal_velocity");
        double verticalVelocity = isCharged && useCharged && !this.chargedModifiers(power, (class_1297)entity).isEmpty() ? Services.PLATFORM.applyModifiers((class_1297)entity, this.chargedModifiers(power, (class_1297)entity), data.getDouble("vertical_velocity")) : data.getDouble("vertical_velocity");
        float f = e = isCharged && useCharged ? 2.0f : 1.5f;
        if ((data.isPresent("damage_type") || data.isPresent("source")) && data.getFloat("amount") != 0.0f) {
            class_1282 source = Services.PLATFORM.createDamageSource(entity.method_48923(), data, "source", "damage_type");
            entity.method_5643(source, data.getFloat("amount"));
        }
        float f2 = class_3532.method_15374((float)(entity.method_36454() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(entity.method_36455() * ((float)Math.PI / 180)));
        float g = class_3532.method_15374((float)(entity.method_36455() * ((float)Math.PI / 180)));
        float h = -class_3532.method_15362((float)(entity.method_36454() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(entity.method_36455() * ((float)Math.PI / 180)));
        class_1927 explosion = new class_1927(entity.method_37908(), (class_1297)entity, null, null, hitResult.method_17784().method_10216(), hitResult.method_17784().method_10214(), hitResult.method_17784().method_10215(), e, false, class_1927.class_4179.field_40878);
        ((ExplosionAccess)explosion).apugli$setExplosionDamageModifiers(this.damageModifiers(power, (class_1297)entity));
        ((ExplosionAccess)explosion).apugli$setExplosionKnockbackModifiers(this.knockbackModifiers());
        ((ExplosionAccess)explosion).apugli$setExplosionVolumeModifiers(this.volumeModifiers());
        ((ExplosionAccess)explosion).apugli$setExplosionPitchModifiers(this.pitchModifiers());
        ((ExplosionAccess)explosion).apugli$setBiEntityPredicate(data.get("damage_bientity_condition"));
        explosion.method_8348();
        explosion.method_8350(false);
        this.sendExplosionToClient(power, data, entity, hitResult, e);
        if (entity.method_5799()) {
            horizontalVelocity = !this.waterModifiers(power, (class_1297)entity).isEmpty() ? Services.PLATFORM.applyModifiers((class_1297)entity, this.waterModifiers(power, (class_1297)entity), horizontalVelocity) : horizontalVelocity;
            verticalVelocity = !this.waterModifiers(power, (class_1297)entity).isEmpty() ? Services.PLATFORM.applyModifiers((class_1297)entity, this.waterModifiers(power, (class_1297)entity), verticalVelocity) : verticalVelocity;
        }
        double velocityClampMultiplier = data.getDouble("velocity_clamp_multiplier");
        class_243 vec = entity.method_18798().method_1031((double)f2 * horizontalVelocity, (double)g * verticalVelocity, (double)h * horizontalVelocity);
        double horizontalClamp = isCharged ? Services.PLATFORM.applyModifiers((class_1297)entity, this.chargedModifiers(power, (class_1297)entity), horizontalVelocity * velocityClampMultiplier) : horizontalVelocity * velocityClampMultiplier;
        double verticalClamp = isCharged ? Services.PLATFORM.applyModifiers((class_1297)entity, this.chargedModifiers(power, (class_1297)entity), verticalVelocity * velocityClampMultiplier) : verticalVelocity * velocityClampMultiplier;
        entity.method_18800(class_3532.method_15350((double)vec.field_1352, (double)(-horizontalClamp), (double)horizontalClamp), class_3532.method_15350((double)vec.field_1351, (double)(-verticalClamp), (double)verticalClamp), class_3532.method_15350((double)vec.field_1350, (double)(-horizontalClamp), (double)horizontalClamp));
        entity.field_6037 = true;
        entity.field_6017 = 0.0f;
        this.use(power, (class_1297)entity);
    }

    default public void sendExplosionToClient(P power, SerializableData.Instance data, class_1309 entity, class_239 hitResult, float radius) {
        SyncExplosionPacket<Object, Object> packet = new SyncExplosionPacket<Object, Object>(entity.method_5628(), hitResult.method_17784().method_10216(), hitResult.method_17784().method_10214(), hitResult.method_17784().method_10215(), this.damageModifiers(power, (class_1297)entity), this.knockbackModifiers(), this.volumeModifiers(), this.pitchModifiers(), data.get("damage_bientity_condition"), false, null, false, radius);
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            Services.PLATFORM.sendS2CTrackingAndSelf(packet, (class_1297)serverPlayer);
        }
    }
}

