/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.integration.pehkui;

import com.google.auto.service.AutoService;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.merchantpug.apugli.integration.pehkui.PehkuiUtil;
import net.merchantpug.apugli.power.AbstractValueModifyingPower;
import net.merchantpug.apugli.power.factory.ModifyScalePowerFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

@AutoService(value={ModifyScalePowerFactory.class})
public class ModifyScalePower
extends AbstractValueModifyingPower<Instance>
implements ModifyScalePowerFactory<Instance> {
    public ModifyScalePower() {
        super("modify_scale", ModifyScalePowerFactory.getSerializableData(), data -> (type, entity) -> new Instance((PowerType<?>)type, (class_1309)entity, (SerializableData.Instance)data));
        this.allowCondition();
    }

    @Override
    public Class<Instance> getPowerClass() {
        return Instance.class;
    }

    @Override
    public class_2960 getPowerId(Instance power) {
        return power.getType().getIdentifier();
    }

    @Override
    public Object getApoliScaleModifier(Instance power, class_1297 entity) {
        return power.apoliScaleModifier;
    }

    @Override
    public List<?> getDelayModifiers(Instance power, class_1297 entity) {
        return power.delayModifiers;
    }

    @Override
    public Set<class_2960> getCachedScaleIds(Instance power, class_1297 entity) {
        return power.cachedScaleIds;
    }

    public static class Instance
    extends AbstractValueModifyingPower.Instance {
        private final Object apoliScaleModifier;
        private final Set<class_2960> cachedScaleIds;
        private final List<Modifier> delayModifiers = new ArrayList<Modifier>();

        public Instance(PowerType<?> type, class_1309 entity, SerializableData.Instance data) {
            super(type, entity, data);
            this.setTicking(true);
            if (FabricLoader.getInstance().isModLoaded("pehkui")) {
                this.cachedScaleIds = PehkuiUtil.getTypesFromCache(data);
                this.apoliScaleModifier = PehkuiUtil.createApoliScaleModifier(this, this.entity, this.data);
            } else {
                this.cachedScaleIds = Set.of();
                this.apoliScaleModifier = null;
            }
            data.ifPresent("delay_modifier", this.delayModifiers::add);
            data.ifPresent("delay_modifiers", this.delayModifiers::addAll);
        }

        public void onAdded() {
            PehkuiUtil.onAddedOrRespawnedScalePower(this, this.entity);
        }

        public void onRespawn() {
            PehkuiUtil.onAddedOrRespawnedScalePower(this, this.entity);
        }

        public void onRemoved() {
            PehkuiUtil.onRemovedScalePower(this, this.entity);
        }

        public class_2520 toTag() {
            return PehkuiUtil.serializeScalePower(this, this.entity, new class_2487());
        }

        public void fromTag(class_2520 tag) {
            if (!(tag instanceof class_2487)) {
                return;
            }
            class_2487 compoundTag = (class_2487)tag;
            PehkuiUtil.deserializeScalePower(this, this.entity, compoundTag);
        }
    }
}

