/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.util;

import io.github.apace100.apoli.util.Space;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3545;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.joml.Vector3f;

public class RaycastUtil {
    public static class_3965 raycastBlock(class_1297 actor, double dis) {
        return RaycastUtil.raycastBlock(actor, dis, null, Space.WORLD);
    }

    public static class_3965 raycastBlock(class_1297 actor, double dis, class_243 direction, Space space) {
        class_243 rayDir;
        class_243 rayStart = actor.method_5836(0.0f);
        if (direction == null) {
            rayDir = actor.method_5828(0.0f).method_1021(dis);
        } else {
            Vector3f vector3f = new Vector3f((float)direction.method_10216(), (float)direction.method_10214(), (float)direction.method_10215()).normalize();
            space.toGlobal(vector3f, actor);
            rayDir = new class_243((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).method_1021(dis);
        }
        class_243 rayEnd = rayStart.method_1019(rayDir);
        class_3959 context = new class_3959(rayStart, rayEnd, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, actor);
        return actor.method_37908().method_17742(context);
    }

    public static class_3966 raycastEntity(class_3965 blockHitResult, class_1297 actor, double dis) {
        return RaycastUtil.raycastEntity(blockHitResult, actor, dis, null, Space.WORLD, null);
    }

    public static class_3966 raycastEntity(class_3965 blockHitResult, class_1297 actor, double dis, class_243 direction, Space space, Predicate<class_3545<class_1297, class_1297>> predicate) {
        class_243 rayDir;
        class_243 rayStart = actor.method_5836(0.0f);
        if (direction == null) {
            rayDir = actor.method_5828(0.0f).method_1021(dis);
        } else {
            Vector3f vector3f = new Vector3f((float)direction.method_10216(), (float)direction.method_10214(), (float)direction.method_10215()).normalize();
            space.toGlobal(vector3f, actor);
            rayDir = new class_243((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).method_1021(dis);
        }
        class_243 rayEnd = rayStart.method_1019(rayDir);
        class_238 entityBox = actor.method_5829().method_18804(rayDir).method_1014(1.0);
        double blockHitDisSqr = blockHitResult != null ? blockHitResult.method_17777().method_40081(rayStart.field_1352, rayStart.field_1351, rayStart.field_1350) : dis * dis;
        double disSqr = Math.min(blockHitDisSqr, dis * dis);
        return class_1675.method_18075((class_1297)actor, (class_243)rayStart, (class_243)rayEnd, (class_238)entityBox, traceEntity -> !traceEntity.method_7325() && traceEntity.method_5863() && (predicate == null || predicate.test(new class_3545((Object)actor, traceEntity))), (double)disSqr);
    }

    public static List<class_3966> raycastEntities(class_1297 actor, Predicate<class_1297> predicate, double dis, class_243 direction, Space space) {
        class_243 rayDir;
        class_243 rayStart = actor.method_5836(0.0f);
        if (direction == null) {
            rayDir = actor.method_5828(0.0f).method_1021(dis);
        } else {
            Vector3f vector3f = new Vector3f((float)direction.method_10216(), (float)direction.method_10214(), (float)direction.method_10215()).normalize();
            space.toGlobal(vector3f, actor);
            rayDir = new class_243((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).method_1021(dis);
        }
        class_243 rayEnd = rayStart.method_1019(rayDir);
        class_238 entityBox = actor.method_5829().method_18804(rayDir).method_1014(1.0);
        ArrayList<class_3966> results = new ArrayList<class_3966>();
        class_1937 level = actor.method_37908();
        for (class_1297 target : level.method_8333(actor, entityBox, predicate)) {
            double targetDis;
            class_238 targetBB = target.method_5829().method_1014((double)target.method_5871());
            Optional intersection = targetBB.method_992(rayStart, rayEnd);
            if (targetBB.method_1006(rayStart)) {
                if (!(dis >= 0.0)) continue;
                results.add(new class_3966(target, intersection.orElse(rayStart)));
                continue;
            }
            if (!intersection.isPresent() || !((targetDis = rayStart.method_1025((class_243)intersection.get())) < dis) && dis != 0.0) continue;
            if (target.method_5668() == actor.method_5668()) {
                if (dis != 0.0) continue;
                results.add(new class_3966(target, (class_243)intersection.get()));
                continue;
            }
            dis = targetDis;
            results.add(new class_3966(target, (class_243)intersection.get()));
        }
        return results;
    }
}

