/*
 * Decompiled with CFR 0.152.
 */
package com.imoonday.compression_bag;

import com.imoonday.compression_bag.CompressionBag;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_5272;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5631;
import net.minecraft.class_5632;

public class CompressionBagItem
extends class_1792 {
    public CompressionBagItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static void registerClient() {
        class_5272.method_27879((class_1792)CompressionBag.COMPRESSION_BAG, (class_2960)new class_2960("compressed"), (stack, world, entity, seed) -> CompressionBagItem.getItem(stack).isPresent() ? 1.0f : 0.0f);
    }

    public class_2561 method_7864(class_1799 stack) {
        class_5250 name = super.method_7864(stack).method_27661();
        if (CompressionBagItem.getItem(stack).isPresent()) {
            name = name.method_27693(": ").method_10852(((class_1799)CompressionBagItem.getItem(stack).get().method_15442()).method_7964());
        }
        return name;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2371 defaultedList = class_2371.method_10211();
        CompressionBagItem.getItem(stack).ifPresent(itemStackIntegerPair -> defaultedList.add((Object)((class_1799)itemStackIntegerPair.method_15442()).method_46651(1)));
        return Optional.of(new class_5631(defaultedList, 0));
    }

    public static Optional<class_3545<class_1799, Integer>> getItem(class_1799 bag) {
        if (!bag.method_31574(CompressionBag.COMPRESSION_BAG)) {
            return Optional.empty();
        }
        if (bag.method_7969() != null && bag.method_7969().method_10573("Item", 10) && bag.method_7969().method_10573("Count", 3)) {
            class_2487 nbtCompound = bag.method_7969().method_10562("Item");
            int count = bag.method_7969().method_10550("Count");
            class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound);
            if (!itemStack.method_7960()) {
                return Optional.of(new class_3545((Object)itemStack, (Object)count));
            }
            CompressionBagItem.removeItem(bag);
        }
        return Optional.empty();
    }

    public static void removeItem(class_1799 bag) {
        if (bag.method_7969() != null) {
            bag.method_7948().method_10551("Item");
            bag.method_7948().method_10551("Count");
        }
    }

    public static boolean setItem(class_1799 bag, class_1799 stack) {
        return CompressionBagItem.setItem(bag, stack, stack.method_7947());
    }

    public static boolean setItem(class_1799 bag, class_1799 stack, int count) {
        if (stack.method_31574(CompressionBag.COMPRESSION_BAG)) {
            return false;
        }
        bag.method_7948().method_10566("Item", (class_2520)stack.method_46651(1).method_7953(new class_2487()));
        CompressionBagItem.setCount(bag, count);
        return true;
    }

    public static void increment(class_1799 bag, int amount) {
        CompressionBagItem.getItem(bag).ifPresent(pair -> CompressionBagItem.setCount(bag, (Integer)pair.method_15441() + amount));
    }

    public static int decrement(class_1799 bag, int amount) {
        if (CompressionBagItem.getItem(bag).isPresent()) {
            class_3545<class_1799, Integer> pair = CompressionBagItem.getItem(bag).get();
            int resultCount = (Integer)pair.method_15441() - amount;
            if (resultCount <= 0) {
                CompressionBagItem.removeItem(bag);
                return 0;
            }
            CompressionBagItem.setCount(bag, resultCount);
            return resultCount;
        }
        return 0;
    }

    public static void setCount(class_1799 bag, int count) {
        bag.method_7948().method_10569("Count", count);
    }

    public static int decrementMax(class_1799 bag) {
        if (CompressionBagItem.getItem(bag).isPresent()) {
            class_1799 itemStack;
            int maxCount;
            class_3545<class_1799, Integer> pair = CompressionBagItem.getItem(bag).get();
            int count = (Integer)pair.method_15441();
            if (count > (maxCount = (itemStack = (class_1799)pair.method_15442()).method_7914())) {
                CompressionBagItem.decrement(bag, maxCount);
                return maxCount;
            }
            CompressionBagItem.removeItem(bag);
            return count;
        }
        return 0;
    }

    public static boolean canMerge(class_1799 bag, class_1799 stack) {
        return CompressionBagItem.getItem(bag).isEmpty() || class_1799.method_31577((class_1799)((class_1799)CompressionBagItem.getItem(bag).get().method_15442()), (class_1799)stack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType != class_5536.field_27014) {
            return false;
        }
        class_1799 itemStack = slot.method_7677();
        if (itemStack.method_7960()) {
            if (!CompressionBagItem.getItem(stack).isPresent()) return false;
            class_1799 itemStack1 = ((class_1799)CompressionBagItem.getItem(stack).get().method_15442()).method_7972();
            int decrement = CompressionBagItem.decrementMax(stack);
            this.playRemoveOneSound((class_1297)player);
            slot.method_32756(itemStack1.method_46651(decrement));
            return true;
        } else {
            if (CompressionBagItem.getItem(stack).isPresent()) {
                class_3545<class_1799, Integer> pair = CompressionBagItem.getItem(stack).get();
                if (!class_1799.method_31577((class_1799)((class_1799)pair.method_15442()), (class_1799)itemStack)) return true;
                CompressionBagItem.increment(stack, itemStack.method_7947());
            } else if (!CompressionBagItem.setItem(stack, itemStack)) {
                return true;
            }
            slot.method_7671(itemStack.method_7947());
            this.playInsertSound((class_1297)player);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType != class_5536.field_27014 || !slot.method_32754(player)) {
            return false;
        }
        if (otherStack.method_7960()) {
            if (!CompressionBagItem.getItem(stack).isPresent()) return false;
            class_1799 itemStack = ((class_1799)CompressionBagItem.getItem(stack).get().method_15442()).method_7972();
            int decrement = CompressionBagItem.decrementMax(stack);
            this.playRemoveOneSound((class_1297)player);
            cursorStackReference.method_32332(itemStack.method_46651(decrement));
            return true;
        } else {
            if (CompressionBagItem.getItem(stack).isPresent()) {
                class_3545<class_1799, Integer> pair = CompressionBagItem.getItem(stack).get();
                if (!class_1799.method_31577((class_1799)((class_1799)pair.method_15442()), (class_1799)otherStack)) return true;
                CompressionBagItem.increment(stack, otherStack.method_7947());
            } else if (!CompressionBagItem.setItem(stack, otherStack)) {
                return true;
            }
            this.playInsertSound((class_1297)player);
            otherStack.method_7934(otherStack.method_7947());
        }
        return true;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (user.method_5715() ? CompressionBagItem.dropAllItems((class_1297)user, itemStack) : CompressionBagItem.dropItem((class_1297)user, itemStack)) {
            this.playDropContentsSound((class_1297)user);
            user.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public void method_33261(class_1542 entity) {
        class_1799 stack = entity.method_6983();
        CompressionBagItem.dropAllItems((class_1297)entity, stack);
    }

    public static boolean dropItem(class_1297 entity, class_1799 stack) {
        if (CompressionBagItem.getItem(stack).isPresent()) {
            class_1799 itemStack = ((class_1799)CompressionBagItem.getItem(stack).get().method_15442()).method_7972();
            int decrement = CompressionBagItem.decrementMax(stack);
            entity.method_5775(itemStack.method_46651(decrement));
            return true;
        }
        return false;
    }

    public static boolean dropAllItems(class_1297 entity, class_1799 stack) {
        boolean dropped = false;
        while (CompressionBagItem.getItem(stack).isPresent()) {
            class_1799 itemStack = ((class_1799)CompressionBagItem.getItem(stack).get().method_15442()).method_7972();
            int decrement = CompressionBagItem.decrementMax(stack);
            entity.method_5775(itemStack.method_46651(decrement));
            dropped = true;
        }
        return dropped;
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playDropContentsSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34375, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }
}

